/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.hosted;

import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.GraalConfiguration;
import com.oracle.svm.graal.GraalCompilerSupport;
import com.oracle.svm.graal.hosted.FieldsOffsetsFeature;
import com.oracle.svm.hosted.FeatureImpl;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.function.BooleanSupplier;
import jdk.graal.compiler.core.gen.NodeMatchRules;
import jdk.graal.compiler.core.match.MatchStatement;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.graph.Node;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

public class GraalCompilerFeature
implements InternalFeature {
    public List<Class<? extends Feature>> getRequiredFeatures() {
        return List.of(FieldsOffsetsFeature.class);
    }

    public void duringSetup(Feature.DuringSetupAccess c) {
        ImageSingletons.add(GraalCompilerSupport.class, (Object)new GraalCompilerSupport());
        ((FeatureImpl.DuringSetupAccessImpl)c).registerClassReachabilityListener(GraalCompilerSupport::registerPhaseStatistics);
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess c) {
        DebugContext debug = DebugContext.forCurrentThread();
        for (JavaKind kind : new JavaKind[]{JavaKind.Boolean, JavaKind.Byte, JavaKind.Char, JavaKind.Double, JavaKind.Float, JavaKind.Int, JavaKind.Long, JavaKind.Short}) {
            RuntimeReflection.register((Class[])new Class[]{kind.toBoxedJavaClass()});
            Class<?>[] innerClasses = kind.toBoxedJavaClass().getDeclaredClasses();
            if (innerClasses == null || innerClasses.length <= 0) continue;
            RuntimeReflection.register((Class[])new Class[]{innerClasses[0]});
            try {
                RuntimeReflection.register((Field[])new Field[]{innerClasses[0].getDeclaredField("cache")});
            }
            catch (Throwable t) {
                throw debug.handle(t);
            }
        }
        GraalCompilerSupport.allocatePhaseStatisticsCache();
        GraalCompilerSupport.get().setMatchRuleRegistry(new HashMap<Class<? extends NodeMatchRules>, EconomicMap<Class<? extends Node>, List<MatchStatement>>>());
        GraalConfiguration.runtimeInstance().populateMatchRuleRegistry(GraalCompilerSupport.get().getMatchRuleRegistry());
    }

    public static final class IsEnabled
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return ImageSingletons.contains(GraalCompilerFeature.class);
        }
    }
}

