/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.locks.VMSemaphore;
import com.oracle.svm.core.windows.WindowsVMLockSupport;
import com.oracle.svm.core.windows.headers.SynchAPI;
import com.oracle.svm.core.windows.headers.WinBase;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.VoidPointer;
import org.graalvm.word.WordFactory;

final class WindowsVMSemaphore
extends VMSemaphore {
    private WinBase.HANDLE hSemaphore;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    WindowsVMSemaphore(String name) {
        super(name);
    }

    @Override
    @Uninterruptible(reason="Too early for safepoints.")
    public int initialize() {
        this.hSemaphore = WinBase.CreateSemaphoreA((VoidPointer)WordFactory.nullPointer(), 0, Integer.MAX_VALUE, (VoidPointer)WordFactory.nullPointer());
        return this.hSemaphore.isNonNull() ? 0 : 1;
    }

    @Override
    @Uninterruptible(reason="The isolate teardown is in progress.")
    public int destroy() {
        int errorCode = WinBase.CloseHandle(this.hSemaphore);
        this.hSemaphore = (WinBase.HANDLE)WordFactory.nullPointer();
        return errorCode;
    }

    @Override
    public void await() {
        WindowsVMLockSupport.checkResult(SynchAPI.WaitForSingleObject(this.hSemaphore, SynchAPI.INFINITE()), "WaitForSingleObject");
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void signal() {
        WindowsVMLockSupport.checkResult(SynchAPI.NoTransitions.ReleaseSemaphore(this.hSemaphore, 1, (CIntPointer)WordFactory.nullPointer()), "ReleaseSemaphore");
    }
}

