/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.headers.LibC;
import com.oracle.svm.core.os.VirtualMemoryProvider;
import com.oracle.svm.core.pltgot.GOTHeapSupport;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.windows.headers.MemoryAPI;
import com.oracle.svm.core.windows.headers.WinBase;
import com.oracle.svm.core.windows.headers.WindowsLibC;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class WindowsGOTHeapSupport
extends GOTHeapSupport {
    private static final CGlobalData<WordPointer> GOT_MAPPING_HANDLE = CGlobalDataFactory.createWord();

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected int initialize(WordPointer gotStartAddress) {
        UnsignedWord alignedGotSize = WindowsGOTHeapSupport.getPageAlignedGotSize();
        WinBase.HANDLE gotMappingHandle = MemoryAPI.CreateFileMappingW(WinBase.INVALID_HANDLE_VALUE(), WordFactory.nullPointer(), MemoryAPI.PAGE_READWRITE(), 0, UnsignedUtils.safeToInt(alignedGotSize), (WindowsLibC.WCharPointer)WordFactory.nullPointer());
        if (gotMappingHandle.isNull()) {
            return 25;
        }
        Pointer gotMappedAddress = MemoryAPI.MapViewOfFile(gotMappingHandle, MemoryAPI.FILE_MAP_READ() | MemoryAPI.FILE_MAP_WRITE(), 0, 0, (UnsignedWord)WordFactory.zero());
        if (gotMappedAddress.isNull()) {
            WinBase.CloseHandle(gotMappingHandle);
            return 27;
        }
        Pointer gotStartInMemory = gotMappedAddress.add(WindowsGOTHeapSupport.getGotOffsetFromStartOfMapping());
        LibC.memcpy(gotStartInMemory, IMAGE_GOT_BEGIN.get(), WindowsGOTHeapSupport.getGotSectionSize());
        GOT_MAPPING_HANDLE.get().write((WordBase)gotMappingHandle);
        gotStartAddress.write((WordBase)gotMappedAddress);
        return 0;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int mapGot(Pointer address) {
        WinBase.HANDLE gotMappingHandle = (WinBase.HANDLE)GOT_MAPPING_HANDLE.get().read();
        if (gotMappingHandle.isNull()) {
            return 30;
        }
        Pointer mappedAddress = VirtualMemoryProvider.get().mapFile((PointerBase)address, WindowsGOTHeapSupport.getPageAlignedGotSize(), (WordBase)gotMappingHandle, (UnsignedWord)WordFactory.zero(), 1);
        if (mappedAddress.isNull()) {
            return 28;
        }
        return 0;
    }
}

