/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.heap.VMOperationInfos;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.thread.Safepoint;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.IsolateThread;

public final class ThreadSuspendSupport {
    private ThreadSuspendSupport() {
    }

    public static void suspend(Thread thread) {
        VMError.guarantee(!thread.isVirtual(), "must not be called for virtual threads");
        ThreadSuspendOperation op = new ThreadSuspendOperation(thread);
        op.enqueue();
    }

    public static void resume(Thread thread) {
        VMError.guarantee(!thread.isVirtual(), "must not be called for virtual threads");
        ThreadResumeOperation op = new ThreadResumeOperation(thread);
        op.enqueue();
    }

    private static void suspend(IsolateThread isolateThread) {
        VMThreads.guaranteeOwnsThreadMutex("Must own the THREAD_MUTEX to prevent races.");
        int newValue = Safepoint.suspendedTL.get(isolateThread) + 1;
        VMError.guarantee(newValue > 0, "Too many thread suspends.");
        Safepoint.suspendedTL.set(isolateThread, newValue);
    }

    private static void resume(IsolateThread isolateThread) {
        VMThreads.guaranteeOwnsThreadMutex("Must own the THREAD_MUTEX to prevent races.");
        int newValue = Safepoint.suspendedTL.get(isolateThread) - 1;
        VMError.guarantee(newValue >= 0, "Only a suspended thread can be resumed.");
        Safepoint.suspendedTL.set(isolateThread, newValue);
        if (newValue == 0) {
            Safepoint.COND_SUSPEND.broadcast();
        }
    }

    private static class ThreadSuspendOperation
    extends JavaVMOperation {
        private final Thread thread;

        ThreadSuspendOperation(Thread thread) {
            super(VMOperationInfos.get(ThreadSuspendOperation.class, "Thread Suspend", VMOperation.SystemEffect.SAFEPOINT));
            this.thread = thread;
        }

        @Override
        protected void operate() {
            IsolateThread isolateThread = PlatformThreads.getIsolateThread(this.thread);
            if (isolateThread.isNonNull()) {
                ThreadSuspendSupport.suspend(isolateThread);
            }
        }
    }

    private static class ThreadResumeOperation
    extends JavaVMOperation {
        private final Thread thread;

        ThreadResumeOperation(Thread thread) {
            super(VMOperationInfos.get(ThreadResumeOperation.class, "Thread Resume", VMOperation.SystemEffect.SAFEPOINT));
            this.thread = thread;
        }

        @Override
        protected void operate() {
            IsolateThread isolateThread = PlatformThreads.getIsolateThread(this.thread);
            if (isolateThread.isNonNull()) {
                ThreadSuspendSupport.resume(isolateThread);
            }
        }
    }
}

