/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK21OrEarlier;
import com.oracle.svm.core.jdk.JDKLatest;
import com.oracle.svm.core.thread.Target_java_lang_ScopedValue_Cache;
import com.oracle.svm.core.thread.Target_java_lang_ScopedValue_CallableOp;
import com.oracle.svm.core.thread.Target_java_lang_ScopedValue_Snapshot;
import com.oracle.svm.core.thread.Target_java_lang_Thread;
import com.oracle.svm.core.thread.Target_jdk_internal_vm_ScopedValueContainer;
import java.util.concurrent.Callable;

@TargetClass(className="java.lang.ScopedValue", innerClass={"Carrier"})
final class Target_java_lang_ScopedValue_Carrier {
    @Alias
    int bitmask;

    Target_java_lang_ScopedValue_Carrier() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Substitute
    @TargetElement(onlyWith={JDK21OrEarlier.class})
    @Uninterruptible(reason="Ensure no safepoint actions can disrupt reverting scoped value bindings.", calleeMustBe=false)
    private <R> R runWith(Target_java_lang_ScopedValue_Snapshot newSnapshot, Callable<R> op) throws Exception {
        Target_java_lang_Thread.setScopedValueBindings(newSnapshot);
        try {
            R r = Target_jdk_internal_vm_ScopedValueContainer.call(op);
            return r;
        }
        finally {
            Target_java_lang_Thread.setScopedValueBindings(newSnapshot.prev);
            Target_java_lang_ScopedValue_Cache.invalidate(this.bitmask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    @Uninterruptible(reason="Ensure no safepoint actions can disrupt reverting scoped value bindings.", calleeMustBe=false)
    private <R> R runWith(Target_java_lang_ScopedValue_Snapshot newSnapshot, Target_java_lang_ScopedValue_CallableOp op) throws Exception {
        Target_java_lang_Thread.setScopedValueBindings(newSnapshot);
        try {
            Object v = Target_jdk_internal_vm_ScopedValueContainer.call(op);
            return (R)v;
        }
        finally {
            Target_java_lang_Thread.setScopedValueBindings(newSnapshot.prev);
            Target_java_lang_ScopedValue_Cache.invalidate(this.bitmask);
        }
    }

    @Substitute
    @Uninterruptible(reason="Ensure no safepoint actions can disrupt reverting scoped value bindings.", calleeMustBe=false)
    private void runWith(Target_java_lang_ScopedValue_Snapshot newSnapshot, Runnable op) {
        Target_java_lang_Thread.setScopedValueBindings(newSnapshot);
        try {
            Target_jdk_internal_vm_ScopedValueContainer.run(op);
        }
        finally {
            Target_java_lang_Thread.setScopedValueBindings(newSnapshot.prev);
            Target_java_lang_ScopedValue_Cache.invalidate(this.bitmask);
        }
    }
}

