/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.darwin;

import com.oracle.svm.core.posix.headers.PosixDirectives;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.constant.CConstant;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.struct.CPointerTo;
import org.graalvm.nativeimage.c.struct.CStruct;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.PointerBase;

@CContext(value=PosixDirectives.class)
public class DarwinSemaphore {
    @CConstant
    public static native int KERN_ABORTED();

    @CConstant
    public static native int SYNC_POLICY_FIFO();

    @CFunction(transition=CFunction.Transition.TO_NATIVE)
    public static native int semaphore_wait(semaphore_t var0);

    public static class NoTransition {
        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        public static native int semaphore_create(WordPointer var0, semaphore_tPointer var1, int var2, int var3);

        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        public static native int semaphore_destroy(WordPointer var0, semaphore_t var1);

        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        public static native int semaphore_signal(semaphore_t var0);
    }

    @CStruct(value="semaphore", addStructKeyword=true, isIncomplete=true)
    public static interface semaphore_t
    extends PointerBase {
    }

    @CPointerTo(value=semaphore_t.class)
    public static interface semaphore_tPointer
    extends PointerBase {
        public semaphore_t read();
    }
}

