/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.locks;

import com.oracle.svm.core.util.VMError;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public final class ClassInstanceReplacer<S, T>
implements Function<Object, Object> {
    private final Class<S> sourceClass;
    private final List<T> imageHeapList;
    private final Function<S, T> createReplacement;
    private final Map<S, T> replacements = Collections.synchronizedMap(new IdentityHashMap());
    private boolean sealed;

    public ClassInstanceReplacer(Class<S> sourceClass, List<T> imageHeapList, Function<S, T> createReplacement) {
        this.sourceClass = sourceClass;
        this.imageHeapList = imageHeapList;
        this.createReplacement = createReplacement;
    }

    @Override
    public Object apply(Object object) {
        if (object == null || object.getClass() != this.sourceClass) {
            return object;
        }
        return this.replacements.computeIfAbsent(this.sourceClass.cast(object), this::doReplace);
    }

    private T doReplace(S object) {
        VMError.guarantee(!this.sealed, "new object introduced after static analysis");
        T replacement = this.createReplacement.apply(object);
        assert (replacement.getClass() != this.sourceClass) : "leads to recursive replacement";
        if (this.imageHeapList != null) {
            this.imageHeapList.add(replacement);
        }
        return replacement;
    }
}

