/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jvmstat;

import com.oracle.svm.core.jdk.DirectByteBufferUtil;
import com.oracle.svm.core.jvmstat.PerfMemoryPrologue;
import com.oracle.svm.core.jvmstat.PerfMemoryProvider;
import com.oracle.svm.core.memory.NativeMemory;
import com.oracle.svm.core.nmt.NmtCategory;
import java.nio.ByteBuffer;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

public class CHeapPerfMemoryProvider
implements PerfMemoryProvider {
    private Pointer memory;

    @Override
    public ByteBuffer create() {
        int size = PerfMemoryPrologue.getPrologueSize();
        this.memory = (Pointer)NativeMemory.calloc(size, NmtCategory.JvmStat);
        return DirectByteBufferUtil.allocate(this.memory.rawValue(), size);
    }

    @Override
    public void teardown() {
        if (this.memory.isNonNull()) {
            NativeMemory.free((PointerBase)this.memory);
            this.memory = (Pointer)WordFactory.nullPointer();
        }
    }
}

