/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.jfr.Target_jdk_jfr_internal_Utils;
import com.oracle.svm.core.jfr.Target_jdk_jfr_internal_util_ValueFormatter;
import java.time.LocalDateTime;
import jdk.graal.compiler.serviceprovider.JavaVersionUtil;
import jdk.jfr.Recording;
import org.graalvm.nativeimage.ProcessProperties;

final class JfrFilenameUtil {
    JfrFilenameUtil() {
    }

    public static String makeFilename(Recording recording) {
        long pid = ProcessProperties.getProcessID();
        String date = JfrFilenameUtil.getFormatDateTime();
        String idText = recording == null ? "" : "-id-" + recording.getId();
        String imageName = SubstrateOptions.Name.getValue();
        return imageName + "-pid-" + pid + idText + "-" + date + ".jfr";
    }

    private static String getFormatDateTime() {
        LocalDateTime now = LocalDateTime.now();
        if (JavaVersionUtil.JAVA_SPEC >= 24) {
            return Target_jdk_jfr_internal_util_ValueFormatter.formatDateTime(now);
        }
        return Target_jdk_jfr_internal_Utils.formatDateTime(now);
    }
}

