/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.resources.CompressedGlobTrie;

import com.oracle.svm.core.jdk.resources.CompressedGlobTrie.DoubleStarNode;
import com.oracle.svm.core.jdk.resources.CompressedGlobTrie.GlobTrieNode;
import com.oracle.svm.core.jdk.resources.CompressedGlobTrie.GlobUtils;
import com.oracle.svm.core.jdk.resources.CompressedGlobTrie.LiteralNode;
import com.oracle.svm.core.jdk.resources.CompressedGlobTrie.StarTrieNode;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class CompressedGlobTrie {
    private static final Pattern threeConsecutiveStarsRegex = Pattern.compile(".*[*]{3,}.*");
    private static final Pattern emptyLevelsRegex = Pattern.compile(".*/{2,}.*");

    public static <C> void finalize(GlobTrieNode<C> root) {
        root.trim();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static <C> List<C> getHostedOnlyContentIfMatched(GlobTrieNode<C> root, String text) {
        ArrayList<GlobTrieNode<C>> matchedNodes = new ArrayList<GlobTrieNode<C>>();
        CompressedGlobTrie.getAllPatterns(root, CompressedGlobTrie.getPatternParts(text), 0, matchedNodes);
        if (matchedNodes.isEmpty()) {
            return null;
        }
        ArrayList additionalContexts = new ArrayList();
        matchedNodes.forEach(node -> additionalContexts.addAll(node.getHostedOnlyContent()));
        return additionalContexts;
    }

    public static <C> boolean match(GlobTrieNode<C> root, String text) {
        String escapedText = CompressedGlobTrie.escapeAllStars(text);
        ArrayList<GlobTrieNode<C>> tmp = new ArrayList<GlobTrieNode<C>>();
        CompressedGlobTrie.getAllPatterns(root, CompressedGlobTrie.getPatternParts(escapedText), 0, tmp);
        return !tmp.isEmpty();
    }

    private static String escapeAllStars(String text) {
        return text.replace("*", "\\*");
    }

    public static <C> String validatePattern(String pattern) {
        StringBuilder sb = new StringBuilder();
        if (pattern.isEmpty()) {
            sb.append("Pattern ").append(pattern).append(" : Pattern cannot be empty. ");
            return sb.toString();
        }
        if (threeConsecutiveStarsRegex.matcher(pattern).matches()) {
            sb.append("Pattern contains more than two consecutive * characters. ");
        }
        if (emptyLevelsRegex.matcher(pattern).matches()) {
            sb.append("Pattern contains empty levels. ");
        }
        if (pattern.contains("**/**")) {
            sb.append("Pattern contains invalid sequence **/**. Valid pattern should have ** followed by something other than **. ");
        }
        boolean escapeMode = false;
        for (int i = 0; i < pattern.length(); ++i) {
            char current = pattern.charAt(i);
            if (GlobUtils.ALWAYS_ESCAPED_GLOB_WILDCARDS.contains(Character.valueOf(current)) && !escapeMode) {
                sb.append("Pattern contains unescaped character ").append(current).append(". ");
            }
            escapeMode = current == '\\';
        }
        List<GlobTrieNode<C>> patternParts = CompressedGlobTrie.getPatternParts(pattern);
        for (GlobTrieNode<C> part : patternParts) {
            if (part instanceof LiteralNode) break;
            if (!(part instanceof DoubleStarNode)) continue;
            sb.append("Pattern contains ** without previous literal. This pattern is too generic and therefore can match many resources. Please make the pattern more specific by adding non-generic level before ** level.");
        }
        if (!sb.isEmpty()) {
            sb.insert(0, "Pattern " + pattern + " : ");
        }
        return sb.toString();
    }

    public static <C> List<GlobTrieNode<C>> getPatternParts(String glob) {
        String pattern = !glob.endsWith("/") ? glob : glob.substring(0, glob.length() - 1);
        ArrayList<GlobTrieNode<C>> parts = new ArrayList<GlobTrieNode<C>>();
        List<String> levels = Arrays.stream(pattern.split("/")).toList();
        for (String level : levels) {
            if (level.equals("**")) {
                DoubleStarNode tmp = new DoubleStarNode();
                tmp.setNewLevel();
                parts.add(tmp);
                continue;
            }
            if (level.equals("*")) {
                StarTrieNode tmp = new StarTrieNode(true);
                tmp.setNewLevel();
                parts.add(tmp);
                continue;
            }
            int s = level.indexOf("*".charAt(0));
            if (s != -1) {
                ArrayList<GlobTrieNode> thisLevelParts = new ArrayList<GlobTrieNode>();
                StringBuilder currentPart = new StringBuilder();
                StarCollectorMode currentMode = StarCollectorMode.NORMAL;
                for (char c : level.toCharArray()) {
                    currentPart.append(c);
                    if (c == "*".charAt(0) && currentMode == StarCollectorMode.NORMAL) {
                        thisLevelParts.add(new StarTrieNode(currentPart.toString()));
                        currentPart.setLength(0);
                    }
                    currentMode = c == '\\' ? StarCollectorMode.ESCAPE : StarCollectorMode.NORMAL;
                }
                if (!currentPart.isEmpty()) {
                    thisLevelParts.add(new LiteralNode(currentPart.toString()));
                }
                ((GlobTrieNode)thisLevelParts.get(0)).setNewLevel();
                parts.addAll(thisLevelParts);
                continue;
            }
            LiteralNode tmp = new LiteralNode(level);
            tmp.setNewLevel();
            parts.add(tmp);
        }
        return parts;
    }

    private static <C> void getAllPatterns(GlobTrieNode<C> node, List<GlobTrieNode<C>> parts, int i, List<GlobTrieNode<C>> matches) {
        if (CompressedGlobTrie.patternReachedEnd(i, parts)) {
            if (node.isLeaf()) {
                matches.add(node);
            }
            return;
        }
        DoubleStarNode<C> doubleStar = node.getDoubleStarNode();
        if (doubleStar != null) {
            for (MatchedNode<C> matchedNode : CompressedGlobTrie.getAllAvailablePaths(doubleStar, parts, i)) {
                CompressedGlobTrie.getAllPatterns(matchedNode.child(), parts, matchedNode.lastMatchedChildIndex() + 1, matches);
            }
        }
        SquashedParts sp = CompressedGlobTrie.getThisLevel(parts, i);
        for (StarTrieNode<C> child3 : node.getChildrenWithStar()) {
            for (GlobTrieNode<C> c : CompressedGlobTrie.matchOneLevel(child3, sp.squashedPart())) {
                CompressedGlobTrie.getAllPatterns(c, parts, i + sp.numberOfSquashedParts() + 1, matches);
            }
        }
        GlobTrieNode<C> globTrieNode = parts.get(i);
        if (globTrieNode instanceof StarTrieNode || globTrieNode instanceof DoubleStarNode) {
            return;
        }
        GlobTrieNode<C> child = node.getChild(globTrieNode.getContent());
        if (child == null) {
            return;
        }
        CompressedGlobTrie.getAllPatterns(child, parts, i + 1, matches);
    }

    private static <C> List<MatchedNode<C>> getAllAvailablePaths(DoubleStarNode<C> node, List<GlobTrieNode<C>> parts, int i) {
        ArrayList<MatchedNode<C>> successors = new ArrayList<MatchedNode<C>>();
        if (node.isLeaf()) {
            return List.of(new MatchedNode<C>(node, parts.size()));
        }
        for (int j = i; j < parts.size(); ++j) {
            GlobTrieNode child2;
            SquashedParts sp = CompressedGlobTrie.getThisLevel(parts, j);
            for (GlobTrieNode child2 : node.getChildrenWithStar()) {
                int finalJ = j;
                successors.addAll(CompressedGlobTrie.matchOneLevel(child2, sp.squashedPart()).stream().map(c -> new MatchedNode(c, finalJ + sp.numberOfSquashedParts())).toList());
            }
            GlobTrieNode<C> part = parts.get(j);
            if (part instanceof StarTrieNode) continue;
            child2 = node.getChild(part.getContent());
            if (!part.isNewLevel() || child2 == null) continue;
            successors.add(new MatchedNode(child2, j));
        }
        return successors;
    }

    private static int getIndexOfFirstUnescapedStar(String level) {
        StarCollectorMode currentMode = StarCollectorMode.NORMAL;
        for (int i = 0; i < level.length(); ++i) {
            char c = level.charAt(i);
            if (c == "*".charAt(0) && currentMode == StarCollectorMode.NORMAL) {
                return i;
            }
            currentMode = c == '\\' ? StarCollectorMode.ESCAPE : StarCollectorMode.NORMAL;
        }
        return -1;
    }

    private static <C> List<GlobTrieNode<C>> matchOneLevel(StarTrieNode<C> node, String wholeLevel) {
        if (node.isMatchingWholeLevel()) {
            return List.of(node);
        }
        String nodeContent = node.getContent();
        String prefix = nodeContent.substring(0, CompressedGlobTrie.getIndexOfFirstUnescapedStar(nodeContent));
        if (!prefix.equals("*") && !wholeLevel.startsWith(prefix)) {
            return Collections.emptyList();
        }
        String remainingLevel = wholeLevel.substring(wholeLevel.indexOf(prefix) + prefix.length());
        if (!node.hasChildrenOnThisLevel()) {
            return List.of(node);
        }
        ArrayList<GlobTrieNode<C>> potentialChildren = new ArrayList<GlobTrieNode<C>>();
        for (LiteralNode literalNode : node.getChildrenWithLiteral()) {
            String suffix;
            if (literalNode.isNewLevel() || !remainingLevel.endsWith(suffix = literalNode.getContent())) continue;
            potentialChildren.add(literalNode);
        }
        block1: for (StarTrieNode starTrieNode : node.getChildrenWithStar()) {
            if (starTrieNode.isNewLevel()) continue;
            StarTrieNode tmpChild = starTrieNode;
            while (true) {
                GlobTrieNode potentialChild;
                String childContent;
                String childPrefix;
                int nextOccurrence;
                if ((nextOccurrence = remainingLevel.indexOf(childPrefix = (childContent = tmpChild.getContent()).substring(0, childContent.indexOf("*".charAt(0))))) != -1) {
                    potentialChildren.addAll(CompressedGlobTrie.matchOneLevel(tmpChild, remainingLevel.substring(nextOccurrence)));
                }
                if ((potentialChild = tmpChild.getChildFromSameLevel(tmpChild.getContent())) == null) continue block1;
                tmpChild = (StarTrieNode)potentialChild;
            }
        }
        return potentialChildren;
    }

    private static <C> boolean simplePatternMatch(GlobTrieNode<C> root, GlobTrieNode<C> part) {
        if (root instanceof StarTrieNode || root instanceof DoubleStarNode || part instanceof StarTrieNode || part instanceof DoubleStarNode) {
            return false;
        }
        return root.getChild(part.getContent()) != null;
    }

    private static <C> SquashedParts getThisLevel(List<GlobTrieNode<C>> parts, int begin) {
        GlobTrieNode<C> nextPart;
        StringBuilder sb = new StringBuilder(parts.get(begin).getContent());
        int numberOfSquashedParts = 0;
        for (int i = begin + 1; i < parts.size() && !(nextPart = parts.get(i)).isNewLevel(); ++i) {
            sb.append(nextPart.getContent());
            ++numberOfSquashedParts;
        }
        return new SquashedParts(sb.toString(), numberOfSquashedParts);
    }

    private static <C> boolean patternReachedEnd(int index, List<GlobTrieNode<C>> parts) {
        return index >= parts.size();
    }

    public static <C> void removeNodes(GlobTrieNode<C> head, Predicate<C> shouldRemove) {
        List contentToRemove = head.getHostedOnlyContent().stream().filter(shouldRemove).toList();
        head.removeHostedOnlyContent(contentToRemove);
        ArrayList childrenToRemove = new ArrayList();
        for (GlobTrieNode<C> child : head.getChildren()) {
            CompressedGlobTrie.removeNodes(child, shouldRemove);
            if (child.isLeaf() && child.getHostedOnlyContent().isEmpty()) {
                if (child.getChildren().isEmpty()) {
                    childrenToRemove.add(child);
                    continue;
                }
                child.makeNodeInternal();
                continue;
            }
            if (child.isLeaf() || !child.getChildren().isEmpty()) continue;
            childrenToRemove.add(child);
        }
        head.removeChildren(childrenToRemove);
    }

    private static enum StarCollectorMode {
        NORMAL,
        ESCAPE;

    }

    private record MatchedNode<C>(GlobTrieNode<C> child, int lastMatchedChildIndex) {
    }

    private record SquashedParts(String squashedPart, int numberOfSquashedParts) {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static class CompressedGlobTrieBuilder<C> {
        public static <C> GlobTrieNode<C> build(List<GlobWithInfo<C>> patterns) {
            GlobTrieNode root = new GlobTrieNode();
            ArrayList<GlobWithInfo<C>> doubleStarPatterns = new ArrayList<GlobWithInfo<C>>();
            ArrayList<GlobWithInfo<C>> starPatterns = new ArrayList<GlobWithInfo<C>>();
            ArrayList<GlobWithInfo<C>> noStarPatterns = new ArrayList<GlobWithInfo<C>>();
            List<String> invalidPatterns = CompressedGlobTrieBuilder.classifyPatterns(patterns, doubleStarPatterns, starPatterns, noStarPatterns);
            if (!invalidPatterns.isEmpty()) {
                StringBuilder sb = new StringBuilder("Error: invalid glob patterns found:" + System.lineSeparator());
                invalidPatterns.forEach(msg -> sb.append((String)msg).append(System.lineSeparator()));
                throw UserError.abort(sb.toString(), new Object[0]);
            }
            doubleStarPatterns.sort(CompressedGlobTrieBuilder::comparePatterns);
            starPatterns.sort(CompressedGlobTrieBuilder::comparePatterns);
            doubleStarPatterns.forEach(pattern -> CompressedGlobTrieBuilder.addPattern(root, pattern));
            starPatterns.forEach(pattern -> CompressedGlobTrieBuilder.addPattern(root, pattern));
            noStarPatterns.forEach(pattern -> CompressedGlobTrieBuilder.addPattern(root, pattern));
            return root;
        }

        private static String unescapePossibleWildcards(String pattern) {
            String unescapedPattern = pattern;
            for (char esc : GlobUtils.ALWAYS_ESCAPED_GLOB_WILDCARDS) {
                unescapedPattern = unescapedPattern.replace("\\" + esc, String.valueOf(esc));
            }
            return unescapedPattern;
        }

        private static <C> void addPattern(GlobTrieNode<C> root, GlobWithInfo<C> pattern) {
            String unescapedPattern = CompressedGlobTrieBuilder.unescapePossibleWildcards(pattern.pattern());
            List parts = CompressedGlobTrie.getPatternParts(unescapedPattern);
            ArrayList reachableNodes = new ArrayList();
            CompressedGlobTrie.getAllPatterns(root, parts, 0, reachableNodes);
            if (!reachableNodes.isEmpty()) {
                for (GlobTrieNode globTrieNode : reachableNodes) {
                    if (!globTrieNode.getHostedOnlyContent().stream().anyMatch(c -> c.equals(pattern.additionalContent()))) continue;
                    return;
                }
            }
            CompressedGlobTrieBuilder.addPattern(root, parts, 0, pattern.additionalContent());
        }

        private static <C> void addPattern(GlobTrieNode<C> root, List<GlobTrieNode<C>> parts, int i, C additionalInfo) {
            if (CompressedGlobTrie.patternReachedEnd(i, parts)) {
                root.setLeaf();
                root.addHostedOnlyContent(additionalInfo);
                return;
            }
            GlobTrieNode<C> nextPart = parts.get(i);
            boolean canProceed = CompressedGlobTrie.simplePatternMatch(root, nextPart);
            if (canProceed) {
                CompressedGlobTrieBuilder.addPattern(root.getChild(nextPart.getContent()), parts, i + 1, additionalInfo);
                return;
            }
            CompressedGlobTrieBuilder.addNewBranch(root, parts, i, additionalInfo);
        }

        private static <C> void addNewBranch(GlobTrieNode<C> root, List<GlobTrieNode<C>> parts, int i, C additionalInfo) {
            if (parts.isEmpty() || i >= parts.size()) {
                return;
            }
            GlobTrieNode<C> newNode = null;
            for (int j = i; j < parts.size(); ++j) {
                GlobTrieNode<C> part = parts.get(j);
                newNode = newNode == null ? root.addChild(part.getContent(), part) : newNode.addChild(part.getContent(), part);
            }
            newNode.setLeaf();
            newNode.addHostedOnlyContent(additionalInfo);
        }

        private static <C> List<String> classifyPatterns(List<GlobWithInfo<C>> patterns, List<GlobWithInfo<C>> doubleStar, List<GlobWithInfo<C>> singleStar, List<GlobWithInfo<C>> noStar) {
            ArrayList<String> invalidPatterns = new ArrayList<String>();
            for (GlobWithInfo<C> patternWithInfo : patterns) {
                String error = CompressedGlobTrie.validatePattern(patternWithInfo.pattern());
                if (!error.isEmpty()) {
                    invalidPatterns.add(error);
                    continue;
                }
                String pattern = patternWithInfo.pattern();
                if (pattern.indexOf("**") != -1) {
                    doubleStar.add(patternWithInfo);
                    continue;
                }
                if (pattern.indexOf("*".charAt(0)) != -1) {
                    singleStar.add(patternWithInfo);
                    continue;
                }
                noStar.add(patternWithInfo);
            }
            return invalidPatterns;
        }

        private static int comparePatterns(GlobWithInfo<?> n1, GlobWithInfo<?> n2) {
            String s1 = n1.pattern();
            String s2 = n2.pattern();
            List<String> s1Levels = Arrays.stream(s1.split("/")).toList();
            List<String> s2Levels = Arrays.stream(s2.split("/")).toList();
            int i = 0;
            while (i < s1Levels.size() && i < s2Levels.size()) {
                String s1Level = s1Levels.get(i);
                String s2Level = s2Levels.get(i);
                int s1DoubleStar = s1Level.indexOf("**");
                int s2DoubleStar = s2Level.indexOf("**");
                if (s1DoubleStar != -1 || s2DoubleStar != -1) {
                    if (s1DoubleStar == -1) {
                        return 1;
                    }
                    if (s2DoubleStar == -1) {
                        return -1;
                    }
                    ++i;
                    continue;
                }
                int s1Star = s1Level.indexOf("*".charAt(0));
                int s2Star = s2Level.indexOf("*".charAt(0));
                if (s1Star != -1 && s2Star != -1) {
                    int len2;
                    int len1Stars = StringUtil.numberOfCharsInString((char)"*".charAt(0), (String)s1Level);
                    int len2Stars = StringUtil.numberOfCharsInString((char)"*".charAt(0), (String)s2Level);
                    int len1 = s1Level.length() - len1Stars;
                    if (len1 == (len2 = s2Level.length() - len2Stars)) {
                        if (len1Stars != len2Stars) {
                            return len2Stars - len1Stars;
                        }
                        if (s1Level.equals(s2Level)) {
                            ++i;
                            continue;
                        }
                        return s1Levels.size() - s2Levels.size();
                    }
                    return len1 - len2;
                }
                if (s1Star == -1 && s2Star == -1) {
                    if (s1Level.compareTo(s2Level) == 0) {
                        ++i;
                        continue;
                    }
                    return s1Levels.size() - s2Levels.size();
                }
                return s1Star == -1 ? 1 : -1;
            }
            return s1Levels.size() - s2Levels.size();
        }
    }

    public record GlobWithInfo<C>(String pattern, C additionalContent) {
    }
}

