/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

final class NCPUAccessor {
    private static int cachedNCPU = -1;

    NCPUAccessor() {
    }

    static int get() {
        if (cachedNCPU != -1) {
            return cachedNCPU;
        }
        return NCPUAccessor.initializeNCPU();
    }

    private static synchronized int initializeNCPU() {
        if (cachedNCPU != -1) {
            return cachedNCPU;
        }
        cachedNCPU = Runtime.getRuntime().availableProcessors();
        return cachedNCPU;
    }

    static synchronized void set(int value) {
        cachedNCPU = value;
    }
}

