/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.stackvalue;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.graal.stackvalue.StackValueNode;
import java.lang.reflect.AnnotatedElement;
import jdk.graal.compiler.graph.IterableNodeType;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.AbstractStateSplit;
import jdk.graal.compiler.nodes.ValueNodeInterface;
import jdk.graal.compiler.nodes.memory.MemoryAccess;
import jdk.graal.compiler.nodes.memory.MemoryKill;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.word.LocationIdentity;

@NodeInfo
public abstract class AbstractStackValueNode
extends AbstractStateSplit
implements Lowerable,
MemoryAccess,
IterableNodeType {
    public static final NodeClass<AbstractStackValueNode> TYPE = NodeClass.create(AbstractStackValueNode.class);
    @Node.OptionalInput(value=InputType.Memory)
    MemoryKill lastLocationAccess;
    protected final int alignmentInBytes;
    protected final StackValueNode.StackSlotIdentity slotIdentity;
    protected final boolean checkVirtualThread;

    protected AbstractStackValueNode(NodeClass<? extends AbstractStackValueNode> type, int alignmentInBytes, StackValueNode.StackSlotIdentity slotIdentity, boolean checkVirtualThread) {
        super(type, FrameAccess.getWordStamp());
        this.alignmentInBytes = alignmentInBytes;
        this.slotIdentity = slotIdentity;
        this.checkVirtualThread = checkVirtualThread;
    }

    public int getAlignmentInBytes() {
        return this.alignmentInBytes;
    }

    public LocationIdentity getLocationIdentity() {
        if (this.checkVirtualThread) {
            return LocationIdentity.any();
        }
        return MemoryKill.NO_LOCATION;
    }

    public MemoryKill getLastLocationAccess() {
        return this.lastLocationAccess;
    }

    public void setLastLocationAccess(MemoryKill lla) {
        this.updateUsagesInterface((ValueNodeInterface)this.lastLocationAccess, (ValueNodeInterface)lla);
        this.lastLocationAccess = lla;
    }

    protected static boolean needsVirtualThreadCheck(ResolvedJavaMethod method, boolean disallowVirtualThread) {
        return disallowVirtualThread && !Uninterruptible.Utils.isUninterruptible((AnnotatedElement)method);
    }

    protected static StackValueNode.StackSlotIdentity createStackSlotIdentity(ResolvedJavaMethod method, int bci) {
        String name = method.asStackTraceElement(bci).toString();
        return new StackValueNode.StackSlotIdentity(name, false);
    }
}

