/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.phases;

import com.oracle.svm.core.graal.nodes.LoweredDeadEndNode;
import java.util.ArrayDeque;
import jdk.graal.compiler.graph.Graph;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeBitMap;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.ControlSinkNode;
import jdk.graal.compiler.nodes.ControlSplitNode;
import jdk.graal.compiler.nodes.DeadEndNode;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.MergeNode;
import jdk.graal.compiler.nodes.ProfileData;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.UnwindNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.WithExceptionNode;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.extended.SwitchNode;
import jdk.graal.compiler.phases.Phase;

public class OptimizeExceptionPathsPhase
extends Phase {
    protected void run(StructuredGraph graph) {
        NodeBitMap exceptionPaths = new NodeBitMap((Graph)graph);
        for (UnwindNode unwind : graph.getNodes(UnwindNode.TYPE)) {
            OptimizeExceptionPathsPhase.walkBack((ControlSinkNode)unwind, exceptionPaths);
        }
        for (Object deadEnd : graph.getNodes(DeadEndNode.TYPE)) {
            OptimizeExceptionPathsPhase.walkBack((ControlSinkNode)deadEnd, exceptionPaths);
        }
        for (Object deadEnd : graph.getNodes(LoweredDeadEndNode.TYPE)) {
            OptimizeExceptionPathsPhase.walkBack((ControlSinkNode)deadEnd, exceptionPaths);
        }
        for (Node n : exceptionPaths) {
            AbstractBeginNode exceptionBegin = (AbstractBeginNode)n;
            ControlSplitNode controlSplitNode = (ControlSplitNode)exceptionBegin.predecessor();
            if (controlSplitNode.getProfileData().getProfileSource() == ProfileData.ProfileSource.PROFILED) continue;
            controlSplitNode.setProbability(exceptionBegin, BranchProbabilityNode.EXTREMELY_SLOW_PATH_PROFILE);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void walkBack(ControlSinkNode sink, NodeBitMap exceptionPaths) {
        worklist = new ArrayDeque<Object>();
        worklist.push(sink);
        block0: while (!worklist.isEmpty()) {
            node = (Node)worklist.pop();
            predecessor = node.predecessor();
            while (predecessor != null) {
                if (!(predecessor instanceof IfNode) && !(predecessor instanceof SwitchNode) || !(node instanceof AbstractBeginNode)) ** GOTO lbl20
                allSuccessorsInExceptionPaths = true;
                for (Node sux : predecessor.successors()) {
                    if (sux == node || exceptionPaths.contains(sux)) continue;
                    allSuccessorsInExceptionPaths = false;
                    break;
                }
                if (allSuccessorsInExceptionPaths) {
                    for (Node sux : predecessor.successors()) {
                        exceptionPaths.clear(sux);
                    }
                } else {
                    exceptionPaths.mark(node);
                    continue block0;
lbl20:
                    // 1 sources

                    if (predecessor instanceof MergeNode) {
                        for (ValueNode endNode : ((MergeNode)predecessor).cfgPredecessors()) {
                            worklist.push(endNode);
                        }
                        continue block0;
                    }
                    if (predecessor instanceof WithExceptionNode != false && node instanceof AbstractBeginNode != false ? node == ((WithExceptionNode)predecessor).exceptionEdge() : predecessor instanceof AbstractMergeNode != false || predecessor instanceof ControlSplitNode != false) continue block0;
                }
                node = predecessor;
                predecessor = node.predecessor();
            }
        }
    }
}

