/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.aarch64;

import com.oracle.svm.core.meta.SubstrateMethodPointerConstant;
import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.StandardOp;
import jdk.graal.compiler.lir.aarch64.AArch64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.Value;

public final class AArch64LoadMethodPointerConstantOp
extends AArch64LIRInstruction
implements StandardOp.LoadConstantOp {
    public static final LIRInstructionClass<AArch64LoadMethodPointerConstantOp> TYPE = LIRInstructionClass.create(AArch64LoadMethodPointerConstantOp.class);
    private final SubstrateMethodPointerConstant constant;
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.HINT})
    private AllocatableValue result;

    AArch64LoadMethodPointerConstantOp(AllocatableValue result, SubstrateMethodPointerConstant constant) {
        super(TYPE);
        this.constant = constant;
        this.result = result;
    }

    protected void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        Register resultReg = ValueUtil.asRegister((Value)this.result);
        crb.recordInlineDataInCode((Constant)this.constant);
        masm.adrpAdd(resultReg);
    }

    public AllocatableValue getResult() {
        return this.result;
    }

    public Constant getConstant() {
        return this.constant;
    }

    public boolean canRematerializeToStack() {
        return false;
    }
}

