/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge.remset;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.SerialGCOptions;
import com.oracle.svm.core.genscavenge.graal.BarrierSnippets;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.heap.ReferenceInternals;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.InteriorObjRefWalker;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.UnsignedUtils;
import java.lang.ref.Reference;
import jdk.graal.compiler.api.directives.GraalDirectives;
import jdk.graal.compiler.core.common.SuppressFBWarnings;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.replacements.ReplacementsUtil;
import jdk.graal.compiler.word.Word;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

final class CardTable {
    public static final int BYTES_COVERED_BY_ENTRY = 512;
    static final byte DIRTY_ENTRY = 0;
    static final byte CLEAN_ENTRY = 1;
    static final UnsignedWord CLEAN_WORD = WordFactory.unsigned((long)0x101010101010101L);
    private static final CardTableVerificationVisitor CARD_TABLE_VERIFICATION_VISITOR = new CardTableVerificationVisitor();

    private CardTable() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void cleanTable(Pointer tableStart, UnsignedWord size) {
        UnmanagedMemoryUtil.fill(tableStart, size, (byte)1);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void setDirty(Pointer table, UnsignedWord index) {
        byte valueBefore = table.readByte((WordBase)index, BarrierSnippets.CARD_REMEMBERED_SET_LOCATION);
        if (BranchProbabilityNode.probability((double)0.6, (valueBefore != 0 ? 1 : 0) != 0)) {
            table.writeByte((WordBase)index, (byte)0, BarrierSnippets.CARD_REMEMBERED_SET_LOCATION);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void setClean(Pointer table, UnsignedWord index) {
        table.writeByte((WordBase)index, (byte)1, BarrierSnippets.CARD_REMEMBERED_SET_LOCATION);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isDirty(Pointer table, UnsignedWord index) {
        int entry = CardTable.readEntry(table, index);
        return entry == 0;
    }

    private static boolean isClean(Pointer table, UnsignedWord index) {
        int entry = CardTable.readEntry(table, index);
        return entry == 1;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static int readEntry(Pointer table, UnsignedWord index) {
        byte entry = table.readByte((WordBase)index);
        if (GraalDirectives.inIntrinsic()) {
            ReplacementsUtil.dynamicAssert((entry == 1 || entry == 0 ? 1 : 0) != 0, (String)"valid entry");
        } else assert (entry == 1 || entry == 0);
        return entry;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord memoryOffsetToIndex(UnsignedWord offset) {
        return offset.unsignedDivide(512);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Pointer cardToHeapAddress(Pointer cardTableStart, Pointer cardAddr, Pointer objectsStart) {
        UnsignedWord offset = cardAddr.subtract((UnsignedWord)cardTableStart).multiply(512);
        return objectsStart.add(offset);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord tableSizeForMemorySize(UnsignedWord memorySize) {
        return CardTable.indexLimitForMemorySize(memorySize);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord indexLimitForMemorySize(UnsignedWord memorySize) {
        UnsignedWord roundedMemory = UnsignedUtils.roundUp(memorySize, WordFactory.unsigned((int)512));
        return CardTable.memoryOffsetToIndex(roundedMemory);
    }

    public static boolean verify(Pointer cardTableStart, Pointer cardTableEnd, Pointer objectsStart, Pointer objectsLimit) {
        boolean success = true;
        if (SerialGCOptions.VerifyRememberedSet.getValue().booleanValue()) {
            Pointer curPtr = objectsStart;
            while (curPtr.belowThan((UnsignedWord)objectsLimit)) {
                Object obj = curPtr.toObject();
                UnsignedWord cardTableIndex = CardTable.memoryOffsetToIndex((UnsignedWord)curPtr.subtract((UnsignedWord)objectsStart));
                if (CardTable.isClean(cardTableStart, cardTableIndex)) {
                    CARD_TABLE_VERIFICATION_VISITOR.initialize(obj, cardTableStart, objectsStart);
                    InteriorObjRefWalker.walkObject(obj, CARD_TABLE_VERIFICATION_VISITOR);
                    success &= CardTable.CARD_TABLE_VERIFICATION_VISITOR.success;
                    CARD_TABLE_VERIFICATION_VISITOR.reset();
                    DynamicHub hub = KnownIntrinsics.readHub(obj);
                    if (hub.isReferenceInstanceClass()) {
                        Reference ref = (Reference)obj;
                        success &= CardTable.verifyReferent(ref, cardTableStart, objectsStart);
                    }
                }
                curPtr = LayoutEncoding.getObjectEndInGC(obj);
            }
        } else {
            Pointer pos = cardTableStart;
            while (pos.belowThan((UnsignedWord)cardTableEnd)) {
                byte v = pos.readByte(0);
                if (v != 0 && v != 1) {
                    Log.log().string("Card at ").zhex((WordBase)pos).string(" is neither dirty nor clean: ").zhex(v).newline();
                    return false;
                }
                pos = pos.add(1);
            }
        }
        return success;
    }

    private static boolean verifyReferent(Reference<?> ref, Pointer cardTableStart, Pointer objectsStart) {
        return CardTable.verifyReference(ref, cardTableStart, objectsStart, ReferenceInternals.getReferentFieldAddress(ref), ReferenceInternals.getReferentPointer(ref));
    }

    private static boolean verifyReference(Object parentObject, Pointer cardTableStart, Pointer objectsStart, Pointer reference, Pointer referencedObject) {
        if (referencedObject.isNull() || HeapImpl.getHeapImpl().isInImageHeap(referencedObject) || HeapImpl.getHeapImpl().isInImageHeap(parentObject) && !HeapImpl.usesImageHeapCardMarking()) {
            return true;
        }
        Object obj = referencedObject.toObject();
        HeapChunk.Header<?> objChunk = HeapChunk.getEnclosingHeapChunk(obj);
        boolean fromImageHeap = HeapImpl.getHeapImpl().isInImageHeap(parentObject);
        if (fromImageHeap || HeapChunk.getSpace(objChunk).isYoungSpace()) {
            UnsignedWord cardTableIndex = CardTable.memoryOffsetToIndex((UnsignedWord)Word.objectToUntrackedPointer((Object)parentObject).subtract((UnsignedWord)objectsStart));
            Pointer cardTableAddress = cardTableStart.add(cardTableIndex);
            Log.log().string("Object ").zhex((WordBase)Word.objectToUntrackedPointer((Object)parentObject)).string(" (").string(parentObject.getClass().getName()).character(')').string(fromImageHeap ? ", which is in the image heap, " : " ").string("has an object reference at ").zhex((WordBase)reference).string(" that points to ").zhex((WordBase)referencedObject).string(" (").string(obj.getClass().getName()).string("), ").string("which is in the ").string(fromImageHeap ? "runtime heap" : "young generation").string(". ").string("However, the card table at ").zhex((WordBase)cardTableAddress).string(" is clean.").newline();
            return false;
        }
        return true;
    }

    private static class CardTableVerificationVisitor
    implements ObjectReferenceVisitor {
        private Object parentObject;
        private Pointer cardTableStart;
        private Pointer objectsStart;
        private boolean success;

        private CardTableVerificationVisitor() {
        }

        public void initialize(Object parentObject, Pointer cardTableStart, Pointer objectsStart) {
            assert (this.parentObject == null && this.cardTableStart.isNull() && this.objectsStart.isNull() && !this.success);
            this.parentObject = parentObject;
            this.cardTableStart = cardTableStart;
            this.objectsStart = objectsStart;
            this.success = true;
        }

        public void reset() {
            this.parentObject = null;
            this.cardTableStart = (Pointer)WordFactory.nullPointer();
            this.objectsStart = (Pointer)WordFactory.nullPointer();
            this.success = false;
        }

        @Override
        @SuppressFBWarnings(value={"NS_DANGEROUS_NON_SHORT_CIRCUIT"}, justification="Non-short circuit logic is used on purpose here.")
        public boolean visitObjectReference(Pointer reference, boolean compressed, Object holderObject) {
            Word referencedObject = ReferenceAccess.singleton().readObjectAsUntrackedPointer(reference, compressed);
            this.success &= CardTable.verifyReference(this.parentObject, this.cardTableStart, this.objectsStart, reference, (Pointer)referencedObject);
            return true;
        }
    }
}

