/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge.compacting;

import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.genscavenge.compacting.ObjectMoveInfo;
import com.oracle.svm.core.genscavenge.graal.nodes.FormatArrayNode;
import com.oracle.svm.core.genscavenge.graal.nodes.FormatObjectNode;
import com.oracle.svm.core.heap.FillerArray;
import com.oracle.svm.core.heap.FillerObject;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.util.UnsignedUtils;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.replacements.AllocationSnippets;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

public final class SweepingVisitor
implements ObjectMoveInfo.Visitor {
    private static final Class<?> ARRAY_CLASS = FillerArray.class;
    private static final JavaKind ARRAY_ELEMENT_KIND = JavaKind.Int;
    private static final int ARRAY_ELEMENT_SIZE = ARRAY_ELEMENT_KIND.getByteCount();

    @Fold
    static int arrayMinSize() {
        return NumUtil.safeToInt((long)ConfigurationValues.getObjectLayout().getArraySize(ARRAY_ELEMENT_KIND, 0, false));
    }

    @Fold
    static int arrayBaseOffset() {
        return ConfigurationValues.getObjectLayout().getArrayBaseOffset(ARRAY_ELEMENT_KIND);
    }

    @Override
    public boolean visit(Pointer objSeq, UnsignedWord size, Pointer newAddress, Pointer nextObjSeq) {
        if (nextObjSeq.isNonNull()) {
            Pointer gapStart = objSeq.add(size);
            assert (gapStart.belowOrEqual((UnsignedWord)nextObjSeq));
            if (gapStart.notEqual((UnsignedWord)nextObjSeq)) {
                SweepingVisitor.writeFillerObjectAt(gapStart, (UnsignedWord)nextObjSeq.subtract((UnsignedWord)gapStart));
            }
        }
        return true;
    }

    private static void writeFillerObjectAt(Pointer p, UnsignedWord size) {
        assert (size.aboveThan(0));
        if (size.aboveOrEqual(SweepingVisitor.arrayMinSize())) {
            int length = UnsignedUtils.safeToInt(size.subtract(SweepingVisitor.arrayBaseOffset()).unsignedDivide(ARRAY_ELEMENT_SIZE));
            FormatArrayNode.formatArray(p, ARRAY_CLASS, length, true, false, AllocationSnippets.FillContent.WITH_GARBAGE_IF_ASSERTIONS_ENABLED, false);
        } else {
            FormatObjectNode.formatObject(p, FillerObject.class, true, AllocationSnippets.FillContent.WITH_GARBAGE_IF_ASSERTIONS_ENABLED, false);
        }
        assert (LayoutEncoding.getSizeFromObjectInGC(p.toObject()).equal(size));
    }
}

