/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.Generation;
import com.oracle.svm.core.genscavenge.GreyToBlackObjectVisitor;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.Timers;
import com.oracle.svm.core.genscavenge.remset.RememberedSet;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

public abstract class OldGeneration
extends Generation {
    OldGeneration(String name) {
        super(name);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    abstract void beginPromotion(boolean var1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    abstract void blackenDirtyCardRoots(GreyToBlackObjectVisitor var1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    abstract boolean scanGreyObjects(boolean var1);

    abstract void sweepAndCompact(Timers var1, GCImpl.ChunkReleaser var2);

    abstract void releaseSpaces(GCImpl.ChunkReleaser var1);

    abstract void swapSpaces();

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    abstract UnsignedWord getChunkBytes();

    abstract UnsignedWord computeObjectBytes();

    abstract boolean isInSpace(Pointer var1);

    abstract boolean verifyRememberedSets();

    abstract boolean verifySpaces();

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    abstract void tearDown();

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    AlignedHeapChunk.AlignedHeader requestAlignedChunk() {
        assert (VMOperation.isGCInProgress()) : "Should only be called from the collector.";
        AlignedHeapChunk.AlignedHeader chunk = HeapImpl.getChunkProvider().produceAlignedChunk();
        if (BranchProbabilityNode.probability((double)1.0000000000287557E-6, (boolean)chunk.isNull())) {
            throw VMError.shouldNotReachHere("OldGeneration.requestAlignedChunk: failure to allocate aligned chunk");
        }
        RememberedSet.get().enableRememberedSetForChunk(chunk);
        return chunk;
    }
}

