/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.classinitialization;

import com.oracle.svm.core.classinitialization.ClassInitializationInfo;
import com.oracle.svm.core.classinitialization.EnsureClassInitializedNode;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.snippets.SnippetRuntime;
import java.util.Map;
import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.SnippetAnchorNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.extended.ForeignCallWithExceptionNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.Snippets;
import org.graalvm.word.LocationIdentity;

public final class EnsureClassInitializedSnippets
extends SubstrateTemplates
implements Snippets {
    private static final SnippetRuntime.SubstrateForeignCallDescriptor SLOW_PATH = SnippetRuntime.findForeignCall(ClassInitializationInfo.class, "slowPath", ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, LocationIdentity.any());
    public static final SnippetRuntime.SubstrateForeignCallDescriptor[] FOREIGN_CALLS = new SnippetRuntime.SubstrateForeignCallDescriptor[]{SLOW_PATH};
    private final SnippetTemplate.SnippetInfo ensureClassIsInitialized;

    @Snippet
    private static void ensureClassIsInitializedSnippet(@Snippet.NonNullParameter DynamicHub hub) {
        ClassInitializationInfo info = hub.getClassInitializationInfo();
        ClassInitializationInfo infoNonNull = (ClassInitializationInfo)PiNode.piCastNonNull((Object)info, (GuardingNode)SnippetAnchorNode.anchor());
        if (BranchProbabilityNode.probability((double)1.0000000000287557E-6, (boolean)infoNonNull.requiresSlowPath())) {
            EnsureClassInitializedSnippets.callSlowPath(SLOW_PATH, infoNonNull, DynamicHub.toClass(hub));
        }
    }

    @Node.NodeIntrinsic(value=ForeignCallWithExceptionNode.class)
    private static native void callSlowPath(@Node.ConstantNodeParameter ForeignCallDescriptor var0, ClassInitializationInfo var1, Class<?> var2);

    public static void registerLowerings(OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        new EnsureClassInitializedSnippets(options, providers, lowerings);
    }

    private EnsureClassInitializedSnippets(OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        super(options, providers);
        this.ensureClassIsInitialized = this.snippet(providers, EnsureClassInitializedSnippets.class, "ensureClassIsInitializedSnippet", new LocationIdentity[]{LocationIdentity.any()});
        lowerings.put(EnsureClassInitializedNode.class, new EnsureClassInitializedNodeLowering());
    }

    class EnsureClassInitializedNodeLowering
    implements NodeLoweringProvider<EnsureClassInitializedNode> {
        EnsureClassInitializedNodeLowering() {
        }

        @Override
        public void lower(EnsureClassInitializedNode node, LoweringTool tool) {
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(EnsureClassInitializedSnippets.this.ensureClassIsInitialized, node.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("hub", (Object)node.getHub());
            EnsureClassInitializedSnippets.this.template((CoreProviders)tool, (ValueNode)node, args).instantiate(tool.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }
}

