/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.code.RuntimeCodeCache;
import java.util.EnumSet;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.TargetDescription;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class SubstrateTargetDescription
extends TargetDescription {
    private final EnumSet<?> runtimeCheckedCPUFeatures;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static boolean shouldInlineObjectsInImageCode() {
        return SubstrateOptions.SpawnIsolates.getValue();
    }

    public static boolean shouldInlineObjectsInRuntimeCode() {
        return SubstrateOptions.SpawnIsolates.getValue() != false && RuntimeCodeCache.Options.WriteableCodeCache.getValue() != false;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstrateTargetDescription(Architecture arch, boolean isMP, int stackAlignment, int implicitNullCheckLimit, EnumSet<?> runtimeCheckedCPUFeatures) {
        super(arch, isMP, stackAlignment, implicitNullCheckLimit, SubstrateTargetDescription.shouldInlineObjectsInImageCode());
        this.runtimeCheckedCPUFeatures = runtimeCheckedCPUFeatures;
    }

    public EnumSet<?> getRuntimeCheckedCPUFeatures() {
        return this.runtimeCheckedCPUFeatures;
    }
}

