/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config;

import com.oracle.svm.configure.ConfigurationBase;
import com.oracle.svm.configure.config.ConfigurationPredefinedClass;
import com.oracle.svm.core.configure.ConfigurationParser;
import com.oracle.svm.core.configure.PredefinedClassesConfigurationParser;
import com.oracle.svm.core.util.VMError;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jdk.graal.compiler.phases.common.LazyValue;
import jdk.graal.compiler.util.Digest;
import jdk.graal.compiler.util.json.JsonWriter;
import org.graalvm.nativeimage.impl.UnresolvedConfigurationCondition;

public final class PredefinedClassesConfiguration
extends ConfigurationBase<PredefinedClassesConfiguration, Predicate> {
    private final List<LazyValue<Path>> classDestinationDirs;
    private final ConcurrentMap<String, ConfigurationPredefinedClass> classes = new ConcurrentHashMap<String, ConfigurationPredefinedClass>();
    private final java.util.function.Predicate<String> shouldExcludeClassWithHash;

    public PredefinedClassesConfiguration(List<LazyValue<Path>> classDestinationDirs, java.util.function.Predicate<String> shouldExcludeClassWithHash) {
        this.classDestinationDirs = classDestinationDirs;
        this.shouldExcludeClassWithHash = shouldExcludeClassWithHash;
    }

    public PredefinedClassesConfiguration(PredefinedClassesConfiguration other) {
        this.classDestinationDirs = other.classDestinationDirs;
        this.classes.putAll(other.classes);
        this.shouldExcludeClassWithHash = other.shouldExcludeClassWithHash;
    }

    @Override
    public PredefinedClassesConfiguration copy() {
        return new PredefinedClassesConfiguration(this);
    }

    @Override
    protected void merge(PredefinedClassesConfiguration other) {
        this.classes.putAll(other.classes);
    }

    @Override
    protected void subtract(PredefinedClassesConfiguration other) {
        this.classes.keySet().removeAll(other.classes.keySet());
    }

    @Override
    protected void intersect(PredefinedClassesConfiguration other) {
        this.classes.keySet().retainAll(other.classes.keySet());
    }

    @Override
    protected void removeIf(Predicate predicate) {
        this.classes.values().removeIf(predicate::testPredefinedClass);
    }

    @Override
    public void mergeConditional(UnresolvedConfigurationCondition condition, PredefinedClassesConfiguration other) {
        this.classes.putAll(other.classes);
    }

    public void add(String nameInfo, byte[] classData) {
        String hash = Digest.digest((byte[])classData);
        if (this.shouldExcludeClassWithHash != null && this.shouldExcludeClassWithHash.test(hash)) {
            return;
        }
        if (this.classDestinationDirs != null) {
            for (LazyValue<Path> dir : this.classDestinationDirs) {
                try {
                    Files.write(((Path)dir.get()).resolve(PredefinedClassesConfiguration.getFileName(hash)), classData, new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        ConfigurationPredefinedClass clazz = new ConfigurationPredefinedClass(nameInfo, hash);
        this.classes.put(hash, clazz);
    }

    public void add(String nameInfo, String hash, URI baseUri) {
        if (this.shouldExcludeClassWithHash != null && this.shouldExcludeClassWithHash.test(hash)) {
            return;
        }
        if (this.classDestinationDirs != null) {
            Path localBaseDir;
            try {
                localBaseDir = Path.of(baseUri);
            }
            catch (Exception ignored) {
                localBaseDir = null;
            }
            for (LazyValue<Path> destDir : this.classDestinationDirs) {
                if (((Path)destDir.get()).equals(localBaseDir)) continue;
                try {
                    String fileName = PredefinedClassesConfiguration.getFileName(hash);
                    Path target = ((Path)destDir.get()).resolve(fileName);
                    if (baseUri != null) {
                        InputStream is = PredefinedClassesConfigurationParser.openClassdataStream((URI)baseUri, (String)hash);
                        try {
                            Files.copy(is, target, StandardCopyOption.REPLACE_EXISTING);
                            continue;
                        }
                        finally {
                            if (is != null) {
                                is.close();
                            }
                            continue;
                        }
                    }
                    if (Files.exists(target, new LinkOption[0])) continue;
                    throw new RuntimeException("Cannot copy class data file for predefined class " + nameInfo + " with hash " + hash + ": source directory is unknown and file does not already exist in target directory.");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        ConfigurationPredefinedClass clazz = new ConfigurationPredefinedClass(nameInfo, hash);
        this.classes.put(hash, clazz);
    }

    private static String getFileName(String hash) {
        return hash + ".classdata";
    }

    public void printJson(JsonWriter writer) throws IOException {
        writer.append('[').indent().newline();
        writer.append('{').indent().newline();
        writer.quote("type").append(':').quote("agent-extracted").append(',').newline();
        writer.quote("classes").append(":[").indent();
        String prefix = "";
        for (ConfigurationPredefinedClass value : this.classes.values()) {
            writer.append(prefix).newline();
            value.printJson(writer);
            prefix = ",";
        }
        writer.unindent().newline().append(']');
        writer.unindent().newline().append('}');
        writer.unindent().newline().append(']').newline();
    }

    @Override
    public ConfigurationParser createParser(boolean strictMetadata) {
        VMError.guarantee((!strictMetadata ? 1 : 0) != 0, (String)"Predefined classes configuration is not supported with strict metadata");
        return new PredefinedClassesConfigurationParser(this::add, true);
    }

    @Override
    public boolean isEmpty() {
        return this.classes.isEmpty();
    }

    @Override
    public boolean supportsCombinedFile() {
        return false;
    }

    public boolean containsClassWithName(String className) {
        return this.classes.values().stream().anyMatch(clazz -> clazz.getNameInfo().equals(className));
    }

    public boolean containsClassWithHash(String hash) {
        return this.classes.containsKey(hash);
    }

    public static interface Predicate {
        public boolean testPredefinedClass(ConfigurationPredefinedClass var1);
    }
}

