/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.driver;

import com.oracle.svm.core.option.OptionUtils;
import com.oracle.svm.core.util.ArchiveSupport;
import com.oracle.svm.driver.NativeImage;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class MacroOption {
    private final String optionName;
    private final Path optionDirectory;
    final OptionUtils.MacroOptionKind kind;
    private final Map<String, String> properties;

    Path getOptionDirectory() {
        return this.optionDirectory;
    }

    String getOptionName() {
        return this.optionName;
    }

    String getDescription(boolean commandLineStyle) {
        return this.kind.getDescriptionPrefix(commandLineStyle) + this.getOptionName();
    }

    private static MacroOption create(Path macroOptionDirectory) {
        try {
            return new MacroOption(macroOptionDirectory);
        }
        catch (Exception e) {
            return null;
        }
    }

    private MacroOption(Path optionDirectory) {
        this.kind = OptionUtils.MacroOptionKind.fromSubdir((String)optionDirectory.getParent().getFileName().toString());
        this.optionName = optionDirectory.getFileName().toString();
        this.optionDirectory = optionDirectory;
        this.properties = ArchiveSupport.loadProperties((Path)optionDirectory.resolve("native-image.properties"));
    }

    public String toString() {
        return this.getDescription(false);
    }

    static final class Registry {
        private final Map<OptionUtils.MacroOptionKind, Map<String, MacroOption>> supported = new HashMap<OptionUtils.MacroOptionKind, Map<String, MacroOption>>();
        private final LinkedHashSet<EnabledOption> enabled = new LinkedHashSet();

        private static Map<OptionUtils.MacroOptionKind, Map<String, MacroOption>> collectMacroOptions(Path rootDir) throws IOException {
            HashMap<OptionUtils.MacroOptionKind, Map<String, MacroOption>> result = new HashMap<OptionUtils.MacroOptionKind, Map<String, MacroOption>>();
            for (OptionUtils.MacroOptionKind kind : OptionUtils.MacroOptionKind.values()) {
                Path optionsDir = rootDir.resolve(kind.subdir);
                Map<Object, Object> collectedOptions = Collections.emptyMap();
                if (Files.isDirectory(optionsDir, new LinkOption[0])) {
                    collectedOptions = Files.list(optionsDir).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(optionDir -> Files.isReadable(optionDir.resolve("native-image.properties"))).map(MacroOption::create).filter(Objects::nonNull).collect(Collectors.toMap(MacroOption::getOptionName, Function.identity()));
                }
                result.put(kind, collectedOptions);
            }
            return result;
        }

        Registry() {
            for (OptionUtils.MacroOptionKind kind : OptionUtils.MacroOptionKind.values()) {
                this.supported.put(kind, new HashMap());
            }
        }

        void addMacroOptionRoot(Path rootDir) {
            try {
                Registry.collectMacroOptions(rootDir).forEach((optionKind, optionMap) -> this.supported.get(optionKind).putAll((Map<String, MacroOption>)optionMap));
            }
            catch (IOException e) {
                throw new OptionUtils.InvalidMacroException("Error while discovering supported MacroOptions in " + String.valueOf(rootDir) + ": " + e.getMessage());
            }
        }

        Set<String> getAvailableOptions(OptionUtils.MacroOptionKind forKind) {
            return this.supported.get(forKind).keySet();
        }

        void showOptions(OptionUtils.MacroOptionKind forKind, boolean commandLineStyle, Consumer<String> lineOut) {
            ArrayList<CallSite> optionsToShow = new ArrayList<CallSite>();
            for (OptionUtils.MacroOptionKind kind : OptionUtils.MacroOptionKind.values()) {
                if (forKind != null && !kind.equals((Object)forKind) || forKind == null && kind == OptionUtils.MacroOptionKind.Macro) continue;
                for (MacroOption option : this.supported.get(kind).values()) {
                    if (option.kind.subdir.isEmpty()) continue;
                    Object linePrefix = "    ";
                    if (commandLineStyle) {
                        linePrefix = (String)linePrefix + "--";
                    }
                    optionsToShow.add((CallSite)((Object)((String)linePrefix + String.valueOf(option))));
                }
            }
            if (!optionsToShow.isEmpty()) {
                StringBuilder sb = new StringBuilder().append("Available ");
                if (forKind != null) {
                    sb.append(forKind.toString()).append(' ');
                } else {
                    sb.append("macro-");
                }
                lineOut.accept(sb.append("options are:").toString());
                optionsToShow.stream().sorted().forEachOrdered(lineOut);
            }
        }

        MacroOption getMacroOption(OptionUtils.MacroOptionKind kindPart, String optionName) {
            return this.supported.get(kindPart).get(optionName);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean enableOption(NativeImage.BuildConfiguration config, String optionString, HashSet<MacroOption> addedCheck, MacroOption context, Consumer<EnabledOption> enabler) {
            OptionUtils.MacroOptionKind kindPart;
            String specString;
            if (context == null) {
                if (!optionString.startsWith("--")) return false;
                specString = optionString.substring("--".length());
            } else {
                specString = optionString;
            }
            String[] specParts = specString.split(":", 2);
            if (specParts.length != 2) {
                if (context != null) throw new VerboseInvalidMacroException("Invalid option specification: " + optionString, context);
                return false;
            }
            try {
                kindPart = OptionUtils.MacroOptionKind.fromString((String)specParts[0]);
            }
            catch (Exception e) {
                if (context != null) throw new VerboseInvalidMacroException("Unknown kind in option specification: " + optionString, context);
                return false;
            }
            String specNameParts = specParts[1];
            if (specNameParts.isEmpty()) {
                throw new VerboseInvalidMacroException("Empty option specification: " + optionString, kindPart, context);
            }
            if (specNameParts.equals("all")) {
                if (!kindPart.allowAll) {
                    throw new VerboseInvalidMacroException("Empty option specification: " + String.valueOf(kindPart) + " does no support 'all'", kindPart, context);
                }
                for (String optionName : this.getAvailableOptions(kindPart)) {
                    MacroOption option = this.getMacroOption(kindPart, optionName);
                    if (Boolean.parseBoolean(option.properties.getOrDefault("ExcludeFromAll", "false"))) continue;
                    this.enableResolved(config, option, null, addedCheck, context, enabler);
                }
                return true;
            }
            String[] parts = specNameParts.split("=", 2);
            String optionName = parts[0];
            MacroOption option = this.getMacroOption(kindPart, optionName);
            if (option == null) {
                throw new VerboseInvalidMacroException("Unknown name in option specification: " + String.valueOf(kindPart) + ":" + optionName, kindPart, context);
            }
            String optionArg = parts.length == 2 ? parts[1] : null;
            this.enableResolved(config, option, optionArg, addedCheck, context, enabler);
            return true;
        }

        private void enableResolved(NativeImage.BuildConfiguration config, MacroOption option, String optionArg, HashSet<MacroOption> addedCheck, MacroOption context, Consumer<EnabledOption> enabler) {
            String requires;
            String defaultArg;
            if (addedCheck.contains(option)) {
                return;
            }
            addedCheck.add(option);
            EnabledOption enabledOption = new EnabledOption(option, optionArg, context == null);
            if (optionArg == null && (defaultArg = enabledOption.getProperty(config, "DefaultArg")) != null) {
                enabledOption = new EnabledOption(option, defaultArg, context == null);
            }
            if (!(requires = enabledOption.getProperty(config, "Requires", "")).isEmpty()) {
                for (String specString : requires.split(" ")) {
                    this.enableOption(config, specString, addedCheck, option, enabler);
                }
            }
            if (option.kind.equals((Object)OptionUtils.MacroOptionKind.Language)) {
                MacroOption truffleOption = this.getMacroOption(OptionUtils.MacroOptionKind.Macro, "truffle");
                if (truffleOption == null) {
                    throw new VerboseInvalidMacroException("Cannot locate the truffle macro", null);
                }
                if (!addedCheck.contains(truffleOption)) {
                    this.enableResolved(config, truffleOption, null, addedCheck, option, enabler);
                }
            }
            enabler.accept(enabledOption);
            this.enabled.add(enabledOption);
        }

        LinkedHashSet<EnabledOption> getEnabledOptions(OptionUtils.MacroOptionKind kind) {
            return this.enabled.stream().filter(eo -> kind.equals((Object)eo.option.kind)).collect(Collectors.toCollection(LinkedHashSet::new));
        }

        Stream<EnabledOption> getEnabledOptionsStream(OptionUtils.MacroOptionKind kind, OptionUtils.MacroOptionKind ... otherKinds) {
            EnumSet<OptionUtils.MacroOptionKind[]> kindSet = EnumSet.of(kind, otherKinds);
            return this.enabled.stream().filter(eo -> kindSet.contains(eo.option.kind));
        }

        LinkedHashSet<EnabledOption> getEnabledOptions() {
            return this.enabled;
        }

        EnabledOption getEnabledOption(MacroOption option) {
            return this.enabled.stream().filter(eo -> eo.getOption().equals(option)).findFirst().orElse(null);
        }
    }

    static final class EnabledOption {
        private final MacroOption option;
        private final String optionArg;
        private final boolean enabledFromCommandline;

        private EnabledOption(MacroOption option, String optionArg, boolean enabledFromCommandline) {
            this.option = Objects.requireNonNull(option);
            this.optionArg = optionArg;
            this.enabledFromCommandline = enabledFromCommandline;
        }

        private String resolvePropertyValue(NativeImage.BuildConfiguration config, String val) {
            return NativeImage.resolvePropertyValue(val, this.optionArg, this.getOption().optionDirectory, config);
        }

        String getProperty(NativeImage.BuildConfiguration config, String key, String defaultVal) {
            String val = this.option.properties.get(key);
            if (val == null) {
                return defaultVal;
            }
            return this.resolvePropertyValue(config, val);
        }

        String getProperty(NativeImage.BuildConfiguration config, String key) {
            return this.getProperty(config, key, null);
        }

        boolean forEachPropertyValue(NativeImage.BuildConfiguration config, String propertyKey, Consumer<String> target) {
            return this.forEachPropertyValue(config, propertyKey, target, " ");
        }

        boolean forEachPropertyValue(NativeImage.BuildConfiguration config, String propertyKey, Consumer<String> target, String separatorRegex) {
            Function<String, String> resolvePropertyValue = str -> this.resolvePropertyValue(config, (String)str);
            return NativeImage.forEachPropertyValue(this.option.properties.get(propertyKey), target, resolvePropertyValue, separatorRegex);
        }

        MacroOption getOption() {
            return this.option;
        }

        boolean isEnabledFromCommandline() {
            return this.enabledFromCommandline;
        }
    }

    static final class AddedTwiceException
    extends RuntimeException {
        private final MacroOption option;
        private final MacroOption context;

        AddedTwiceException(MacroOption option, MacroOption context) {
            this.option = option;
            this.context = context;
        }

        @Override
        public String getMessage() {
            StringBuilder sb = new StringBuilder();
            if (this.context != null) {
                sb.append("MacroOption ").append(this.context.getDescription(false));
                if (this.option.equals(this.context)) {
                    sb.append(" cannot require itself");
                } else {
                    sb.append(" requires ").append(this.option.getDescription(false)).append(" more than once");
                }
            } else {
                sb.append("Command line option ").append(this.option.getDescription(true));
                sb.append(" used more than once");
            }
            return sb.toString();
        }
    }

    static final class VerboseInvalidMacroException
    extends RuntimeException {
        private final OptionUtils.MacroOptionKind forKind;
        private final MacroOption context;

        VerboseInvalidMacroException(String arg0, MacroOption context) {
            this(arg0, null, context);
        }

        VerboseInvalidMacroException(String arg0, OptionUtils.MacroOptionKind forKind, MacroOption context) {
            super(arg0);
            this.forKind = forKind;
            this.context = context;
        }

        public String getMessage(Registry registry) {
            StringBuilder sb = new StringBuilder();
            String message = super.getMessage();
            if (this.context != null) {
                sb.append(this.context.getDescription(false) + " contains ");
                if (!message.isEmpty()) {
                    sb.append(Character.toLowerCase(message.charAt(0)));
                    sb.append(message.substring(1));
                }
            } else {
                sb.append(message);
            }
            Consumer<String> lineOut = s -> sb.append("\n" + s);
            registry.showOptions(this.forKind, this.context == null, lineOut);
            return sb.toString();
        }
    }
}

