/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.driver;

import com.oracle.svm.core.OS;
import com.oracle.svm.core.option.BundleMember;
import com.oracle.svm.core.util.ArchiveSupport;
import com.oracle.svm.driver.BundleOptions;
import com.oracle.svm.driver.NativeImage;
import com.oracle.svm.driver.launcher.BundleLauncher;
import com.oracle.svm.driver.launcher.ContainerSupport;
import com.oracle.svm.driver.launcher.configuration.BundleArgsParser;
import com.oracle.svm.driver.launcher.configuration.BundleEnvironmentParser;
import com.oracle.svm.driver.launcher.configuration.BundlePathMapParser;
import com.oracle.svm.util.ClassUtil;
import com.oracle.svm.util.LogUtils;
import com.oracle.svm.util.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import jdk.graal.compiler.util.json.JsonPrinter;
import jdk.graal.compiler.util.json.JsonWriter;

final class BundleSupport {
    final NativeImage nativeImage;
    final Path rootDir;
    final Path inputDir;
    final Path stageDir;
    final Path classPathDir;
    final Path modulePathDir;
    final Path auxiliaryDir;
    final Path outputDir;
    final Path imagePathOutputDir;
    final Path auxiliaryOutputDir;
    Map<Path, Path> pathCanonicalizations = new HashMap<Path, Path>();
    Map<Path, Path> pathSubstitutions = new HashMap<Path, Path>();
    private final boolean forceBuilderOnClasspath;
    private final List<String> nativeImageArgs;
    private List<String> updatedNativeImageArgs;
    final ArrayList<String> bundleLauncherArgs = new ArrayList();
    boolean loadBundle;
    boolean writeBundle;
    private static final int BUNDLE_FILE_FORMAT_VERSION_MAJOR = 0;
    private static final int BUNDLE_FILE_FORMAT_VERSION_MINOR = 9;
    static final String BUNDLE_INFO_MESSAGE_PREFIX = "Native Image Bundles: ";
    private static final String BUNDLE_TEMP_DIR_PREFIX = "bundleRoot-";
    private static final String ORIGINAL_DIR_EXTENSION = ".orig";
    private Path bundlePath;
    private String bundleName;
    private final BundleProperties bundleProperties;
    static final String BUNDLE_OPTION = "--bundle";
    private static final String DRY_RUN_OPTION = "dry-run";
    private static final String CONTAINER_OPTION = "container";
    private static final String DOCKERFILE_OPTION = "dockerfile";
    static final String BUNDLE_FILE_EXTENSION = ".nib";
    ContainerSupport containerSupport;
    boolean useContainer;
    private static final String DEFAULT_DOCKERFILE = BundleSupport.getDockerfile("Dockerfile");
    private final AtomicBoolean deleteBundleRoot = new AtomicBoolean();
    private static final String substitutionMapSrcField = "src";
    private static final String substitutionMapDstField = "dst";
    private static final String environmentKeyField = "key";
    private static final String environmentValueField = "val";
    private static final Path bundlePropertiesFileName = Path.of("META-INF/nibundle.properties", new String[0]);

    private static String getDockerfile(String name) {
        return NativeImage.getResource("/container-default/" + name);
    }

    static BundleSupport create(NativeImage nativeImage, String bundleArg, NativeImage.ArgumentQueue args) {
        try {
            BundleSupport bundleSupport;
            BundleOptions.BundleOption bundleOption = BundleOptions.parseBundleOption(bundleArg);
            String applyOptionName = BundleOptionVariants.apply.optionName();
            String createOptionName = BundleOptionVariants.create.optionName();
            switch (BundleOptionVariants.valueOf(bundleOption.variant()).ordinal()) {
                case 1: {
                    if (nativeImage.useBundle()) {
                        if (nativeImage.bundleSupport.loadBundle) {
                            throw NativeImage.showError(String.format("native-image allows option %s to be specified only once.", applyOptionName));
                        }
                        if (nativeImage.bundleSupport.writeBundle) {
                            throw NativeImage.showError(String.format("native-image option %s is not allowed to be used after option %s.", applyOptionName, createOptionName));
                        }
                    }
                    if (bundleOption.fileName() == null) {
                        throw NativeImage.showError(String.format("native-image option %s requires a bundle file argument. E.g. %s=bundle-file.nib.", applyOptionName, applyOptionName));
                    }
                    bundleSupport = new BundleSupport(nativeImage, bundleOption.fileName());
                    List<String> buildArgs = bundleSupport.getNativeImageArgs();
                    for (int i = buildArgs.size() - 1; i >= 0; --i) {
                        args.push(buildArgs.get(i));
                    }
                    nativeImage.showVerboseMessage(nativeImage.isVerbose(), "Native Image Bundles: Inject args: '" + String.join((CharSequence)" ", buildArgs) + "'");
                    bundleSupport.updatedNativeImageArgs = args.snapshot();
                    break;
                }
                case 0: {
                    if (nativeImage.useBundle()) {
                        if (nativeImage.bundleSupport.writeBundle) {
                            throw NativeImage.showError(String.format("native-image allows option %s to be specified only once.", bundleArg));
                        }
                        bundleSupport = nativeImage.bundleSupport;
                        bundleSupport.writeBundle = true;
                    } else {
                        bundleSupport = new BundleSupport(nativeImage);
                    }
                    if (bundleOption.fileName() != null) {
                        bundleSupport.updateBundleLocation(Path.of(bundleOption.fileName(), new String[0]), true);
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            Arrays.stream(bundleOption.extendedOptions()).forEach(bundleSupport::processExtendedOption);
            if (!bundleSupport.useContainer && bundleSupport.bundleProperties.requireContainerBuild()) {
                if (!OS.LINUX.isCurrent()) {
                    LogUtils.warning((String)"Native Image Bundles: Bundle was built in a container, but container builds are only supported for Linux.");
                } else {
                    bundleSupport.useContainer = true;
                    bundleSupport.containerSupport = new ContainerSupport(bundleSupport.stageDir, NativeImage::showError, LogUtils::warning, nativeImage::showMessage);
                }
            }
            if (bundleSupport.useContainer) {
                if (!OS.LINUX.isCurrent()) {
                    nativeImage.showMessage("Native Image Bundles: Skipping containerized build, only supported for Linux.");
                    bundleSupport.useContainer = false;
                } else if (nativeImage.isDryRun()) {
                    nativeImage.showMessage("Native Image Bundles: Skipping container creation for native-image bundle with dry-run option.");
                    bundleSupport.useContainer = false;
                }
            }
            return bundleSupport;
        }
        catch (IllegalArgumentException | StringIndexOutOfBoundsException e) {
            String suggestedVariants = StringUtil.joinSingleQuoted(Arrays.stream(BundleOptionVariants.values()).map(v -> "--bundle-" + String.valueOf(v)).toList());
            throw NativeImage.showError("Unknown option '" + bundleArg + "'. Valid variants are " + suggestedVariants + ".");
        }
    }

    void createDockerfile(Path dockerfile) {
        this.nativeImage.showVerboseMessage(this.nativeImage.isVerbose(), "Native Image Bundles: Creating default Dockerfile for native-image bundle.");
        String dockerfileText = DEFAULT_DOCKERFILE;
        try {
            Files.writeString(dockerfile, (CharSequence)dockerfileText, new OpenOption[0]);
            dockerfile.toFile().deleteOnExit();
        }
        catch (IOException e) {
            throw NativeImage.showError("Failed to create default Dockerfile " + String.valueOf(dockerfile));
        }
    }

    private void processExtendedOption(BundleOptions.ExtendedOption option) {
        switch (option.key()) {
            case "dry-run": {
                this.nativeImage.setDryRun(true);
                break;
            }
            case "container": {
                if (this.containerSupport != null) {
                    throw NativeImage.showError(String.format("native-image bundle allows option %s to be specified only once.", option.key()));
                }
                this.containerSupport = new ContainerSupport(this.stageDir, NativeImage::showError, LogUtils::warning, this.nativeImage::showMessage);
                this.useContainer = true;
                if (option.value() == null) break;
                if (!ContainerSupport.SUPPORTED_TOOLS.contains(option.value())) {
                    throw NativeImage.showError(String.format("Container Tool '%s' is not supported, please use one of the following tools: %s", option.value(), ContainerSupport.SUPPORTED_TOOLS));
                }
                this.containerSupport.tool = option.value();
                break;
            }
            case "dockerfile": {
                if (this.containerSupport == null) {
                    throw NativeImage.showError(String.format("native-image bundle option %s is only allowed to be used after option %s.", option.key(), CONTAINER_OPTION));
                }
                if (option.value() != null) {
                    this.containerSupport.dockerfile = Path.of(option.value(), new String[0]);
                    if (Files.isReadable(this.containerSupport.dockerfile)) break;
                    throw NativeImage.showError(String.format("Dockerfile '%s' is not readable", this.containerSupport.dockerfile.toAbsolutePath()));
                }
                throw NativeImage.showError(String.format("native-image option %s requires a dockerfile argument. E.g. %s=path/to/Dockerfile.", option.key(), option.key()));
            }
            default: {
                throw NativeImage.showError(String.format("Unknown option %s. Use --help-extra for usage instructions.", option.key()));
            }
        }
    }

    private BundleSupport(NativeImage nativeImage) {
        Objects.requireNonNull(nativeImage);
        this.nativeImage = nativeImage;
        this.loadBundle = false;
        this.writeBundle = true;
        try {
            this.rootDir = nativeImage.archiveSupport().createTempDir(BUNDLE_TEMP_DIR_PREFIX, this.deleteBundleRoot);
            this.bundleProperties = new BundleProperties();
            this.bundleProperties.properties.put("ImageBuildID", UUID.randomUUID().toString());
            this.inputDir = this.rootDir.resolve("input");
            this.stageDir = Files.createDirectories(this.inputDir.resolve("stage"), new FileAttribute[0]);
            this.auxiliaryDir = Files.createDirectories(this.inputDir.resolve("auxiliary"), new FileAttribute[0]);
            Path classesDir = this.inputDir.resolve("classes");
            this.classPathDir = Files.createDirectories(classesDir.resolve("cp"), new FileAttribute[0]);
            this.modulePathDir = Files.createDirectories(classesDir.resolve("p"), new FileAttribute[0]);
            this.outputDir = this.rootDir.resolve("output");
            this.imagePathOutputDir = Files.createDirectories(this.outputDir.resolve("default"), new FileAttribute[0]);
            this.auxiliaryOutputDir = Files.createDirectories(this.outputDir.resolve("other"), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw NativeImage.showError("Unable to create bundle directory layout", e);
        }
        this.forceBuilderOnClasspath = !nativeImage.config.modulePathBuild;
        this.nativeImageArgs = nativeImage.getNativeImageArgs();
    }

    private BundleSupport(NativeImage nativeImage, String bundleFilenameArg) {
        Objects.requireNonNull(nativeImage);
        this.nativeImage = nativeImage;
        this.loadBundle = true;
        this.writeBundle = false;
        Objects.requireNonNull(bundleFilenameArg);
        this.updateBundleLocation(Path.of(bundleFilenameArg, new String[0]), false);
        this.rootDir = nativeImage.archiveSupport().createTempDir(BUNDLE_TEMP_DIR_PREFIX, this.deleteBundleRoot);
        this.bundleProperties = new BundleProperties();
        this.bundleProperties.properties.put("ImageBuildID", UUID.randomUUID().toString());
        this.outputDir = this.rootDir.resolve("output");
        Path bundleFilePath = this.bundlePath.resolve(this.bundleName + BUNDLE_FILE_EXTENSION);
        nativeImage.archiveSupport().expandJarToDir(e -> this.relativizeBundleEntry(this.getOriginalOutputDirName(), (Path)e), bundleFilePath, this.rootDir, this.deleteBundleRoot);
        if (this.deleteBundleRoot.get()) {
            throw NativeImage.showError(null, null, 0);
        }
        this.bundleProperties.loadAndVerify();
        this.forceBuilderOnClasspath = this.bundleProperties.forceBuilderOnClasspath();
        nativeImage.config.modulePathBuild = !this.forceBuilderOnClasspath;
        try {
            this.inputDir = this.rootDir.resolve("input");
            this.stageDir = Files.createDirectories(this.inputDir.resolve("stage"), new FileAttribute[0]);
            this.auxiliaryDir = Files.createDirectories(this.inputDir.resolve("auxiliary"), new FileAttribute[0]);
            Path classesDir = this.inputDir.resolve("classes");
            this.classPathDir = Files.createDirectories(classesDir.resolve("cp"), new FileAttribute[0]);
            this.modulePathDir = Files.createDirectories(classesDir.resolve("p"), new FileAttribute[0]);
            this.imagePathOutputDir = Files.createDirectories(this.outputDir.resolve("default"), new FileAttribute[0]);
            this.auxiliaryOutputDir = Files.createDirectories(this.outputDir.resolve("other"), new FileAttribute[0]);
        }
        catch (IOException e2) {
            throw NativeImage.showError("Unable to create bundle directory layout", e2);
        }
        Path pathCanonicalizationsFile = this.stageDir.resolve("path_canonicalizations.json");
        try (BufferedReader reader = Files.newBufferedReader(pathCanonicalizationsFile);){
            new BundlePathMapParser(this.pathCanonicalizations).parseAndRegister(reader);
        }
        catch (IOException e3) {
            throw NativeImage.showError("Failed to read bundle-file " + String.valueOf(pathCanonicalizationsFile), e3);
        }
        Path pathSubstitutionsFile = this.stageDir.resolve("path_substitutions.json");
        try (BufferedReader reader = Files.newBufferedReader(pathSubstitutionsFile);){
            new BundlePathMapParser(this.pathSubstitutions).parseAndRegister(reader);
        }
        catch (IOException e4) {
            throw NativeImage.showError("Failed to read bundle-file " + String.valueOf(pathSubstitutionsFile), e4);
        }
        Path environmentFile = this.stageDir.resolve("environment.json");
        if (Files.isReadable(environmentFile)) {
            try (BufferedReader reader = Files.newBufferedReader(environmentFile);){
                new BundleEnvironmentParser(nativeImage.imageBuilderEnvironment).parseAndRegister(reader);
            }
            catch (IOException e5) {
                throw NativeImage.showError("Failed to read bundle-file " + String.valueOf(environmentFile), e5);
            }
        }
        Path buildArgsFile = this.stageDir.resolve("build.json");
        try (BufferedReader reader = Files.newBufferedReader(buildArgsFile);){
            ArrayList<String> buildArgsFromFile = new ArrayList<String>();
            new BundleArgsParser(buildArgsFromFile).parseAndRegister(reader);
            this.nativeImageArgs = Collections.unmodifiableList(buildArgsFromFile);
        }
        catch (IOException e6) {
            throw NativeImage.showError("Failed to read bundle-file " + String.valueOf(buildArgsFile), e6);
        }
    }

    private Path relativizeBundleEntry(String originalOutputDirName, Path bundleEntry) {
        if (bundleEntry.startsWith(this.outputDir)) {
            return this.rootDir.resolve(originalOutputDirName).resolve(this.outputDir.relativize(bundleEntry));
        }
        return bundleEntry;
    }

    private String getOriginalOutputDirName() {
        return this.outputDir.getFileName().toString() + ORIGINAL_DIR_EXTENSION;
    }

    public List<String> getNativeImageArgs() {
        return this.nativeImageArgs;
    }

    public String getImageBuildID() {
        return this.bundleProperties.properties.get("ImageBuildID");
    }

    Path recordCanonicalization(Path before, Path after) {
        if (before.startsWith(this.rootDir)) {
            this.nativeImage.showVerboseMessage(this.nativeImage.isVVerbose(), "RecordCanonicalization Skip: " + String.valueOf(before));
            return before;
        }
        if (after.startsWith(this.nativeImage.config.getJavaHome())) {
            return after;
        }
        this.nativeImage.showVerboseMessage(this.nativeImage.isVVerbose(), "RecordCanonicalization src: " + String.valueOf(before) + ", dst: " + String.valueOf(after));
        this.pathCanonicalizations.put(before, after);
        return after;
    }

    Path restoreCanonicalization(Path before) {
        Path after = this.pathCanonicalizations.get(before);
        this.nativeImage.showVerboseMessage(after != null && this.nativeImage.isVVerbose(), "RestoreCanonicalization src: " + String.valueOf(before) + ", dst: " + String.valueOf(after));
        return after;
    }

    Path substituteAuxiliaryPath(Path origPath, BundleMember.Role bundleMemberRole) {
        Path destinationDir;
        switch (bundleMemberRole) {
            default: {
                throw new MatchException(null, null);
            }
            case Input: {
                Path path = this.auxiliaryDir;
                break;
            }
            case Output: {
                Path path = this.auxiliaryOutputDir;
                break;
            }
            case Ignore: {
                Path path = destinationDir = null;
            }
        }
        if (destinationDir == null) {
            return origPath;
        }
        return this.substitutePath(origPath, destinationDir);
    }

    Path substituteImagePath(Path origPath) {
        this.pathSubstitutions.put(origPath, this.rootDir.relativize(this.imagePathOutputDir));
        return this.imagePathOutputDir;
    }

    Path substituteClassPath(Path origPath) {
        try {
            return this.substitutePath(origPath, this.classPathDir);
        }
        catch (BundlePathSubstitutionError error) {
            throw NativeImage.showError("Failed to prepare class-path entry '" + String.valueOf(error.origPath) + "' for bundle inclusion.", error);
        }
    }

    Path substituteModulePath(Path origPath) {
        try {
            return this.substitutePath(origPath, this.modulePathDir);
        }
        catch (BundlePathSubstitutionError error) {
            throw NativeImage.showError("Failed to prepare module-path entry '" + String.valueOf(error.origPath) + "' for bundle inclusion.", error);
        }
    }

    private Path substitutePath(Path origPath, Path destinationDir) {
        String extension;
        String baseName;
        assert (destinationDir.startsWith(this.rootDir));
        if (origPath.startsWith(this.rootDir)) {
            this.nativeImage.showVerboseMessage(this.nativeImage.isVVerbose(), "RecordSubstitution/RestoreSubstitution Skip: " + String.valueOf(origPath));
            return origPath;
        }
        Path previousRelativeSubstitutedPath = this.pathSubstitutions.get(origPath);
        if (previousRelativeSubstitutedPath != null) {
            this.nativeImage.showVerboseMessage(this.nativeImage.isVVerbose(), "RestoreSubstitution src: " + String.valueOf(origPath) + ", dst: " + String.valueOf(previousRelativeSubstitutedPath));
            return this.rootDir.resolve(previousRelativeSubstitutedPath);
        }
        if (origPath.startsWith(this.nativeImage.config.getJavaHome())) {
            return origPath;
        }
        boolean forbiddenPath = false;
        if (!OS.WINDOWS.isCurrent()) {
            boolean subdirInTmp;
            Path tmpPath = ClassUtil.CLASS_MODULE_PATH_EXCLUDE_DIRECTORIES_ROOT.resolve("tmp");
            boolean bl = subdirInTmp = origPath.startsWith(tmpPath) && !origPath.equals(tmpPath);
            if (!subdirInTmp) {
                HashSet<Path> forbiddenPaths = new HashSet<Path>(ClassUtil.CLASS_MODULE_PATH_EXCLUDE_DIRECTORIES);
                forbiddenPaths.add(this.rootDir);
                for (Path path : forbiddenPaths) {
                    if (!origPath.startsWith(path)) continue;
                    forbiddenPath = true;
                    break;
                }
            }
        }
        for (Path rootDirectory : FileSystems.getDefault().getRootDirectories()) {
            if (!origPath.equals(rootDirectory)) continue;
            forbiddenPath = true;
            break;
        }
        if (forbiddenPath) {
            throw new BundlePathSubstitutionError("Bundles do not allow inclusion of directory " + String.valueOf(origPath), origPath);
        }
        boolean isOutputPath = destinationDir.startsWith(this.outputDir);
        if (!isOutputPath && !Files.isReadable(origPath)) {
            this.pathSubstitutions.put(origPath, origPath);
            return origPath;
        }
        String origFileName = origPath.getFileName().toString();
        int extensionPos = origFileName.lastIndexOf(46);
        if (extensionPos > 0) {
            baseName = origFileName.substring(0, extensionPos);
            extension = origFileName.substring(extensionPos);
        } else {
            baseName = origFileName;
            extension = "";
        }
        Path substitutedPath = destinationDir.resolve(baseName + extension);
        int collisionIndex = 0;
        while (Files.exists(substitutedPath, new LinkOption[0])) {
            substitutedPath = destinationDir.resolve(baseName + "_" + ++collisionIndex + extension);
        }
        if (!isOutputPath) {
            this.copyFiles(origPath, substitutedPath, false);
        }
        Path relativeSubstitutedPath = this.rootDir.relativize(substitutedPath);
        this.nativeImage.showVerboseMessage(this.nativeImage.isVVerbose(), "RecordSubstitution src: " + String.valueOf(origPath) + ", dst: " + String.valueOf(relativeSubstitutedPath));
        this.pathSubstitutions.put(origPath, relativeSubstitutedPath);
        return substitutedPath;
    }

    Path originalPath(Path substitutedPath) {
        Path relativeSubstitutedPath = this.rootDir.relativize(substitutedPath);
        for (Map.Entry<Path, Path> entry : this.pathSubstitutions.entrySet()) {
            if (!entry.getValue().equals(relativeSubstitutedPath)) continue;
            return entry.getKey();
        }
        return null;
    }

    private void copyFiles(Path source, Path target, boolean overwrite) {
        block9: {
            this.nativeImage.showVerboseMessage(this.nativeImage.isVVerbose(), "> Copy files from " + String.valueOf(source) + " to " + String.valueOf(target));
            if (Files.isDirectory(source, new LinkOption[0])) {
                try (Stream<Path> walk = Files.walk(source, new FileVisitOption[0]);){
                    walk.forEach(sourcePath -> this.copyFile((Path)sourcePath, target.resolve(source.relativize((Path)sourcePath)), overwrite));
                    break block9;
                }
                catch (IOException e) {
                    throw NativeImage.showError("Failed to iterate through directory " + String.valueOf(source), e);
                }
            }
            this.copyFile(source, target, overwrite);
        }
    }

    private void copyFile(Path sourceFile, Path target, boolean overwrite) {
        try {
            CopyOption[] copyOptionArray;
            this.nativeImage.showVerboseMessage(this.nativeImage.isVVVerbose(), "> Copy " + String.valueOf(sourceFile) + " to " + String.valueOf(target));
            if (overwrite && Files.isDirectory(sourceFile, new LinkOption[0]) && Files.isDirectory(target, new LinkOption[0])) {
                return;
            }
            if (overwrite) {
                CopyOption[] copyOptionArray2 = new CopyOption[1];
                copyOptionArray = copyOptionArray2;
                copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
            } else {
                copyOptionArray = new CopyOption[]{};
            }
            CopyOption[] options = copyOptionArray;
            Files.copy(sourceFile, target, options);
        }
        catch (IOException e) {
            throw NativeImage.showError("Failed to copy " + String.valueOf(sourceFile) + " to " + String.valueOf(target), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void complete() {
        boolean writeOutput;
        try (Stream<Path> pathOutputFiles = Files.list(this.imagePathOutputDir);
             Stream<Path> auxiliaryOutputFiles = Files.list(this.auxiliaryOutputDir);){
            writeOutput = (pathOutputFiles.findAny().isPresent() || auxiliaryOutputFiles.findAny().isPresent()) && !this.deleteBundleRoot.get();
        }
        catch (IOException e) {
            writeOutput = false;
        }
        if (this.bundlePath == null) {
            this.bundlePath = this.nativeImage.config.getWorkingDirectory();
            this.bundleName = "unknown";
        }
        if (!this.nativeImage.isDryRun() && (writeOutput || this.writeBundle)) {
            this.nativeImage.showNewline();
        }
        if (writeOutput) {
            Path externalOutputDir = this.bundlePath.resolve(this.bundleName + "." + String.valueOf(this.outputDir.getFileName()));
            this.copyFiles(this.outputDir, externalOutputDir, true);
            this.nativeImage.showMessage("Native Image Bundles: Bundle build output written to " + String.valueOf(externalOutputDir));
        }
        try {
            if (this.writeBundle) {
                Path bundleFilePath = this.writeBundle();
                this.nativeImage.showMessage("Native Image Bundles: Bundle written to " + String.valueOf(bundleFilePath));
            }
        }
        finally {
            this.nativeImage.showNewline();
        }
    }

    void updateBundleLocation(Path bundleFile, boolean redefine) {
        if (redefine) {
            this.bundlePath = null;
            this.bundleName = null;
        }
        if (this.bundlePath != null) {
            Objects.requireNonNull(this.bundleName);
            return;
        }
        Path bundleFilePath = bundleFile.toAbsolutePath();
        String bundleFileName = bundleFile.getFileName().toString();
        if (!bundleFileName.endsWith(BUNDLE_FILE_EXTENSION)) {
            throw NativeImage.showError("The given bundle file " + bundleFileName + " does not end with '.nib'");
        }
        if (Files.isDirectory(bundleFilePath, new LinkOption[0])) {
            throw NativeImage.showError("The given bundle file " + bundleFileName + " is a directory and not a file");
        }
        if (this.loadBundle && !redefine && !Files.isReadable(bundleFilePath)) {
            throw NativeImage.showError("The given bundle file " + bundleFileName + " cannot be read.");
        }
        Path newBundlePath = bundleFilePath.getParent();
        if (this.writeBundle) {
            if (!Files.isWritable(newBundlePath)) {
                throw NativeImage.showError("The bundle file directory " + String.valueOf(newBundlePath) + " is not writeable.");
            }
            if (Files.exists(bundleFilePath, new LinkOption[0]) && !Files.isWritable(bundleFilePath)) {
                throw NativeImage.showError("The given bundle file " + bundleFileName + " is not writeable.");
            }
        }
        this.bundlePath = newBundlePath;
        this.bundleName = bundleFileName.substring(0, bundleFileName.length() - BUNDLE_FILE_EXTENSION.length());
    }

    private Path writeBundle() {
        Path metaInfDir;
        Path originalOutputDir = this.rootDir.resolve(this.getOriginalOutputDirName());
        if (Files.exists(originalOutputDir, new LinkOption[0])) {
            this.nativeImage.archiveSupport().deleteAllFiles(originalOutputDir);
        }
        if (Files.exists(metaInfDir = this.rootDir.resolve("META-INF/MANIFEST.MF"), new LinkOption[0])) {
            this.nativeImage.archiveSupport().deleteAllFiles(metaInfDir);
        }
        String bundleLauncherClassResource = "/" + BundleLauncher.class.getName().replace(".", "/") + ".class";
        String bundleLauncherPackageResource = "/" + BundleLauncher.class.getPackageName().replace(".", "/");
        try (FileSystem fs = FileSystems.newFileSystem(BundleSupport.class.getResource(bundleLauncherClassResource).toURI(), new HashMap());
             Stream<Path> walk = Files.walk(fs.getPath(bundleLauncherPackageResource, new String[0]), new FileVisitOption[0]);){
            walk.filter(Predicate.not(x$0 -> Files.isDirectory(x$0, new LinkOption[0]))).map(Path::toString).forEach(sourcePath -> {
                Path target = this.rootDir.resolve(Paths.get("/", new String[0]).relativize(Paths.get(sourcePath, new String[0])));
                try (InputStream source = BundleSupport.class.getResourceAsStream((String)sourcePath);){
                    Path bundleFileParent = target.getParent();
                    if (bundleFileParent != null) {
                        Files.createDirectories(bundleFileParent, new FileAttribute[0]);
                    }
                    Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Exception e) {
                    throw NativeImage.showError("Failed to write bundle-file " + String.valueOf(target), e);
                }
            });
        }
        catch (Exception e) {
            throw NativeImage.showError("Failed to read bundle launcher resources '" + bundleLauncherPackageResource + "'", e);
        }
        Path pathCanonicalizationsFile = this.stageDir.resolve("path_canonicalizations.json");
        try (JsonWriter writer = new JsonWriter(pathCanonicalizationsFile, new OpenOption[0]);){
            JsonPrinter.printCollection((JsonWriter)writer, this.pathCanonicalizations.entrySet(), Map.Entry.comparingByKey(), BundleSupport::printPathMapping);
        }
        catch (IOException e) {
            throw NativeImage.showError("Failed to write bundle-file " + String.valueOf(pathCanonicalizationsFile), e);
        }
        Path pathSubstitutionsFile = this.stageDir.resolve("path_substitutions.json");
        try (JsonWriter writer = new JsonWriter(pathSubstitutionsFile, new OpenOption[0]);){
            JsonPrinter.printCollection((JsonWriter)writer, this.pathSubstitutions.entrySet(), Map.Entry.comparingByKey(), BundleSupport::printPathMapping);
        }
        catch (IOException e) {
            throw NativeImage.showError("Failed to write bundle-file " + String.valueOf(pathSubstitutionsFile), e);
        }
        Path environmentFile = this.stageDir.resolve("environment.json");
        try (JsonWriter writer = new JsonWriter(environmentFile, new OpenOption[0]);){
            JsonPrinter.printCollection((JsonWriter)writer, this.nativeImage.imageBuilderEnvironment.entrySet(), Map.Entry.comparingByKey(), BundleSupport::printEnvironmentVariable);
        }
        catch (IOException e) {
            throw NativeImage.showError("Failed to write bundle-file " + String.valueOf(environmentFile), e);
        }
        if (this.containerSupport != null) {
            HashMap<String, String> containerInfo = new HashMap<String, String>();
            if (this.containerSupport.image != null) {
                containerInfo.put("containerImage", this.containerSupport.image);
            }
            if (this.containerSupport.tool != null) {
                containerInfo.put("containerTool", this.containerSupport.tool);
            }
            if (this.containerSupport.toolVersion != null) {
                containerInfo.put("containerToolVersion", this.containerSupport.toolVersion);
            }
            if (!containerInfo.isEmpty()) {
                Path containerFile = this.stageDir.resolve("container.json");
                try (JsonWriter writer = new JsonWriter(containerFile, new OpenOption[0]);){
                    writer.print(containerInfo);
                }
                catch (IOException e) {
                    throw NativeImage.showError("Failed to write bundle-file " + String.valueOf(containerFile), e);
                }
            }
        }
        Path dockerfilePath = this.stageDir.resolve("Dockerfile");
        try {
            if (this.containerSupport == null || !Files.exists(this.containerSupport.dockerfile, new LinkOption[0])) {
                if (!Files.exists(dockerfilePath, new LinkOption[0])) {
                    this.createDockerfile(dockerfilePath);
                }
            } else if (!dockerfilePath.equals(this.containerSupport.dockerfile)) {
                Files.copy(this.containerSupport.dockerfile, dockerfilePath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            throw NativeImage.showError("Failed to write bundle-file " + String.valueOf(dockerfilePath), e);
        }
        Path buildArgsFile = this.stageDir.resolve("build.json");
        ArrayList<String> bundleArgs = new ArrayList<String>(this.updatedNativeImageArgs != null ? this.updatedNativeImageArgs : this.nativeImageArgs);
        try (JsonWriter writer = new JsonWriter(buildArgsFile, new OpenOption[0]);){
            List<String> equalsNonBundleOptions = List.of("--verbose", "--dry-run");
            List<String> startsWithNonBundleOptions = List.of(BUNDLE_OPTION, "-E", this.nativeImage.oHPath);
            ListIterator<String> bundleArgsIterator = bundleArgs.listIterator();
            while (bundleArgsIterator.hasNext()) {
                String arg;
                block87: {
                    block86: {
                        arg = bundleArgsIterator.next();
                        if (equalsNonBundleOptions.contains(arg)) break block86;
                        if (!startsWithNonBundleOptions.stream().anyMatch(arg::startsWith)) break block87;
                    }
                    bundleArgsIterator.remove();
                    continue;
                }
                if (!arg.startsWith("-Dllvm.bin.dir=")) continue;
                Optional<String> existing = this.nativeImage.config.getBuildArgs().stream().filter(a -> a.startsWith("-Dllvm.bin.dir=")).findFirst();
                if (existing.isPresent() && !existing.get().equals(arg)) {
                    throw NativeImage.showError("Bundle native-image argument '" + arg + "' conflicts with existing '" + existing.get() + "'.");
                }
                bundleArgsIterator.remove();
            }
            JsonPrinter.printCollection((JsonWriter)writer, bundleArgs, null, BundleSupport::printBuildArg);
        }
        catch (IOException e) {
            throw NativeImage.showError("Failed to write bundle-file " + String.valueOf(buildArgsFile), e);
        }
        if (this.nativeImage.buildExecutable) {
            Path runArgsFile = this.stageDir.resolve("run.json");
            try (JsonWriter writer = new JsonWriter(runArgsFile, new OpenOption[0]);){
                boolean hasMainClass;
                ArrayList<String> runArgs = new ArrayList<String>(this.bundleLauncherArgs);
                boolean hasMainClassModule = this.nativeImage.mainClassModule != null && !this.nativeImage.mainClassModule.isEmpty();
                boolean bl = hasMainClass = this.nativeImage.mainClass != null && !this.nativeImage.mainClass.isEmpty();
                if (hasMainClassModule) {
                    runArgs.add("-m");
                    StringBuilder mainModule = new StringBuilder(this.nativeImage.mainClassModule);
                    if (hasMainClass) {
                        mainModule.append("/").append(this.nativeImage.mainClass);
                    }
                    runArgs.add(mainModule.toString());
                } else {
                    runArgs.add(this.nativeImage.mainClass);
                }
                JsonPrinter.printCollection((JsonWriter)writer, runArgs, null, BundleSupport::printBuildArg);
            }
            catch (IOException e) {
                throw NativeImage.showError("Failed to write bundle-file " + String.valueOf(runArgsFile), e);
            }
        }
        this.bundleProperties.write();
        Path bundleFilePath = this.bundlePath.resolve(this.bundleName + BUNDLE_FILE_EXTENSION);
        Manifest manifest = this.nativeImage.archiveSupport().createManifest(BundleLauncher.class.getName());
        this.nativeImage.archiveSupport().compressDirToJar(this.rootDir, bundleFilePath, manifest);
        return bundleFilePath;
    }

    private static void printPathMapping(Map.Entry<Path, Path> entry, JsonWriter w) throws IOException {
        w.append('{').quote(substitutionMapSrcField).append(':').printValue((Object)entry.getKey());
        w.append(',').quote(substitutionMapDstField).append(':').printValue((Object)entry.getValue());
        w.append('}');
    }

    private static void printBuildArg(String entry, JsonWriter w) throws IOException {
        w.quote(entry);
    }

    private static void printEnvironmentVariable(Map.Entry<String, String> entry, JsonWriter w) throws IOException {
        if (entry.getValue() == null) {
            throw NativeImage.showError("Storing environment variable '" + entry.getKey() + "' in bundle requires to have its value defined.");
        }
        w.append('{').quote(environmentKeyField).append(':').quote(entry.getKey());
        w.append(',').quote(environmentValueField).append(':').quote(entry.getValue());
        w.append('}');
    }

    static enum BundleOptionVariants {
        create,
        apply;


        String optionName() {
            return "--bundle-" + String.valueOf((Object)this);
        }
    }

    private final class BundleProperties {
        private static final String PROPERTY_KEY_BUNDLE_FILE_VERSION_MAJOR = "BundleFileVersionMajor";
        private static final String PROPERTY_KEY_BUNDLE_FILE_VERSION_MINOR = "BundleFileVersionMinor";
        private static final String PROPERTY_KEY_BUNDLE_FILE_CREATION_TIMESTAMP = "BundleFileCreationTimestamp";
        private static final String PROPERTY_KEY_BUILDER_ON_CLASSPATH = "BuilderOnClasspath";
        private static final String PROPERTY_KEY_IMAGE_BUILT = "ImageBuilt";
        private static final String PROPERTY_KEY_BUILT_WITH_CONTAINER = "BuiltWithContainer";
        private static final String PROPERTY_KEY_NATIVE_IMAGE_PLATFORM = "NativeImagePlatform";
        private static final String PROPERTY_KEY_NATIVE_IMAGE_VENDOR = "NativeImageVendor";
        private static final String PROPERTY_KEY_NATIVE_IMAGE_VERSION = "NativeImageVersion";
        private static final String PROPERTY_KEY_IMAGE_BUILD_ID = "ImageBuildID";
        private final Path bundlePropertiesFile;
        private final Map<String, String> properties;

        private BundleProperties() {
            Objects.requireNonNull(BundleSupport.this.rootDir);
            Objects.requireNonNull(BundleSupport.this.nativeImage);
            this.bundlePropertiesFile = BundleSupport.this.rootDir.resolve(bundlePropertiesFileName);
            this.properties = new HashMap<String, String>();
        }

        private void loadAndVerify() {
            Objects.requireNonNull(BundleSupport.this.bundleName);
            String bundleFileName = BundleSupport.this.bundlePath.resolve(BundleSupport.this.bundleName + BundleSupport.BUNDLE_FILE_EXTENSION).toString();
            if (!Files.isReadable(this.bundlePropertiesFile)) {
                throw NativeImage.showError("The given bundle file " + bundleFileName + " does not contain a bundle properties file");
            }
            this.properties.putAll(ArchiveSupport.loadProperties((Path)this.bundlePropertiesFile));
            String fileVersionKey = PROPERTY_KEY_BUNDLE_FILE_VERSION_MAJOR;
            try {
                int major = Integer.parseInt(this.properties.getOrDefault(fileVersionKey, "-1"));
                fileVersionKey = PROPERTY_KEY_BUNDLE_FILE_VERSION_MINOR;
                int minor = Integer.parseInt(this.properties.getOrDefault(fileVersionKey, "-1"));
                String message = String.format("The given bundle file %s was created with newer bundle-file-format version %d.%d (current %d.%d). Update to the latest version of native-image.", bundleFileName, major, minor, 0, 9);
                if (major > 0) {
                    throw NativeImage.showError(message);
                }
                if (major == 0 && minor > 9) {
                    LogUtils.warning((String)message);
                }
            }
            catch (NumberFormatException e) {
                throw NativeImage.showError(fileVersionKey + " in " + String.valueOf(bundlePropertiesFileName) + " is missing or ill-defined", e);
            }
            String bundleVendor = this.properties.getOrDefault(PROPERTY_KEY_NATIVE_IMAGE_VENDOR, "unknown");
            String javaVmVendor = System.getProperty("java.vm.vendor");
            Object currentVendor = bundleVendor.equals(javaVmVendor) ? "" : " != '" + javaVmVendor + "'";
            String bundleVersion = this.properties.getOrDefault(PROPERTY_KEY_NATIVE_IMAGE_VERSION, "unknown");
            String javaVmVersion = System.getProperty("java.vm.version");
            Object currentVersion = bundleVersion.equals(javaVmVersion) ? "" : " != '" + javaVmVersion + "'";
            String bundlePlatform = this.properties.getOrDefault(PROPERTY_KEY_NATIVE_IMAGE_PLATFORM, "unknown");
            Object currentPlatform = bundlePlatform.equals(NativeImage.platform) ? "" : " != '" + NativeImage.platform + "'";
            String bundleCreationTimestamp = this.properties.getOrDefault(PROPERTY_KEY_BUNDLE_FILE_CREATION_TIMESTAMP, "");
            BundleSupport.this.nativeImage.showNewline();
            BundleSupport.this.nativeImage.showMessage("%sLoaded Bundle from %s", BundleSupport.BUNDLE_INFO_MESSAGE_PREFIX, bundleFileName);
            BundleSupport.this.nativeImage.showMessage("%sBundle created at '%s'", BundleSupport.BUNDLE_INFO_MESSAGE_PREFIX, ArchiveSupport.parseTimestamp((String)bundleCreationTimestamp));
            BundleSupport.this.nativeImage.showMessage("%sUsing version: '%s'%s (vendor '%s'%s) on platform: '%s'%s", BundleSupport.BUNDLE_INFO_MESSAGE_PREFIX, bundleVersion, currentVersion, bundleVendor, currentVendor, bundlePlatform, currentPlatform);
        }

        private boolean forceBuilderOnClasspath() {
            assert (!this.properties.isEmpty()) : "Needs to be called after loadAndVerify()";
            return Boolean.parseBoolean(this.properties.getOrDefault(PROPERTY_KEY_BUILDER_ON_CLASSPATH, Boolean.FALSE.toString()));
        }

        private boolean requireContainerBuild() {
            assert (!this.properties.isEmpty()) : "Needs to be called after loadAndVerify()";
            return Boolean.parseBoolean(this.properties.getOrDefault(PROPERTY_KEY_BUILT_WITH_CONTAINER, Boolean.FALSE.toString()));
        }

        private void write() {
            this.properties.put(PROPERTY_KEY_BUNDLE_FILE_VERSION_MAJOR, String.valueOf(0));
            this.properties.put(PROPERTY_KEY_BUNDLE_FILE_VERSION_MINOR, String.valueOf(9));
            this.properties.put(PROPERTY_KEY_BUNDLE_FILE_CREATION_TIMESTAMP, ArchiveSupport.currentTime());
            this.properties.put(PROPERTY_KEY_BUILDER_ON_CLASSPATH, String.valueOf(BundleSupport.this.forceBuilderOnClasspath));
            boolean imageBuilt = !BundleSupport.this.nativeImage.isDryRun();
            this.properties.put(PROPERTY_KEY_IMAGE_BUILT, String.valueOf(imageBuilt));
            if (imageBuilt) {
                this.properties.put(PROPERTY_KEY_BUILT_WITH_CONTAINER, String.valueOf(BundleSupport.this.useContainer));
            }
            this.properties.put(PROPERTY_KEY_NATIVE_IMAGE_PLATFORM, NativeImage.platform);
            this.properties.put(PROPERTY_KEY_NATIVE_IMAGE_VENDOR, System.getProperty("java.vm.vendor"));
            this.properties.put(PROPERTY_KEY_NATIVE_IMAGE_VERSION, System.getProperty("java.vm.version"));
            NativeImage.ensureDirectoryExists(this.bundlePropertiesFile.getParent());
            try (OutputStream outputStream = Files.newOutputStream(this.bundlePropertiesFile, new OpenOption[0]);){
                Properties p = new Properties();
                p.putAll(this.properties);
                p.store(outputStream, "Native Image bundle file properties");
            }
            catch (IOException e) {
                throw NativeImage.showError("Creating bundle properties file " + String.valueOf(bundlePropertiesFileName) + " failed", e);
            }
        }
    }

    static final class BundlePathSubstitutionError
    extends Error {
        public final Path origPath;

        BundlePathSubstitutionError(String message, Path origPath) {
            super(message);
            this.origPath = origPath;
        }
    }
}

