/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.driver;

import com.oracle.svm.core.SubstrateUtil;
import java.util.Arrays;

public class BundleOptions {
    public static BundleOption parseBundleOption(String cmdLineArg) {
        String[] options = SubstrateUtil.split((String)cmdLineArg.substring("--bundle".length() + 1), (String)",");
        String[] variantAndFileName = SubstrateUtil.split((String)options[0], (String)"=", (int)2);
        String variant = variantAndFileName[0];
        String fileName = null;
        if (variantAndFileName.length == 2) {
            fileName = variantAndFileName[1];
        }
        ExtendedOption[] extendedOptions = (ExtendedOption[])Arrays.stream(options).skip(1L).map(BundleOptions::parseExtendedOption).toArray(ExtendedOption[]::new);
        return new BundleOption(variant, fileName, extendedOptions);
    }

    private static ExtendedOption parseExtendedOption(String option) {
        String[] optionParts = SubstrateUtil.split((String)option, (String)"=", (int)2);
        if (optionParts.length == 2) {
            return new ExtendedOption(optionParts[0], optionParts[1]);
        }
        return new ExtendedOption(option, null);
    }

    public record ExtendedOption(String key, String value) {
    }

    public record BundleOption(String variant, String fileName, ExtendedOption[] extendedOptions) {
    }
}

