/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.virtualization.core;

import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.util.InterruptImageBuilding;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.virtualization.core.VirtualizationMainWrapper;
import com.oracle.svm.enterprise.virtualization.core.VirtualizationOptions;
import com.oracle.svm.enterprise.virtualization.core.VirtualizationTarget;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.c.util.FileUtils;
import com.oracle.svm.hosted.code.CEntryPointData;
import com.oracle.svm.hosted.image.AbstractImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.ForeignCallNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugins;
import jdk.graal.compiler.phases.util.Providers;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.Pair;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.c.type.CCharPointerPointer;
import org.graalvm.nativeimage.hosted.Feature;

public abstract class b
implements InternalFeature {
    protected static final String ER = "_unikernel.sh";
    protected static final String ES = "/";
    protected VirtualizationTarget ET;
    protected Path EU;
    protected Path EV;
    protected String EW;
    protected String EX;
    protected String EY;

    public void afterRegistration(Feature.AfterRegistrationAccess afterRegistrationAccess) {
        if (!Platform.includedIn(Platform.LINUX_AMD64.class)) {
            throw UserError.abort((String)"Unsupported platform for %s. Currently, only Linux AMD64 is supported.", (Object[])new Object[]{SubstrateOptionsParser.commandArgument(VirtualizationOptions.Virtualize, (String)((String)VirtualizationOptions.Virtualize.getValue()))});
        }
        FeatureImpl.AfterRegistrationAccessImpl afterRegistrationAccessImpl = (FeatureImpl.AfterRegistrationAccessImpl)afterRegistrationAccess;
        try {
            Method method = Class.forName(this.kO()).getDeclaredMethod("run", Integer.TYPE, CCharPointerPointer.class);
            afterRegistrationAccessImpl.setMainEntryPoint(Pair.create((Object)method, (Object)CEntryPointData.create((Method)method, (String)AbstractImage.NativeImageKind.EXECUTABLE.mainEntryPointName)));
        }
        catch (Exception exception) {
            VMError.shouldNotReachHere((Throwable)exception);
        }
    }

    public void duringSetup(Feature.DuringSetupAccess duringSetupAccess) {
        UserError.guarantee((boolean)((Boolean)SubstrateOptions.StaticExecutable.getValue()), (String)"An image can only be created with a statically linked binary", (Object[])new Object[0]);
        UserError.guarantee(((Boolean)SubstrateOptions.SharedLibrary.getValue() == false ? 1 : 0) != 0, (String)"An image can only be created with an executable", (Object[])new Object[0]);
        this.ET = VirtualizationOptions.consumeTarget();
    }

    private static void f(Path path) {
        try {
            Set<PosixFilePermission> set = Files.getPosixFilePermissions(path, new LinkOption[0]);
            set.add(PosixFilePermission.OWNER_EXECUTE);
            Files.setPosixFilePermissions(path, set);
        }
        catch (IOException iOException) {
            throw UserError.abort((String)"Error when adding execute permission to file: %s%n Check if you have proper permissions for such an action.", (Object[])new Object[]{path.toAbsolutePath()});
        }
    }

    private void kI() {
        try {
            Files.createDirectory(Paths.get(this.EU.toString(), "proc"), new FileAttribute[0]);
            Files.createDirectory(Paths.get(this.EU.toString(), "dev"), new FileAttribute[0]);
        }
        catch (IOException iOException) {
            throw UserError.abort((String)"Unable to create required directories in path %s. Check if you have write permissions in that path.", (Object[])new Object[]{this.EU.toAbsolutePath()});
        }
    }

    private void kJ() {
        try {
            Files.copy(Paths.get(this.EV.toString(), this.EW), Paths.get(this.EU.toString(), this.EW), new CopyOption[0]);
        }
        catch (IOException iOException) {
            throw UserError.abort((String)"Unable to copy image from %s to %s", (Object[])new Object[]{Paths.get(this.EV.toString(), this.EW), Paths.get(this.EU.toString(), this.EW)});
        }
    }

    private Path a(Path path, Path path2, Path path3) {
        int n2;
        int n3 = path.getNameCount();
        if (n3 == (n2 = path2.getNameCount())) {
            return Paths.get(this.EU.toString(), path3.toString());
        }
        Path path4 = path2.subpath(n3, n2);
        return Paths.get(this.EU.toString(), path3.toString(), path4.toString());
    }

    private void kK() {
        List<Pair<Path, Path>> list = this.ET.getFilesForTransfer();
        for (Pair<Path, Path> pair : list) {
            Path path = (Path)pair.getLeft();
            Path path2 = (Path)pair.getRight();
            try {
                Files.walk(path, new FileVisitOption[0]).forEach(path3 -> {
                    Path path4 = this.a(path, (Path)path3, path2);
                    Path path5 = path4.getParent();
                    try {
                        assert (path5 != null);
                        if (!Files.exists(path5, new LinkOption[0])) {
                            Files.createDirectories(path5, new FileAttribute[0]);
                        }
                        if (Files.isRegularFile(path3, new LinkOption[0])) {
                            Files.copy(path3, path4, new CopyOption[0]);
                        } else if (Files.isDirectory(path3, new LinkOption[0])) {
                            Files.createDirectory(path4, new FileAttribute[0]);
                        }
                    }
                    catch (IOException iOException) {
                        throw UserError.abort((String)"Unable to write to: %s. Check if you have write permissions in the selected folder.", (Object[])new Object[]{path4});
                    }
                });
            }
            catch (IOException iOException) {
                VMError.shouldNotReachHere((Throwable)iOException);
            }
        }
    }

    private String av(String string) {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        return bufferedReader.lines().collect(Collectors.joining(System.lineSeparator()));
    }

    private void kL() {
        Path path = Paths.get(this.EV.toString(), this.EX);
        String string = ES + this.EW;
        try {
            String string2 = this.av("com/oracle/svm/enterprise/virtualization/vmm/scripts/shared_run.template");
            String string3 = this.av("com/oracle/svm/enterprise/virtualization/vmm/scripts/" + this.kQ());
            String string4 = "#!/bin/bash" + System.lineSeparator() + "# This script was automatically generated." + System.lineSeparator() + "# The primary goal of this script is to allow users to locally test their machines and see if they work." + System.lineSeparator() + "IMAGE_PATH_ON_DISK=" + string + System.lineSeparator() + "FILE_FORMAT=" + this.ET.getImageFormat() + System.lineSeparator() + "KERNEL_PATH=" + this.ET.getImagePath() + System.lineSeparator() + "IMAGE_NAME=" + this.EY + System.lineSeparator() + string2 + string3;
            Files.write(path, string4.getBytes(), new OpenOption[0]);
            b.f(path);
        }
        catch (Exception exception) {
            VMError.shouldNotReachHere((Throwable)exception);
        }
    }

    private String[] kM() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add("virt-make-fs");
        arrayList.add("--type=ext4");
        if (this.ET.isFileSystemSizeSet()) {
            arrayList.add("--size=" + this.ET.getFileSystemSizeInBytes());
        }
        arrayList.add("--format=" + this.ET.getImageFormat());
        arrayList.add(this.EU.toString());
        arrayList.add(Paths.get(this.EV.toString(), this.EY).toString());
        return arrayList.toArray(new String[0]);
    }

    private void kN() {
        String[] stringArray = this.kM();
        Process process = null;
        try {
            List list;
            ProcessBuilder processBuilder = FileUtils.prepareCommand(Arrays.asList(stringArray), null);
            FileUtils.traceCommand((ProcessBuilder)processBuilder);
            process = processBuilder.start();
            try (InputStream inputStream = process.getErrorStream();){
                list = FileUtils.readAllLines((InputStream)inputStream);
                FileUtils.traceCommandOutput((List)list);
            }
            int n2 = process.waitFor();
            if (n2 != 0) {
                for (String string : list) {
                    if (!string.contains("No space left on device")) continue;
                    throw UserError.abort((String)"Specified file system size is too small. Set max-file-system-size in %s to a bigger value, or omit the attribute for the smallest possible size.", (Object[])new Object[]{VirtualizationOptions.Virtualize.getValue()});
                }
                throw UserError.abort((String)"Error while running virt-make-fs.%nProgram output:%n%s", (Object[])new Object[]{String.join((CharSequence)System.lineSeparator(), list)});
            }
        }
        catch (IOException iOException) {
            throw UserError.abort((String)"Unable to start virt-make-fs command. Check if you have libguestfs-tools installed.", (Object[])new Object[0]);
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptImageBuilding("Interrupted in call to virt-make-fs.");
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
    }

    private void a(FeatureImpl.AfterImageWriteAccessImpl afterImageWriteAccessImpl) {
        Path path = afterImageWriteAccessImpl.getTempDirectory();
        this.EU = Paths.get(path.toString(), "VirtualizationTempDir");
        Path path2 = afterImageWriteAccessImpl.getImagePath();
        this.EV = path2.getParent();
        this.EW = path2.getName(path2.getNameCount() - 1).toString();
        this.EY = this.EW + ".img";
        this.EX = this.EW + ER;
    }

    public void afterImageWrite(Feature.AfterImageWriteAccess afterImageWriteAccess) {
        FeatureImpl.AfterImageWriteAccessImpl afterImageWriteAccessImpl = (FeatureImpl.AfterImageWriteAccessImpl)afterImageWriteAccess;
        this.a(afterImageWriteAccessImpl);
        try {
            Files.createDirectory(this.EU, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            throw UserError.abort((String)"Cannot create temporary directory %s. Check if you have write access in the parent directory.", (Object[])new Object[]{this.EU});
        }
        this.kI();
        this.kJ();
        this.kK();
        this.kN();
        this.kL();
    }

    public void registerInvocationPlugins(Providers providers, GraphBuilderConfiguration.Plugins plugins, ParsingReason parsingReason) {
        InvocationPlugins.Registration registration = new InvocationPlugins.Registration(plugins.getInvocationPlugins(), this.kP());
        registration.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin(this, "mountProcFS", new Type[0]){

            public boolean apply(GraphBuilderContext graphBuilderContext, ResolvedJavaMethod resolvedJavaMethod, InvocationPlugin.Receiver receiver) {
                ForeignCallNode foreignCallNode = new ForeignCallNode((ForeignCallDescriptor)VirtualizationMainWrapper.EZ, new ValueNode[0]);
                graphBuilderContext.addPush(JavaKind.Int, (ValueNode)foreignCallNode);
                return true;
            }
        });
        registration.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin(this, "rebootKernelForeignCall", new Type[0]){

            public boolean apply(GraphBuilderContext graphBuilderContext, ResolvedJavaMethod resolvedJavaMethod, InvocationPlugin.Receiver receiver) {
                ForeignCallNode foreignCallNode = new ForeignCallNode((ForeignCallDescriptor)VirtualizationMainWrapper.Fa, new ValueNode[0]);
                graphBuilderContext.addPush(JavaKind.Int, (ValueNode)foreignCallNode);
                return true;
            }
        });
    }

    public void registerForeignCalls(SubstrateForeignCallsProvider substrateForeignCallsProvider) {
        substrateForeignCallsProvider.register(new SnippetRuntime.SubstrateForeignCallDescriptor[]{VirtualizationMainWrapper.EZ});
        substrateForeignCallsProvider.register(new SnippetRuntime.SubstrateForeignCallDescriptor[]{VirtualizationMainWrapper.Fa});
    }

    public void cleanup() {
        try {
            Files.delete(Paths.get(this.EV.toString(), this.EW));
        }
        catch (IOException iOException) {
            throw UserError.abort((String)"Failed to delete generated image. Check if you have write permission in directory: %s", (Object[])new Object[]{this.EV});
        }
    }

    public abstract String kO();

    public abstract Class<?> kP();

    public abstract String kQ();
}

