/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.profiling.framework;

import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.sampler.CallStackFrameMethodInfo;
import com.oracle.svm.enterprise.core.annotate.a;
import com.oracle.svm.enterprise.profiling.framework.CommonInstrumentationData;
import com.oracle.svm.enterprise.profiling.framework.Metadata;
import com.oracle.svm.enterprise.profiling.framework.PeriodicProfileDumper;
import com.oracle.svm.enterprise.profiling.framework.ProfileDumper;
import com.oracle.svm.enterprise.profiling.framework.SamplingData;
import com.oracle.svm.enterprise.profiling.profiles.ProfilingRuntimeProfile;
import com.oracle.svm.enterprise.profiling.r;
import java.util.function.Function;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;

public final class ProfilingData
implements ProfileDumper.DumpableData {
    private final CommonInstrumentationData instrumentationData;
    private final SamplingData samplingData;
    private final PeriodicProfileDumper periodicProfileDumper;
    private final boolean profileInstanceOf;
    @a
    private Metadata metadata;

    @Fold
    public static ProfilingData singleton() {
        return (ProfilingData)ImageSingletons.lookup(ProfilingData.class);
    }

    public ProfilingData(CommonInstrumentationData commonInstrumentationData, SamplingData samplingData, boolean bl2) {
        this.instrumentationData = commonInstrumentationData;
        this.samplingData = samplingData;
        this.periodicProfileDumper = new PeriodicProfileDumper();
        this.profileInstanceOf = bl2;
    }

    @Override
    public Metadata metadata() {
        return this.metadata;
    }

    @Override
    public CommonInstrumentationData commonInstrumentationData() {
        return this.instrumentationData;
    }

    public PeriodicProfileDumper periodicProfileDumper() {
        return this.periodicProfileDumper;
    }

    @Override
    public SamplingData samplingData() {
        return this.samplingData;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public static RuntimeSupport.Hook getShutdownHook() {
        return bl2 -> {
            if (!bl2) {
                return;
            }
            ProfileDumper profileDumper = ProfilingData.singleton().profileInstanceOf ? new ProfileDumper.Experimental.WithInstanceOfProfiles(ProfilingData.singleton(), ProfilingData.toAnalysisMethodId(), (Boolean)ProfileDumper.Options.ProfilesIncludeException.getValue()) : ProfileDumper.createDefault(ProfilingData.singleton(), ProfilingData.toAnalysisMethodId(), (Boolean)ProfileDumper.Options.ProfilesIncludeException.getValue());
            ProfileDumper.dumpToFile(profileDumper, ProfilingRuntimeProfile.getPath(), (Boolean)ProfilingRuntimeProfile.Options.ProfilingDumpVerbose.getValue());
        };
    }

    public static Function<Integer, Integer> toAnalysisMethodId() {
        Function<Integer, Integer> function = ImageSingletons.contains(CallStackFrameMethodInfo.class) ? ((r)ImageSingletons.lookup(CallStackFrameMethodInfo.class))::T : n2 -> {
            throw new IllegalStateException();
        };
        return function;
    }

    public void reset() {
        this.instrumentationData.storage().reset();
    }
}

