/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.ml.phases;

import com.oracle.graal.compiler.enterprise.ml.features.c;
import com.oracle.graal.compiler.enterprise.ml.features.provider.b;
import com.oracle.graal.compiler.enterprise.ml.models.a;
import com.oracle.graal.compiler.enterprise.ml.phases.ExtractGraphMLFeaturesBasePhase;
import com.oracle.graal.compiler.enterprise.ml.phases.InferGraphProfilesBasePhase;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.hosted.ml.features.provider.a;
import com.oracle.svm.enterprise.hosted.ml.inferencer.Inferencer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.iterators.FilteredNodeIterable;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.ControlSplitNode;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.ProfileData;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import org.graalvm.nativeimage.ImageSingletons;

public class InferControlSplitProfilesPhase
extends InferGraphProfilesBasePhase<Node, c> {
    private static final float ty = 1.4E-44f;
    private static final float tz = 1.0f;
    private final boolean tA;

    public InferControlSplitProfilesPhase(com.oracle.graal.compiler.enterprise.ml.features.provider.c<Node, c> c2, boolean bl2) {
        super(c2, (com.oracle.graal.compiler.enterprise.ml.models.a)ImageSingletons.lookup(com.oracle.svm.enterprise.hosted.ml.models.a.class));
        this.tA = bl2;
    }

    protected void run(StructuredGraph structuredGraph, CoreProviders coreProviders) {
        String string = ExtractGraphMLFeaturesBasePhase.b((StructuredGraph)structuredGraph);
        if (!this.cJ.h(string)) {
            return;
        }
        b b2 = this.cJ.g(string);
        Map<Node, Float> map = this.b((b<Node, c>)b2, structuredGraph);
        FilteredNodeIterable<Node> filteredNodeIterable = InferControlSplitProfilesPhase.c(structuredGraph);
        for (Node node : filteredNodeIterable) {
            assert (node instanceof ControlSplitNode) : "Can not infer profiles for the non control split node: " + String.valueOf(node);
            if (!map.containsKey(node)) continue;
            ProfileData.ProfileSource profileSource = ((ControlSplitNode)node).getProfileData().getProfileSource();
            if (profileSource.isUnknown()) {
                InferControlSplitProfilesPhase.a((ControlSplitNode)node, map.get(node));
            }
            if (!profileSource.isProfiled() || !a.fF()) continue;
            InferControlSplitProfilesPhase.a(structuredGraph, node, (b<Node, c>)b2, map);
            InferControlSplitProfilesPhase.a((ControlSplitNode)node, map.get(node));
        }
    }

    private Map<Node, Float> b(b<Node, c> b2, StructuredGraph structuredGraph) {
        a.a a2 = null;
        try {
            a2 = this.cK.a(b2, structuredGraph);
        }
        catch (Inferencer.InferenceException inferenceException) {
            a.a(inferenceException, "Invalid ONNX Profile Inference", false);
        }
        catch (Exception exception) {
            a.a(exception, "General Inference Exception", false);
        }
        HashMap<Node, Float> hashMap = new HashMap<Node, Float>();
        if (a2 == null) {
            return hashMap;
        }
        for (int i2 = 0; i2 < a2.w().size(); ++i2) {
            if (this.tA) {
                a2.x()[i2] = InferControlSplitProfilesPhase.a(a2.x()[i2]);
            }
            hashMap.put((Node)a2.w().get(i2), Float.valueOf(a2.x()[i2]));
        }
        return hashMap;
    }

    protected static void a(StructuredGraph structuredGraph, Node node, b<Node, c> b2, Map<Node, Float> map) {
        Optional optional = b2.a((Object)node);
        assert (optional.isPresent()) : "Features must be present as we have the ML predicted profile for the node: " + String.valueOf(node);
        long l2 = ((com.oracle.svm.enterprise.hosted.ml.features.a)optional.get()).getLabelCount();
        com.oracle.svm.enterprise.hosted.ml.logging.a.a(structuredGraph, (IfNode)node, ((ProfileData.BranchProbabilityData)((ControlSplitNode)node).getProfileData()).getDesignatedSuccessorProbability(), map.get(node).floatValue(), l2);
    }

    public static FilteredNodeIterable<Node> c(StructuredGraph structuredGraph) {
        return com.oracle.svm.enterprise.hosted.profiling.utilities.a.k(structuredGraph).filter(node -> com.oracle.svm.enterprise.hosted.profiling.utilities.a.e((ControlSplitNode)node));
    }

    protected static float a(float f2) {
        if (f2 < 1.4E-44f) {
            return 1.4E-44f;
        }
        if (f2 > 1.0f) {
            return 1.0f;
        }
        return f2;
    }

    protected static void a(ControlSplitNode controlSplitNode, Float f2) {
        Map<Node, Double> map = InferControlSplitProfilesPhase.a(controlSplitNode, (double)f2.floatValue());
        List list = controlSplitNode.successors().snapshot();
        List<Node> list2 = list.stream().filter(Node::isAlive).collect(Collectors.toList());
        List<Node> list3 = InferControlSplitProfilesPhase.successorsMatchingProfiles(list2, map);
        list3.forEach(node -> {
            ProfileData.ProfileSource profileSource = controlSplitNode.getProfileData().getProfileSource();
            if ((profileSource.isInjected() || profileSource.isProfiled() || profileSource.isAdopted()) && !a.fF()) {
                VMError.shouldNotReachHere((String)("Fatal Error: can not override injected/profiled/adopted profiles (node = " + String.valueOf(controlSplitNode) + ")."));
            }
            controlSplitNode.setProbability((AbstractBeginNode)node, ProfileData.BranchProbabilityData.inferred((double)((Double)map.get(node))));
        });
    }

    private static Map<Node, Double> a(ControlSplitNode controlSplitNode, double d2) {
        assert (controlSplitNode instanceof IfNode) : "Can not update conditional probabilities for node: " + String.valueOf(controlSplitNode) + ": can infer only the if nodes.";
        AbstractBeginNode abstractBeginNode = ((IfNode)controlSplitNode).trueSuccessor();
        HashMap<Node, Double> hashMap = new HashMap<Node, Double>();
        hashMap.put((Node)abstractBeginNode, d2);
        return hashMap;
    }

    private static List<Node> successorsMatchingProfiles(List<Node> list, Map<Node, Double> map) {
        return list.stream().filter(map::containsKey).collect(Collectors.toList());
    }
}

