/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.code.layout;

import com.oracle.svm.core.util.ConcurrentIdentityHashMap;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.util.concurrent.ConcurrentMap;
import jdk.graal.compiler.debug.Assertions;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public class a {
    private ConcurrentMap<HostedMethod, EconomicMap<HostedMethod, Long>> rD = new ConcurrentIdentityHashMap();

    public boolean i(HostedMethod hostedMethod) {
        return !this.rD.containsKey(hostedMethod);
    }

    public void a(HostedMethod hostedMethod, EconomicMap<HostedMethod, Long> economicMap) {
        this.rD.put(hostedMethod, economicMap);
    }

    public void eL() {
        EconomicSet economicSet = EconomicSet.create((Equivalence)Equivalence.IDENTITY);
        economicSet.addAll(this.rD.keySet());
        for (HostedMethod hostedMethod : this.rD.keySet()) {
            economicSet.addAll(((EconomicMap)this.rD.get(hostedMethod)).getKeys());
        }
        assert (this.rD.keySet().size() == economicSet.size()) : "The number of methods for which the CalculateCallEdgeCountPhase/CalculateCallEdgeInfoPhase was called is not the same as the number of methods that are profiled/considered.\nPhase called for " + this.rD.keySet().size() + " methods, while the number of profiled/considered methods is " + economicSet.size() + "\nPhase not called for: " + this.d((EconomicSet<HostedMethod>)economicSet);
    }

    String d(EconomicSet<HostedMethod> economicSet) {
        StringBuilder stringBuilder = new StringBuilder();
        for (HostedMethod hostedMethod : economicSet) {
            if (this.rD.containsKey(hostedMethod)) continue;
            stringBuilder.append("\n").append(hostedMethod);
            for (HostedMethod hostedMethod2 : this.rD.keySet()) {
                if (!((EconomicMap)this.rD.get(hostedMethod2)).containsKey((Object)hostedMethod)) continue;
                stringBuilder.append("\n  ").append(" called by\n").append(hostedMethod2);
            }
            stringBuilder.append("\n------------------");
        }
        return stringBuilder.toString();
    }

    public UnmodifiableEconomicMap<HostedMethod, UnmodifiableEconomicMap<HostedMethod, Long>> eM() {
        if (this.rD == null) {
            throw VMError.shouldNotReachHere((Throwable)new NullPointerException("Access to callEdgeMap after it's been cleared."));
        }
        if (Assertions.assertionsEnabled()) {
            this.eL();
        }
        EconomicMap economicMap = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
        for (HostedMethod hostedMethod : this.rD.keySet()) {
            economicMap.put((Object)hostedMethod, (Object)((UnmodifiableEconomicMap)this.rD.get(hostedMethod)));
        }
        return economicMap;
    }

    public void clear() {
        if (this.rD != null) {
            this.rD.clear();
            this.rD = null;
        }
    }
}

