/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.openssl.MdAlg;
import com.oracle.jipher.internal.openssl.Pkey;
import com.oracle.jipher.internal.spi.InternalProvider;
import com.oracle.jipher.internal.spi.RsaDigestSig;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;

public final class RsaPssGeneralSig
extends RsaDigestSig {
    private boolean initCalled = false;
    private boolean initSign = false;
    private boolean updateInProgress = false;
    private int saltLen;

    static void verifyParams(String digest, PSSParameterSpec spec) throws InvalidAlgorithmParameterException {
        if (!spec.getMGFAlgorithm().equals("MGF1")) {
            throw new InvalidAlgorithmParameterException("Only MGF1 supported as MGF algorithm");
        }
        if (!(spec.getMGFParameters() instanceof MGF1ParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Expected MGF1ParameterSpec");
        }
        if (!((MGF1ParameterSpec)spec.getMGFParameters()).getDigestAlgorithm().equals(digest)) {
            throw new InvalidAlgorithmParameterException("MGF1ParameterSpec digest must match signature digest.");
        }
        if (spec.getTrailerField() != 1) {
            throw new InvalidAlgorithmParameterException("Unsupported TrailerField option, must be 1");
        }
    }

    public RsaPssGeneralSig() {
        super(null);
    }

    @Override
    protected void engineUpdate(byte[] data, int off, int len) throws SignatureException {
        if (!this.isInitialized) {
            throw new SignatureException("PSS parameters have not been set.");
        }
        super.engineUpdate(data, off, len);
        this.updateInProgress = true;
    }

    @Override
    public byte[] engineSign() throws SignatureException {
        if (!this.isInitialized) {
            throw new SignatureException("PSS parameters have not been set.");
        }
        this.updateInProgress = false;
        return super.engineSign();
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes, int offset, int len) throws SignatureException {
        if (!this.isInitialized) {
            throw new SignatureException("PSS parameters have not been set.");
        }
        this.updateInProgress = false;
        return super.engineVerify(sigBytes, offset, len);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        super.engineInitSign(privateKey);
        this.initCalled = true;
        this.initSign = true;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        super.engineInitVerify(publicKey);
        this.initCalled = true;
        this.initSign = false;
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        if (this.updateInProgress) {
            throw new ProviderException("Cannot call setParameter during signature operation.");
        }
        if (!(params instanceof PSSParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Must be PSSParameterSpec");
        }
        PSSParameterSpec spec = (PSSParameterSpec)params;
        this.md = MdAlg.byName(spec.getDigestAlgorithm());
        RsaPssGeneralSig.verifyParams(this.md.getAlg(), spec);
        this.saltLen = spec.getSaltLength();
        if (this.initCalled) {
            try {
                this.doInit(this.lastPkey, this.initSign);
            }
            catch (InvalidKeyException e) {
                throw new InvalidAlgorithmParameterException("Invalid key");
            }
        }
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        try {
            if (this.md == null) {
                throw new ProviderException("Digest algorithm not yet set");
            }
            AlgorithmParameters params = AlgorithmParameters.getInstance("RSASSA-PSS", InternalProvider.get());
            params.init(new PSSParameterSpec(this.md.getAlg(), "MGF1", new MGF1ParameterSpec(this.md.getAlg()), this.saltLen, 1));
            return params;
        }
        catch (NoSuchAlgorithmException | InvalidParameterSpecException e) {
            throw new ProviderException(e);
        }
    }

    @Override
    void doInit(Pkey pkey, boolean isSign) throws InvalidKeyException {
        if (this.md == null) {
            this.lastPkey = pkey;
        } else {
            super.doInit(pkey, isSign);
            this.ctx.setPssPadding();
            try {
                this.ctx.setPssParams(this.saltLen);
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new ProviderException(e);
            }
        }
    }
}

