/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.common.ToolkitProperties;
import com.oracle.jipher.internal.common.Util;
import com.oracle.jipher.internal.spi.CipherAlg;
import com.oracle.jipher.internal.spi.SymmCipher;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.crypto.AEADBadTagException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.GCMParameterSpec;

public abstract class AeadCipher
extends SymmCipher {
    byte[] tag;
    int fillOffset;
    boolean ivGenerated;
    static final int CONSOLIDATION_BUF_SIZE = 4096;
    final List<byte[]> ctBufList = new ArrayList<byte[]>();
    ByteBuffer ctConsolidationBuf;
    int ctBufferLen = 0;

    AeadCipher(CipherAlg cipherAlg) {
        super(cipherAlg);
    }

    void ensureParamSpec() {
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        this.ensureParamSpec();
        return super.engineGetParameters();
    }

    @Override
    protected byte[] engineGetIV() {
        this.ensureParamSpec();
        return super.engineGetIV();
    }

    @Override
    protected void engineUpdateAAD(byte[] aad, int off, int len) {
        if (this.updateCalled) {
            throw new IllegalStateException("AAD must be supplied before encryption/decryption starts");
        }
        this.checkIfInited();
        this.ctx.updateAad(aad, off, len);
        if (this.encrypt && len > 0) {
            this.ivGenerated = true;
        }
    }

    @Override
    protected void engineUpdateAAD(ByteBuffer byteBuffer) {
        byte[] bout = new byte[byteBuffer.remaining()];
        byteBuffer.get(bout);
        this.engineUpdateAAD(bout, 0, bout.length);
    }

    @Override
    protected int engineUpdate(byte[] input, int inOffset, int inLen, byte[] out, int outOffset) throws ShortBufferException {
        this.checkIfInited();
        this.updateCalled = true;
        int updateOutputSize = this.getUpdateOutputSize(inLen);
        if (updateOutputSize > out.length - outOffset) {
            throw new ShortBufferException("Not enough space in output array");
        }
        if (this.encrypt || ToolkitProperties.getJipherCipherAeadStreamValue()) {
            int count = this.updateInternal(input, inOffset, inLen, out, outOffset, updateOutputSize, this.fillOffset > 0);
            if (this.encrypt && inLen > 0) {
                this.ivGenerated = true;
            }
            return count;
        }
        this.appendToCiphertextBuf(input, inOffset, inLen);
        return 0;
    }

    void appendToCiphertextBuf(byte[] input, int inOffset, int inLen) {
        if (inLen > 0) {
            try {
                this.ctBufferLen = Math.addExact(this.ctBufferLen, inLen);
            }
            catch (ArithmeticException ex) {
                throw new ProviderException("JipherJCE provider only supports buffering of AES/GCM ciphertext up to 2147483647 bytes in size", ex);
            }
            if (inLen <= 1024) {
                if (this.ctConsolidationBuf == null) {
                    this.ctConsolidationBuf = ByteBuffer.allocate(4096);
                } else if (inLen > this.ctConsolidationBuf.remaining()) {
                    this.flushCiphertextConsolidationBuf();
                }
                this.ctConsolidationBuf.put(input, inOffset, inLen);
            } else {
                this.flushCiphertextConsolidationBuf();
                this.ctBufList.add(Arrays.copyOfRange(input, inOffset, inOffset + inLen));
            }
        }
    }

    void flushCiphertextConsolidationBuf() {
        if (this.ctConsolidationBuf != null && this.ctConsolidationBuf.position() > 0) {
            byte[] buf = new byte[this.ctConsolidationBuf.position()];
            this.ctConsolidationBuf.rewind();
            this.ctConsolidationBuf.get(buf);
            this.ctConsolidationBuf.rewind();
            this.ctBufList.add(buf);
        }
    }

    void clearCiphertextBuf() {
        this.ctBufList.clear();
        this.ctConsolidationBuf = null;
        this.ctBufferLen = 0;
    }

    @Override
    int updateInternal(byte[] input, int inOffset, int inLen, byte[] out, int outOffset) {
        int outLen;
        if (this.encrypt) {
            outLen = super.updateInternal(input, inOffset, inLen, out, outOffset);
        } else if (inLen <= this.tag.length - this.fillOffset) {
            outLen = 0;
            System.arraycopy(input, inOffset, this.tag, this.fillOffset, inLen);
            this.fillOffset += inLen;
        } else if (inLen >= this.tag.length) {
            outLen = super.updateInternal(this.tag, 0, this.fillOffset, out, outOffset);
            outLen += super.updateInternal(input, inOffset, inLen - this.tag.length, out, outOffset + outLen);
            System.arraycopy(input, inOffset + inLen - this.tag.length, this.tag, 0, this.tag.length);
            this.fillOffset = this.tag.length;
        } else {
            int bytesToUpdate = this.fillOffset + inLen - this.tag.length;
            outLen = super.updateInternal(this.tag, 0, bytesToUpdate, out, outOffset);
            this.fillOffset -= bytesToUpdate;
            System.arraycopy(this.tag, bytesToUpdate, this.tag, 0, this.fillOffset);
            System.arraycopy(input, inOffset, this.tag, this.fillOffset, inLen);
            this.fillOffset += inLen;
        }
        return outLen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int engineDoFinal(byte[] input, int inOffset, int inLen, byte[] out, int outOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        this.checkIfInited();
        int outputSize = this.engineGetOutputSize(inLen);
        if (outputSize > out.length - outOffset) {
            throw new ShortBufferException("Not enough space in output array");
        }
        try {
            int outLen = 0;
            if (this.encrypt) {
                if (inLen > 0) {
                    outLen = this.updateInternal(input, inOffset, inLen, out, outOffset, inLen, false);
                }
                this.ivGenerated = true;
                if ((outLen += this.ctx.doFinal(out, outOffset)) + this.tag.length > out.length - outOffset) {
                    throw new ProviderException("Internal error: Not enough space in output buffer.");
                }
                this.ctx.getAuthTag(out, outOffset + outLen, this.tag.length);
                outLen += this.tag.length;
                this.ensureParamSpec();
            } else {
                if (ToolkitProperties.getJipherCipherAeadStreamValue()) {
                    if (inLen + this.fillOffset < this.tag.length) {
                        throw new AEADBadTagException("Insufficient input data.");
                    }
                    if (inLen > 0) {
                        int updateOutputSize = this.getUpdateOutputSize(inLen);
                        outLen = this.updateInternal(input, inOffset, inLen, out, outOffset, updateOutputSize, this.fillOffset > 0);
                    }
                    this.ctx.setAuthTag(this.tag, 0, this.tag.length);
                    try {
                        outLen += this.ctx.doFinal(out, outOffset + outLen);
                    }
                    catch (BadPaddingException | IllegalBlockSizeException e) {
                        throw new SecurityException("Authentication tag does not match.");
                    }
                }
                if (Math.addExact(this.ctBufferLen, inLen) < this.tag.length) {
                    throw new AEADBadTagException("Insufficient input data.");
                }
                if (inLen > 0 && AeadCipher.isOverlapping(input, inOffset, inLen, out, outOffset, outputSize)) {
                    this.appendToCiphertextBuf(input, inOffset, inLen);
                    inLen = 0;
                }
                if (inLen >= this.tag.length) {
                    System.arraycopy(input, inOffset + inLen - this.tag.length, this.tag, 0, this.tag.length);
                    inLen -= this.tag.length;
                } else {
                    int n;
                    byte[] buf;
                    if (inLen > 0) {
                        System.arraycopy(input, inOffset, this.tag, this.tag.length - inLen, inLen);
                    }
                    int remaining = this.tag.length - inLen;
                    inLen = 0;
                    this.flushCiphertextConsolidationBuf();
                    int i = this.ctBufList.size();
                    do {
                        buf = this.ctBufList.remove(--i);
                        n = Math.min(buf.length, remaining);
                        this.ctBufferLen -= n;
                        System.arraycopy(buf, buf.length - n, this.tag, remaining -= n, n);
                    } while (remaining != 0);
                    if (n < buf.length) {
                        this.appendToCiphertextBuf(buf, 0, buf.length - n);
                    }
                }
                boolean clearOutputBuffer = true;
                try {
                    this.flushCiphertextConsolidationBuf();
                    for (byte[] buf : this.ctBufList) {
                        outLen += this.ctx.update(buf, 0, buf.length, out, outOffset + outLen);
                    }
                    if (inLen > 0) {
                        outLen += this.ctx.update(input, inOffset, inLen, out, outOffset + outLen);
                    }
                    this.ctx.setAuthTag(this.tag, 0, this.tag.length);
                    try {
                        outLen += this.ctx.doFinal(out, outOffset + outLen);
                    }
                    catch (BadPaddingException | IllegalBlockSizeException e) {
                        throw new AEADBadTagException("Authentication tag does not match.");
                    }
                    clearOutputBuffer = false;
                }
                finally {
                    if (clearOutputBuffer) {
                        Arrays.fill(out, outOffset, outOffset + outputSize, (byte)0);
                    }
                }
            }
            int n = outLen;
            return n;
        }
        finally {
            this.cleanup();
        }
    }

    @Override
    void cleanup() {
        super.cleanup();
        this.updateCalled = false;
        this.ivGenerated = false;
        Util.clearArray(this.tag);
        this.fillOffset = 0;
        this.clearCiphertextBuf();
    }

    static abstract class Gcm
    extends AeadCipher {
        private static final int DEFAULT_TAG_LEN_BYTES = 16;

        Gcm(CipherAlg alg) throws NoSuchAlgorithmException, NoSuchPaddingException {
            super(alg);
            this.engineSetMode("GCM");
            this.engineSetPadding("NoPadding");
        }

        @Override
        void ensureParamSpec() {
            if (this.ctx != null && this.encrypt && this.paramSpec == null) {
                try {
                    boolean generateIv;
                    boolean bl = generateIv = !this.ivGenerated;
                    if (generateIv) {
                        this.ctx.doFinal(new byte[16], 0);
                    }
                    byte[] iv = this.ctx.getIv();
                    if (generateIv) {
                        this.ctx.reInit(iv);
                    }
                    this.paramSpec = new GCMParameterSpec(this.tag.length * 8, iv);
                }
                catch (IllegalStateException | BadPaddingException | IllegalBlockSizeException exception) {
                    // empty catch block
                }
            }
        }

        @Override
        int getUpdateOutputSize(int inputLen) {
            if (this.encrypt) {
                return inputLen;
            }
            if (ToolkitProperties.getJipherCipherAeadStreamValue()) {
                return Math.max(0, Math.addExact(this.fillOffset, inputLen) - this.tag.length);
            }
            return 0;
        }

        @Override
        protected int engineGetOutputSize(int inputLen) {
            if (this.encrypt) {
                return Math.addExact(inputLen, this.tag.length);
            }
            int buffered = ToolkitProperties.getJipherCipherAeadStreamValue() ? this.fillOffset : this.ctBufferLen;
            return Math.max(0, Math.addExact(buffered, inputLen) - this.tag.length);
        }

        @Override
        String getAlgorithmParametersAlg() {
            return "GCM";
        }

        @Override
        AlgorithmParameterSpec getParamSpec(byte[] iv, AlgorithmParameterSpec spec) {
            if (spec != null || iv == null) {
                return spec;
            }
            return new GCMParameterSpec(this.tag.length * 8, iv);
        }

        @Override
        byte[] verifyParams(AlgorithmParameterSpec params, boolean encrypt) throws InvalidAlgorithmParameterException {
            if (params instanceof GCMParameterSpec) {
                GCMParameterSpec gcmSpec = (GCMParameterSpec)params;
                byte[] iv = gcmSpec.getIV();
                if (iv.length == 0) {
                    throw new InvalidAlgorithmParameterException("Invalid GCM IV.");
                }
                int tLen = gcmSpec.getTLen();
                if (tLen < 96 || tLen > 128 || tLen % 8 != 0) {
                    throw new InvalidAlgorithmParameterException("GCM tag length must be {128, 120, 112, 104, 96}");
                }
                this.tag = new byte[tLen / 8];
                return iv;
            }
            if (params == null) {
                if (encrypt) {
                    this.tag = new byte[16];
                    return null;
                }
                throw new InvalidAlgorithmParameterException("GCM Parameters required for decryption");
            }
            throw new InvalidAlgorithmParameterException("Invalid GCM Parameters");
        }

        @Override
        Class<? extends AlgorithmParameterSpec> getParameterSpecClass() {
            return GCMParameterSpec.class;
        }
    }

    public static final class Aes256Gcm
    extends Gcm {
        public Aes256Gcm() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super(new CipherAlg.AesGcm(32));
        }
    }

    public static final class Aes192Gcm
    extends Gcm {
        public Aes192Gcm() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super(new CipherAlg.AesGcm(24));
        }
    }

    public static final class Aes128Gcm
    extends Gcm {
        public Aes128Gcm() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super(new CipherAlg.AesGcm(16));
        }
    }

    public static final class AesGcm
    extends Gcm {
        public AesGcm() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super(new CipherAlg.AesGcm());
        }
    }
}

