/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.key;

import com.oracle.jipher.internal.common.Util;
import com.oracle.jipher.internal.openssl.Pkey;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyRep;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;

public abstract class JceOsslKey
implements Key {
    private final String alg;
    final Pkey pkey;
    final byte[] encoding;

    JceOsslKey(String alg, Pkey pkey) {
        this(alg, pkey, null);
    }

    JceOsslKey(String alg, Pkey pkey, byte[] encoding) {
        this.alg = alg;
        this.pkey = pkey;
        this.encoding = encoding;
    }

    abstract byte[] derEncode() throws InvalidKeyException;

    @Override
    public byte[] getEncoded() {
        if (this.encoding != null) {
            return (byte[])this.encoding.clone();
        }
        try {
            return this.derEncode();
        }
        catch (InvalidKeyException e) {
            throw new ProviderException(e);
        }
    }

    @Override
    public String getFormat() {
        return this instanceof PublicKey ? "X.509" : "PKCS#8";
    }

    @Override
    public String getAlgorithm() {
        return this.alg;
    }

    public Pkey getPkey() {
        return this.pkey;
    }

    public int hashCode() {
        byte[] der = this.getEncoded();
        try {
            int n = Util.hashCode(der);
            return n;
        }
        finally {
            Util.clearArray(der);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Key)) {
            return false;
        }
        byte[] der = this.getEncoded();
        byte[] otherDer = null;
        try {
            otherDer = ((Key)obj).getEncoded();
            boolean bl = Util.equalsTC(der, otherDer);
            return bl;
        }
        finally {
            Util.clearArray(der);
            Util.clearArray(otherDer);
        }
    }

    protected Object writeReplace() {
        return new KeyRep(this instanceof PrivateKey ? KeyRep.Type.PRIVATE : KeyRep.Type.PUBLIC, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }
}

