/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.common;

import com.oracle.jipher.internal.tools.asn1.Asn1BerValue;
import com.oracle.jipher.internal.tools.asn1.Asn1DecodeException;
import com.oracle.jipher.internal.tools.asn1.TagClass;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;

public final class Util {
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    private Util() {
    }

    public static int hashCode(byte[] bytes) {
        if (bytes == null) {
            return 0;
        }
        int ret = bytes.length;
        for (byte b : bytes) {
            ret = 17 * ret + b;
        }
        return ret;
    }

    public static boolean equalsTC(byte[] b1, byte[] b2) {
        return MessageDigest.isEqual(b1, b2);
    }

    public static boolean equalsTC(char[] c1, char[] c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        if (c1.length != c2.length) {
            return false;
        }
        int result = 0;
        for (int i = 0; i < c1.length; ++i) {
            result |= c1[i] ^ c2[i];
        }
        return result == 0;
    }

    public static byte[] hexToBytes(String hex) {
        int len = hex.length();
        if (len % 2 != 0) {
            throw new IllegalArgumentException("Hex string should contain even number of characters");
        }
        byte[] bytes = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            bytes[i / 2] = (byte)((Character.digit(hex.charAt(i), 16) << 4) + Character.digit(hex.charAt(i + 1), 16));
        }
        return bytes;
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public static void clearArrays(byte[][] arrays) {
        if (arrays != null) {
            for (byte[] array : arrays) {
                Util.clearArray(array);
            }
        }
    }

    public static void clearArray(byte[] array) {
        if (array != null) {
            Arrays.fill(array, (byte)0);
        }
    }

    public static void clearArray(char[] array) {
        if (array != null) {
            Arrays.fill(array, '\u0000');
        }
    }

    public static void clearArray(long[] array) {
        if (array != null) {
            Arrays.fill(array, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] encodeString(Charset charset, char[] chars, boolean nulTerm) {
        CharsetEncoder encoder = charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        ByteBuffer bb = ByteBuffer.allocate((int)(encoder.maxBytesPerChar() * (float)(chars.length + 1)) + 1);
        try {
            boolean nul = nulTerm && (chars.length == 0 || chars[chars.length - 1] != '\u0000');
            CoderResult cr = encoder.encode(CharBuffer.wrap(chars), bb, !nul);
            if (cr.isUnderflow() && nul) {
                cr = encoder.encode(CharBuffer.wrap(new char[1]), bb, true);
            }
            if (cr.isUnderflow()) {
                cr = encoder.flush(bb);
            }
            if (!cr.isUnderflow()) {
                throw new InvalidParameterException("Unable to encode string: " + cr.toString());
            }
            bb.flip();
            byte[] res = new byte[bb.remaining()];
            bb.get(res);
            byte[] byArray = res;
            return byArray;
        }
        finally {
            encoder.reset();
            Util.clearArray(bb.array());
        }
    }

    public static byte[] utf8Encode(char[] chars) {
        return Util.encodeString(StandardCharsets.UTF_8, chars, false);
    }

    public static byte[] utf16BeEncode(char[] chars) {
        return Util.encodeString(StandardCharsets.UTF_16BE, chars, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static char[] decodeString(Charset charset, byte[] bytes, boolean nulStrip) {
        CharsetDecoder decoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        CharBuffer cb = CharBuffer.allocate((int)(decoder.maxCharsPerByte() * (float)bytes.length) + 1);
        try {
            CoderResult cr = decoder.decode(ByteBuffer.wrap(bytes), cb, true);
            if (cr.isUnderflow()) {
                cr = decoder.flush(cb);
            }
            if (!cr.isUnderflow()) {
                throw new InvalidParameterException("Unable to decode string: " + cr.toString());
            }
            cb.flip();
            if (nulStrip && cb.hasRemaining() && cb.get(cb.limit() - 1) == '\u0000') {
                cb.limit(cb.limit() - 1);
            }
            char[] res = new char[cb.remaining()];
            cb.get(res);
            char[] cArray = res;
            return cArray;
        }
        finally {
            decoder.reset();
            Util.clearArray(cb.array());
        }
    }

    public static char[] utf8Decode(byte[] bytes) {
        return Util.decodeString(StandardCharsets.UTF_8, bytes, false);
    }

    public static char[] utf16BeDecode(byte[] bytes) {
        return Util.decodeString(StandardCharsets.UTF_16BE, bytes, true);
    }

    public static boolean isPrintableAscii(char[] chars) {
        for (char c : chars) {
            if (c >= ' ' && c <= '~') continue;
            return false;
        }
        return true;
    }

    public static byte[] asciiEncode(char[] chars) {
        byte[] bytes = new byte[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            bytes[i] = (byte)(chars[i] & 0x7F);
        }
        return bytes;
    }

    public static char[] asciiDecode(byte[] bytes) {
        char[] chars = new char[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            chars[i] = (char)(bytes[i] & 0x7F);
        }
        return chars;
    }

    public static void assertContextSpecific(Asn1BerValue value) {
        if (value.tagClass != TagClass.CONTEXT_SPECIFIC) {
            throw new Asn1DecodeException("Non-context-specific tag; at offset " + value.offset);
        }
    }

    public static void assertUniversal(Asn1BerValue value) {
        if (value.tagClass != TagClass.UNIVERSAL) {
            throw new Asn1DecodeException("Non-universal tag; at offset " + value.offset);
        }
    }

    public static void assertAllUniversal(Asn1BerValue value) {
        Util.assertUniversal(value);
        if (value.constructed) {
            for (Asn1BerValue subValue : value.values()) {
                Util.assertAllUniversal(subValue);
            }
        }
    }

    public static void destroyKey(Key key) {
        if (key instanceof Destroyable) {
            try {
                ((Destroyable)((Object)key)).destroy();
            }
            catch (DestroyFailedException destroyFailedException) {
                // empty catch block
            }
        }
    }
}

