/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.common;

import java.security.AccessController;
import java.security.PrivilegedAction;

public class ToolkitProperties {
    private static final String JIPHER_USER_DIR_PROPERTY = "jipher.user.dir";
    private static final String JIPHER_INSTALL_DIR_PROPERTY = "jipher.install.dir";
    private static final String JIPHER_FIPS_DIR_PROPERTY = "jipher.fips.dir";
    private static final String JIPHER_TEMP_LIBRARY_CLEANER_ENABLE_PROPERTY = "jipher.tempLibraryCleaner.enable";
    private static final String JIPHER_FIPS_ENFORCEMENT_PROPERTY = "jipher.fips.enforcement";
    private static final String JIPHER_FIPS_ENFORCEMENT_OVERRIDE_ALLOW_RSA_PKCS1_PROTECT_PROPERTY = "jipher.fips.enforcement.override.allowRsaPkcs1Protect";
    private static final String JIPHER_FIPS_DEACTIVATE_SECURITY_PATCHES_PROPERTY = "jipher.fips.deactivateSecurityPatches";
    private static final String JIPHER_CIPHER_AEAD_STREAM_PROPERTY = "jipher.cipher.AEAD.stream";
    private static final String JIPHER_TMP_DIR_PROPERTY_DEFAULT = "java.io.tmpdir";
    private static final String KEY_LENGTH_PROP = "jdk.security.defaultKeySize";
    private static final String JIPHER_USER_DIR_VALUE = ToolkitProperties.systemProperty("jipher.user.dir", ToolkitProperties.systemProperty("java.io.tmpdir"));
    private static final String JIPHER_INSTALL_DIR_VALUE = ToolkitProperties.systemProperty("jipher.install.dir");
    private static final String JIPHER_FIPS_DIR_VALUE = ToolkitProperties.systemProperty("jipher.fips.dir");
    private static final String JIPHER_TEMP_LIBRARY_CLEANER_ENABLE_DEFAULT_VALUE = ToolkitProperties.systemProperty("os.name").toLowerCase().contains("windows") ? "true" : "false";
    private static final boolean JIPHER_TEMP_LIBRARY_CLEANER_ENABLE_VALUE = ToolkitProperties.systemProperty("jipher.tempLibraryCleaner.enable", JIPHER_TEMP_LIBRARY_CLEANER_ENABLE_DEFAULT_VALUE).equalsIgnoreCase("true");
    private static final String JIPHER_FIPS_ENFORCEMENT_VALUE = ToolkitProperties.systemProperty("jipher.fips.enforcement", "FIPS");
    private static final boolean JIPHER_FIPS_ENFORCEMENT_OVERRIDE_ALLOW_RSA_PKCS1_PROTECT_VALUE = Boolean.getBoolean("jipher.fips.enforcement.override.allowRsaPkcs1Protect");
    private static final boolean JIPHER_FIPS_DEACTIVATE_SECURITY_PATCHES_VALUE = Boolean.getBoolean("jipher.fips.deactivateSecurityPatches");
    private static final boolean JIPHER_CIPHER_AEAD_STREAM_VALUE = Boolean.getBoolean("jipher.cipher.AEAD.stream");
    private static final String USER_NAME = ToolkitProperties.systemProperty("user.name");
    private static final String JAVA_LIBRARY_PATH = ToolkitProperties.systemProperty("java.library.path");

    private ToolkitProperties() {
    }

    private static String systemProperty(final String property) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(property);
            }
        });
    }

    private static String systemProperty(String property, String defaultVal) {
        String val = ToolkitProperties.systemProperty(property);
        if (val == null) {
            return defaultVal;
        }
        return val;
    }

    public static String getUserName() {
        return USER_NAME;
    }

    public static String getJipherUserDir() {
        return JIPHER_USER_DIR_VALUE;
    }

    public static String getJipherInstallDir() {
        return JIPHER_INSTALL_DIR_VALUE;
    }

    public static String getFipsModuleDir() {
        return JIPHER_FIPS_DIR_VALUE;
    }

    public static boolean isTempLibraryCleanerEnabled() {
        return JIPHER_TEMP_LIBRARY_CLEANER_ENABLE_VALUE;
    }

    public static String getJavaLibraryPath() {
        return JAVA_LIBRARY_PATH;
    }

    public static String getJavaKeyLengths() {
        return ToolkitProperties.systemProperty(KEY_LENGTH_PROP);
    }

    public static String getFipsEnforcementValue() {
        return JIPHER_FIPS_ENFORCEMENT_VALUE;
    }

    public static boolean getFipsEnforcementOverrideAllowRsaPkcs1ProtectValue() {
        return JIPHER_FIPS_ENFORCEMENT_OVERRIDE_ALLOW_RSA_PKCS1_PROTECT_VALUE;
    }

    public static boolean getFipsDeactivateSecurityPatchesValue() {
        return JIPHER_FIPS_DEACTIVATE_SECURITY_PATCHES_VALUE;
    }

    public static boolean getJipherCipherAeadStreamValue() {
        return JIPHER_CIPHER_AEAD_STREAM_VALUE;
    }
}

