/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.agent;

import com.oracle.svm.agent.NativeImageAgent;
import com.oracle.svm.agent.NativeImageAgentJNIHandleSet;
import com.oracle.svm.agent.stackaccess.EagerlyLoadedJavaStackAccess;
import com.oracle.svm.agent.stackaccess.InterceptedState;
import com.oracle.svm.agent.tracing.core.Tracer;
import com.oracle.svm.configure.trace.AccessAdvisor;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.jni.JNIObjectHandles;
import com.oracle.svm.core.jni.headers.JNIEnvironment;
import com.oracle.svm.core.jni.headers.JNIFieldId;
import com.oracle.svm.core.jni.headers.JNIMethodId;
import com.oracle.svm.core.jni.headers.JNIMode;
import com.oracle.svm.core.jni.headers.JNINativeMethod;
import com.oracle.svm.core.jni.headers.JNIObjectHandle;
import com.oracle.svm.core.jni.headers.JNIValue;
import com.oracle.svm.core.reflect.proxy.DynamicProxySupport;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.jvmtiagentbase.AgentIsolate;
import com.oracle.svm.jvmtiagentbase.ConstantPoolTool;
import com.oracle.svm.jvmtiagentbase.Support;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiCapabilities;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiEnv;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiError;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiEvent;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiEventCallbacks;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiEventMode;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiFrameInfo;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiLocationFormat;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.java.LambdaUtils;
import jdk.graal.compiler.util.Digest;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.c.function.InvokeCFunctionPointer;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CCharPointerPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

final class BreakpointInterceptor {
    private static Tracer tracer;
    private static NativeImageAgent agent;
    private static Supplier<InterceptedState> interceptedStateSupplier;
    private static Map<Long, Breakpoint> installedBreakpoints;
    private static Map<Long, Long> boundNativeMethods;
    private static Map<Long, NativeBreakpoint> nativeBreakpoints;
    private static boolean experimentalClassLoaderSupport;
    private static boolean experimentalClassDefineSupport;
    private static boolean experimentalUnsafeAllocationSupport;
    private static boolean trackReflectionMetadata;
    private static ConcurrentMap<MethodLocation, Boolean> observedExplicitLoadClassCallSites;
    private static final ReentrantLock nativeBreakpointsInitLock;
    private static final ThreadLocal<Boolean> recursive;
    private static JNIObjectHandle[] builtinClassLoaders;
    private static final CEntryPointLiteral<AllocateInstanceFunctionPointer> nativeAllocateInstance;
    private static final NativeBreakpointSpecification NATIVE_ALLOCATE_INSTANCE_BREAKPOINT_SPEC;
    private static final CEntryPointLiteral<CFunctionPointer> onBreakpointLiteral;
    private static final CEntryPointLiteral<CFunctionPointer> onNativeMethodBindLiteral;
    private static final CEntryPointLiteral<CFunctionPointer> onClassPrepareLiteral;
    private static final CEntryPointLiteral<CFunctionPointer> onClassFileLoadHookLiteral;
    private static final BreakpointSpecification[] BREAKPOINT_SPECIFICATIONS;
    private static final BreakpointSpecification CLASSLOADER_LOAD_CLASS_BREAKPOINT_SPECIFICATION;
    private static final NativeBreakpointSpecification[] NATIVE_BREAKPOINT_SPECIFICATIONS;
    private static final BreakpointSpecification[] REFLECTION_ACCESS_BREAKPOINT_SPECIFICATIONS;
    private static final BreakpointSpecification[] CLASS_PREDEFINITION_BREAKPOINT_SPECIFICATIONS;

    private static void traceReflectBreakpoint(JNIEnvironment env, JNIObjectHandle clazz, JNIObjectHandle declaringClass, JNIObjectHandle callerClass, String function, Object result, JNIMethodId[] stackTrace, Object ... args) {
        BreakpointInterceptor.traceBreakpoint(env, "reflect", clazz, declaringClass, callerClass, function, result, stackTrace, args);
    }

    private static void traceSerializeBreakpoint(JNIEnvironment env, String function, Object result, JNIMethodId[] stackTrace, Object ... args) {
        BreakpointInterceptor.traceBreakpoint(env, "serialization", (JNIObjectHandle)JNIObjectHandles.nullHandle(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), function, result, stackTrace, args);
    }

    private static void traceBreakpoint(JNIEnvironment env, String context, JNIObjectHandle clazz, JNIObjectHandle declaringClass, JNIObjectHandle callerClass, String function, Object result, JNIMethodId[] stackTrace, Object[] args) {
        if (tracer != null) {
            tracer.traceCall(context, function, BreakpointInterceptor.getClassOrProxyInterfaceNames(env, clazz), BreakpointInterceptor.getClassOrProxyInterfaceNames(env, declaringClass), Support.getClassNameOr((JNIEnvironment)env, (JNIObjectHandle)callerClass, null, (String)Tracer.UNKNOWN_VALUE), result, stackTrace, args);
            JNIObjectHandle exception = Support.handleException((JNIEnvironment)env, (boolean)false);
            if (exception.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
                VMError.guarantee((boolean)Support.jniFunctions().getIsInstanceOf().invoke(env, exception, ((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangStackOverflowError));
                return;
            }
            Support.clearException((JNIEnvironment)env);
        }
    }

    private static Object getClassOrProxyInterfaceNames(JNIEnvironment env, JNIObjectHandle clazz) {
        if (clazz.equal((ComparableWord)JNIObjectHandles.nullHandle())) {
            return null;
        }
        boolean isProxy = Support.callStaticBooleanMethodL((JNIEnvironment)env, (JNIObjectHandle)((NativeImageAgentJNIHandleSet)agent.handles()).getJavaLangReflectProxy(env), (JNIMethodId)((NativeImageAgentJNIHandleSet)agent.handles()).getJavaLangReflectProxyIsProxyClass(env), (JNIObjectHandle)clazz);
        if (Support.clearException((JNIEnvironment)env)) {
            return Tracer.UNKNOWN_VALUE;
        }
        if (!isProxy) {
            return Support.getClassNameOr((JNIEnvironment)env, (JNIObjectHandle)clazz, null, (String)Tracer.UNKNOWN_VALUE);
        }
        JNIObjectHandle interfaces = Support.callObjectMethod((JNIEnvironment)env, (JNIObjectHandle)clazz, (JNIMethodId)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangClassGetInterfaces);
        if (Support.clearException((JNIEnvironment)env)) {
            return Tracer.UNKNOWN_VALUE;
        }
        return BreakpointInterceptor.getClassArrayNames(env, interfaces);
    }

    private static boolean forName(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        JNIObjectHandle callerClass = state.getDirectCallerClass();
        JNIObjectHandle name = Support.getObjectArgument((JNIObjectHandle)thread, (int)0);
        String className = Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)name);
        if (className == null) {
            return true;
        }
        BreakpointInterceptor.traceReflectBreakpoint(jni, bp.clazz, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, null, state.getFullStackTraceOrNull(), className);
        return true;
    }

    private static boolean getFields(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        return BreakpointInterceptor.handleGetFields(jni, thread, bp, state);
    }

    private static boolean getDeclaredFields(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        return BreakpointInterceptor.handleGetFields(jni, thread, bp, state);
    }

    private static boolean handleGetFields(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        JNIObjectHandle callerClass = state.getDirectCallerClass();
        JNIObjectHandle self = Support.getReceiver((JNIObjectHandle)thread);
        BreakpointInterceptor.traceReflectBreakpoint(jni, self, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, null, state.getFullStackTraceOrNull(), new Object[0]);
        return true;
    }

    private static boolean getMethods(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        return BreakpointInterceptor.handleGetMethods(jni, thread, bp, state);
    }

    private static boolean getDeclaredMethods(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        return BreakpointInterceptor.handleGetMethods(jni, thread, bp, state);
    }

    private static boolean getConstructors(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        return BreakpointInterceptor.handleGetMethods(jni, thread, bp, state);
    }

    private static boolean getDeclaredConstructors(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        return BreakpointInterceptor.handleGetMethods(jni, thread, bp, state);
    }

    private static boolean handleGetMethods(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        JNIObjectHandle callerClass = state.getDirectCallerClass();
        JNIObjectHandle self = Support.getReceiver((JNIObjectHandle)thread);
        BreakpointInterceptor.traceReflectBreakpoint(jni, self, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, trackReflectionMetadata ? null : Boolean.valueOf(true), state.getFullStackTraceOrNull(), new Object[0]);
        return true;
    }

    private static boolean getClasses(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        return BreakpointInterceptor.handleGetClasses(jni, thread, bp, state);
    }

    private static boolean getDeclaredClasses(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        return BreakpointInterceptor.handleGetClasses(jni, thread, bp, state);
    }

    private static boolean getRecordComponents(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        return BreakpointInterceptor.handleGetClasses(jni, thread, bp, state);
    }

    private static boolean getPermittedSubclasses(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        return BreakpointInterceptor.handleGetClasses(jni, thread, bp, state);
    }

    private static boolean getNestMembers(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        return BreakpointInterceptor.handleGetClasses(jni, thread, bp, state);
    }

    private static boolean getSigners(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        return BreakpointInterceptor.handleGetClasses(jni, thread, bp, state);
    }

    private static boolean handleGetClasses(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        JNIObjectHandle callerClass = state.getDirectCallerClass();
        JNIObjectHandle self = Support.getReceiver((JNIObjectHandle)thread);
        BreakpointInterceptor.traceReflectBreakpoint(jni, self, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, null, state.getFullStackTraceOrNull(), new Object[0]);
        return true;
    }

    private static boolean getField(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        return BreakpointInterceptor.handleGetField(jni, thread, bp, false, state);
    }

    private static boolean getDeclaredField(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        return BreakpointInterceptor.handleGetField(jni, thread, bp, true, state);
    }

    private static boolean handleGetField(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, boolean declaredOnly, InterceptedState state) {
        JNIObjectHandle callerClass = state.getDirectCallerClass();
        JNIObjectHandle self = Support.getReceiver((JNIObjectHandle)thread);
        JNIObjectHandle name = Support.getObjectArgument((JNIObjectHandle)thread, (int)1);
        JNIObjectHandle result = Support.callObjectMethodL((JNIEnvironment)jni, (JNIObjectHandle)self, (JNIMethodId)bp.method, (JNIObjectHandle)name);
        if (Support.clearException((JNIEnvironment)jni)) {
            result = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        JNIObjectHandle declaring = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        if (!declaredOnly && result.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
            declaring = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)result, (JNIMethodId)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangReflectMemberGetDeclaringClass);
            if (Support.clearException((JNIEnvironment)jni)) {
                declaring = (JNIObjectHandle)JNIObjectHandles.nullHandle();
            }
        }
        BreakpointInterceptor.traceReflectBreakpoint(jni, self, declaring, callerClass, ((BreakpointSpecification)bp.specification).methodName, name.notEqual((ComparableWord)JNIObjectHandles.nullHandle()), state.getFullStackTraceOrNull(), Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)name));
        return true;
    }

    @CEntryPoint
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class)
    static long nativeAllocateInstance(JNIEnvironment jni, JNIObjectHandle self, JNIObjectHandle clazz) {
        VMError.guarantee((BreakpointInterceptor.NATIVE_ALLOCATE_INSTANCE_BREAKPOINT_SPEC.installed != null && BreakpointInterceptor.NATIVE_ALLOCATE_INSTANCE_BREAKPOINT_SPEC.installed.replacedFunction.isNonNull() ? 1 : 0) != 0, (String)"incompletely installed");
        AllocateInstanceFunctionPointer original = (AllocateInstanceFunctionPointer)BreakpointInterceptor.NATIVE_ALLOCATE_INSTANCE_BREAKPOINT_SPEC.installed.replacedFunction;
        long result = original.invoke(jni, self, clazz);
        if (!Support.isInitialized()) {
            return result;
        }
        boolean validResult = !Support.clearException((JNIEnvironment)jni);
        InterceptedState state = interceptedStateSupplier.get();
        JNIObjectHandle callerClass = state.getDirectCallerClass();
        BreakpointInterceptor.traceAllocateInstance(jni, clazz, validResult, state, callerClass);
        if (!validResult) {
            return original.invoke(jni, self, clazz);
        }
        return result;
    }

    private static void traceAllocateInstance(JNIEnvironment jni, JNIObjectHandle clazz, boolean validResult, InterceptedState state, JNIObjectHandle callerClass) {
        if (clazz.notEqual((ComparableWord)JNIObjectHandles.nullHandle()) && validResult) {
            BreakpointInterceptor.traceReflectBreakpoint(jni, clazz, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, "allocateInstance", true, state.getFullStackTraceOrNull(), new Object[0]);
        }
    }

    private static boolean objectFieldOffsetByName(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        JNIObjectHandle callerClass = state.getDirectCallerClass();
        JNIObjectHandle self = Support.getReceiver((JNIObjectHandle)thread);
        JNIObjectHandle declaring = Support.getObjectArgument((JNIObjectHandle)thread, (int)1);
        JNIObjectHandle name = Support.getObjectArgument((JNIObjectHandle)thread, (int)2);
        Support.callLongMethodLL((JNIEnvironment)jni, (JNIObjectHandle)self, (JNIMethodId)bp.method, (JNIObjectHandle)declaring, (JNIObjectHandle)name);
        boolean validResult = !Support.clearException((JNIEnvironment)jni);
        JNIObjectHandle clazz = Support.getMethodDeclaringClass((JNIMethodId)bp.method);
        BreakpointInterceptor.traceReflectBreakpoint(jni, clazz, declaring, callerClass, "objectFieldOffset", validResult, state.getFullStackTraceOrNull(), Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)name));
        return true;
    }

    private static boolean getConstructor(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        JNIObjectHandle callerClass = state.getDirectCallerClass();
        JNIObjectHandle self = Support.getReceiver((JNIObjectHandle)thread);
        JNIObjectHandle paramTypesHandle = Support.getObjectArgument((JNIObjectHandle)thread, (int)1);
        Object paramTypes = BreakpointInterceptor.getClassArrayNames(jni, paramTypesHandle);
        BreakpointInterceptor.traceReflectBreakpoint(jni, self, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, true, state.getFullStackTraceOrNull(), paramTypes);
        return true;
    }

    private static boolean getMethod(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        return BreakpointInterceptor.handleGetMethod(jni, thread, bp, false, state);
    }

    private static boolean getDeclaredMethod(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        return BreakpointInterceptor.handleGetMethod(jni, thread, bp, true, state);
    }

    private static boolean handleGetMethod(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, boolean declaredOnly, InterceptedState state) {
        JNIObjectHandle callerClass = state.getDirectCallerClass();
        JNIObjectHandle self = Support.getReceiver((JNIObjectHandle)thread);
        JNIObjectHandle nameHandle = Support.getObjectArgument((JNIObjectHandle)thread, (int)1);
        JNIObjectHandle paramTypesHandle = Support.getObjectArgument((JNIObjectHandle)thread, (int)2);
        JNIObjectHandle result = Support.callObjectMethodLL((JNIEnvironment)jni, (JNIObjectHandle)self, (JNIMethodId)bp.method, (JNIObjectHandle)nameHandle, (JNIObjectHandle)paramTypesHandle);
        if (Support.clearException((JNIEnvironment)jni)) {
            result = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        JNIObjectHandle declaring = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        if (!declaredOnly && result.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
            declaring = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)result, (JNIMethodId)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangReflectMemberGetDeclaringClass);
            if (Support.clearException((JNIEnvironment)jni)) {
                declaring = (JNIObjectHandle)JNIObjectHandles.nullHandle();
            }
        }
        String name = Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)nameHandle);
        Object paramTypes = BreakpointInterceptor.getClassArrayNames(jni, paramTypesHandle);
        BreakpointInterceptor.traceReflectBreakpoint(jni, self, declaring, callerClass, ((BreakpointSpecification)bp.specification).methodName, nameHandle.notEqual((ComparableWord)JNIObjectHandles.nullHandle()), state.getFullStackTraceOrNull(), name, paramTypes);
        return true;
    }

    private static boolean getEnclosingMethod(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        JNIObjectHandle callerClass = state.getDirectCallerClass();
        JNIObjectHandle self = Support.getReceiver((JNIObjectHandle)thread);
        Object result = Tracer.EXPLICIT_NULL;
        JNIObjectHandle enclosing = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)self, (JNIMethodId)bp.method);
        if (!Support.clearException((JNIEnvironment)jni) && enclosing.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
            result = Tracer.UNKNOWN_VALUE;
            JNIMethodId enclosingID = Support.jniFunctions().getFromReflectedMethod().invoke(jni, enclosing);
            if (!Support.clearException((JNIEnvironment)jni) && enclosingID.isNonNull()) {
                String holderName;
                WordPointer holderPtr = (WordPointer)StackValue.get(WordPointer.class);
                if (Support.jvmtiFunctions().GetMethodDeclaringClass().invoke(Support.jvmtiEnv(), enclosingID, holderPtr) == JvmtiError.JVMTI_ERROR_NONE && (holderName = Support.getClassNameOrNull((JNIEnvironment)jni, (JNIObjectHandle)((JNIObjectHandle)holderPtr.read()))) != null) {
                    CCharPointerPointer namePtr = (CCharPointerPointer)StackValue.get(CCharPointerPointer.class);
                    CCharPointerPointer signaturePtr = (CCharPointerPointer)StackValue.get(CCharPointerPointer.class);
                    if (Support.jvmtiFunctions().GetMethodName().invoke(Support.jvmtiEnv(), enclosingID, namePtr, signaturePtr, (CCharPointerPointer)WordFactory.nullPointer()) == JvmtiError.JVMTI_ERROR_NONE) {
                        String name = Support.fromCString((CCharPointer)namePtr.read());
                        String signature = Support.fromCString((CCharPointer)signaturePtr.read());
                        result = holderName + "." + name + signature;
                        Support.jvmtiFunctions().Deallocate().invoke(Support.jvmtiEnv(), (PointerBase)namePtr.read());
                        Support.jvmtiFunctions().Deallocate().invoke(Support.jvmtiEnv(), (PointerBase)signaturePtr.read());
                    }
                }
            }
        }
        BreakpointInterceptor.traceReflectBreakpoint(jni, (JNIObjectHandle)JNIObjectHandles.nullHandle(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, enclosing.notEqual((ComparableWord)JNIObjectHandles.nullHandle()) ? result : Boolean.valueOf(false), state.getFullStackTraceOrNull(), new Object[0]);
        return true;
    }

    private static boolean invokeMethod(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        return BreakpointInterceptor.handleInvokeMethod(jni, thread, bp, state, true);
    }

    private static boolean unreflectMethod(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        return BreakpointInterceptor.handleInvokeMethod(jni, thread, bp, state, false);
    }

    private static boolean handleInvokeMethod(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state, boolean isInvoke) {
        JNIObjectHandle callerClass = state.getDirectCallerClass();
        JNIObjectHandle method = Support.getObjectArgument((JNIObjectHandle)thread, (int)(isInvoke ? 0 : 1));
        JNIObjectHandle declaring = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)method, (JNIMethodId)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangReflectMemberGetDeclaringClass);
        if (Support.clearException((JNIEnvironment)jni)) {
            declaring = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        JNIObjectHandle nameHandle = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)method, (JNIMethodId)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangReflectMemberGetName);
        if (Support.clearException((JNIEnvironment)jni)) {
            nameHandle = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        String name = Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)nameHandle);
        JNIObjectHandle paramTypesHandle = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)method, (JNIMethodId)((NativeImageAgentJNIHandleSet)agent.handles()).getJavaLangReflectExecutableGetParameterTypes(jni));
        if (Support.clearException((JNIEnvironment)jni)) {
            paramTypesHandle = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        Object paramTypes = BreakpointInterceptor.getClassArrayNames(jni, paramTypesHandle);
        BreakpointInterceptor.traceReflectBreakpoint(jni, declaring, declaring, callerClass, "invokeMethod", declaring.notEqual((ComparableWord)JNIObjectHandles.nullHandle()), state.getFullStackTraceOrNull(), name, paramTypes);
        if (isInvoke && BreakpointInterceptor.isClassNewInstance(jni, declaring, name)) {
            JNIObjectHandle clazz = Support.getObjectArgument((JNIObjectHandle)thread, (int)1);
            BreakpointInterceptor.traceReflectBreakpoint(jni, clazz, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, "newInstance", clazz.notEqual((ComparableWord)JNIObjectHandles.nullHandle()), state.getFullStackTraceOrNull(), new Object[0]);
        }
        return true;
    }

    private static boolean isClassNewInstance(JNIEnvironment jni, JNIObjectHandle declaring, String name) {
        if (!"newInstance".equals(name)) {
            return false;
        }
        JNIObjectHandle classNameHandle = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)declaring, (JNIMethodId)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangClassGetName);
        if (Support.clearException((JNIEnvironment)jni)) {
            classNameHandle = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        String className = Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)classNameHandle);
        return "java.lang.Class".equals(className);
    }

    private static boolean invokeConstructor(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        return BreakpointInterceptor.handleInvokeConstructor(jni, bp, state, Support.getReceiver((JNIObjectHandle)thread));
    }

    private static boolean unreflectConstructor(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        return BreakpointInterceptor.handleInvokeConstructor(jni, bp, state, Support.getObjectArgument((JNIObjectHandle)thread, (int)1));
    }

    private static boolean handleInvokeConstructor(JNIEnvironment jni, Breakpoint bp, InterceptedState state, JNIObjectHandle constructor) {
        JNIObjectHandle callerClass = state.getDirectCallerClass();
        JNIObjectHandle declaring = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)constructor, (JNIMethodId)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangReflectMemberGetDeclaringClass);
        if (Support.clearException((JNIEnvironment)jni)) {
            declaring = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        JNIObjectHandle paramTypesHandle = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)constructor, (JNIMethodId)((NativeImageAgentJNIHandleSet)agent.handles()).getJavaLangReflectExecutableGetParameterTypes(jni));
        if (Support.clearException((JNIEnvironment)jni)) {
            paramTypesHandle = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        Object paramTypes = BreakpointInterceptor.getClassArrayNames(jni, paramTypesHandle);
        BreakpointInterceptor.traceReflectBreakpoint(jni, declaring, declaring, callerClass, "invokeConstructor", declaring.notEqual((ComparableWord)JNIObjectHandles.nullHandle()), state.getFullStackTraceOrNull(), paramTypes);
        return true;
    }

    private static boolean newInstance(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        JNIObjectHandle callerClass = state.getDirectCallerClass();
        JNIObjectHandle self = Support.getReceiver((JNIObjectHandle)thread);
        BreakpointInterceptor.traceReflectBreakpoint(jni, self, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, self.notEqual((ComparableWord)JNIObjectHandles.nullHandle()), state.getFullStackTraceOrNull(), new Object[0]);
        return true;
    }

    private static boolean newArrayInstance(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        JNIValue args = (JNIValue)StackValue.get((int)2, JNIValue.class);
        args.addressOf(0).setObject(Support.getObjectArgument((JNIObjectHandle)thread, (int)0));
        args.addressOf(1).setInt(0);
        return BreakpointInterceptor.newArrayInstance0(jni, bp, args, true, state);
    }

    private static boolean newArrayInstanceMulti(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        JNIObjectHandle componentClass = Support.getObjectArgument((JNIObjectHandle)thread, (int)0);
        JNIObjectHandle dimensionsArray = Support.getObjectArgument((JNIObjectHandle)thread, (int)1);
        JNIValue args = (JNIValue)StackValue.get((int)2, JNIValue.class);
        args.addressOf(0).setObject(componentClass);
        args.addressOf(1).setObject(dimensionsArray);
        return BreakpointInterceptor.newArrayInstance0(jni, bp, args, dimensionsArray.notEqual((ComparableWord)JNIObjectHandles.nullHandle()), state);
    }

    private static boolean newArrayInstance0(JNIEnvironment jni, Breakpoint bp, JNIValue args, boolean argsValid, InterceptedState state) {
        JNIObjectHandle callerClass = state.getDirectCallerClass();
        JNIObjectHandle result = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        JNIObjectHandle resultClass = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        JNIObjectHandle componentClass = args.addressOf(0).getObject();
        if (componentClass.notEqual((ComparableWord)JNIObjectHandles.nullHandle()) && argsValid) {
            result = Support.jniFunctions().getCallStaticObjectMethodA().invoke(jni, bp.clazz, bp.method, args);
            if (Support.clearException((JNIEnvironment)jni)) {
                result = (JNIObjectHandle)JNIObjectHandles.nullHandle();
            } else {
                resultClass = Support.jniFunctions().getGetObjectClass().invoke(jni, result);
                if (Support.clearException((JNIEnvironment)jni)) {
                    resultClass = (JNIObjectHandle)JNIObjectHandles.nullHandle();
                }
            }
        }
        String resultClassName = Support.getClassNameOr((JNIEnvironment)jni, (JNIObjectHandle)resultClass, null, (String)Tracer.UNKNOWN_VALUE);
        BreakpointInterceptor.traceReflectBreakpoint(jni, bp.clazz, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, result.notEqual((ComparableWord)JNIObjectHandles.nullHandle()), state.getFullStackTraceOrNull(), resultClassName);
        return true;
    }

    private static boolean handleResourceRegistration(JNIEnvironment env, JNIObjectHandle clazz, JNIObjectHandle callerClass, String function, JNIMethodId[] stackTrace, String resourceName, String moduleName) {
        if (resourceName == null) {
            return true;
        }
        if (moduleName == null) {
            BreakpointInterceptor.traceReflectBreakpoint(env, clazz, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, function, true, stackTrace, resourceName);
        } else {
            BreakpointInterceptor.traceReflectBreakpoint(env, clazz, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, function, true, stackTrace, moduleName, resourceName);
        }
        return true;
    }

    private static boolean findResource(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        JNIObjectHandle callerClass = state.getDirectCallerClass();
        JNIObjectHandle module = Support.getObjectArgument((JNIObjectHandle)thread, (int)1);
        JNIObjectHandle name = Support.getObjectArgument((JNIObjectHandle)thread, (int)2);
        return BreakpointInterceptor.handleResourceRegistration(jni, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, state.getFullStackTraceOrNull(), Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)name), Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)module));
    }

    private static boolean getResource(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        return BreakpointInterceptor.handleGetResources(jni, thread, bp, state);
    }

    private static boolean getResources(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        return BreakpointInterceptor.handleGetResources(jni, thread, bp, state);
    }

    private static boolean handleGetResources(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        JNIObjectHandle callerClass = state.getDirectCallerClass();
        JNIObjectHandle self = Support.getReceiver((JNIObjectHandle)thread);
        JNIObjectHandle name = Support.getObjectArgument((JNIObjectHandle)thread, (int)1);
        JNIObjectHandle selfClazz = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        if (self.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
            selfClazz = Support.jniFunctions().getGetObjectClass().invoke(jni, self);
            if (Support.clearException((JNIEnvironment)jni)) {
                selfClazz = (JNIObjectHandle)JNIObjectHandles.nullHandle();
            }
        }
        return BreakpointInterceptor.handleResourceRegistration(jni, selfClazz, callerClass, ((BreakpointSpecification)bp.specification).methodName, state.getFullStackTraceOrNull(), Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)name), null);
    }

    private static boolean getSystemResource(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        return BreakpointInterceptor.handleGetSystemResources(jni, thread, bp, state);
    }

    private static boolean getSystemResources(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        return BreakpointInterceptor.handleGetSystemResources(jni, thread, bp, state);
    }

    private static boolean handleGetSystemResources(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        JNIObjectHandle callerClass = state.getDirectCallerClass();
        JNIObjectHandle name = Support.getObjectArgument((JNIObjectHandle)thread, (int)0);
        return BreakpointInterceptor.handleResourceRegistration(jni, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, state.getFullStackTraceOrNull(), Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)name), null);
    }

    private static boolean newProxyInstance(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        JNIObjectHandle callerClass = state.getDirectCallerClass();
        JNIObjectHandle classLoader = Support.getObjectArgument((JNIObjectHandle)thread, (int)0);
        JNIObjectHandle ifaces = Support.getObjectArgument((JNIObjectHandle)thread, (int)1);
        Object ifaceNames = BreakpointInterceptor.getClassArrayNames(jni, ifaces);
        JNIObjectHandle invokeHandler = Support.getObjectArgument((JNIObjectHandle)thread, (int)2);
        boolean result = JNIObjectHandles.nullHandle().notEqual((ComparableWord)Support.callStaticObjectMethodLLL((JNIEnvironment)jni, (JNIObjectHandle)bp.clazz, (JNIMethodId)bp.method, (JNIObjectHandle)classLoader, (JNIObjectHandle)ifaces, (JNIObjectHandle)invokeHandler));
        if (Support.clearException((JNIEnvironment)jni)) {
            result = false;
        }
        BreakpointInterceptor.traceReflectBreakpoint(jni, (JNIObjectHandle)JNIObjectHandles.nullHandle(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, result, state.getFullStackTraceOrNull(), Tracer.UNKNOWN_VALUE, ifaceNames, Tracer.UNKNOWN_VALUE);
        return true;
    }

    private static boolean getProxyClass(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        JNIObjectHandle callerClass = state.getDirectCallerClass();
        JNIObjectHandle classLoader = Support.getObjectArgument((JNIObjectHandle)thread, (int)0);
        JNIObjectHandle ifaces = Support.getObjectArgument((JNIObjectHandle)thread, (int)1);
        Object ifaceNames = BreakpointInterceptor.getClassArrayNames(jni, ifaces);
        boolean result = JNIObjectHandles.nullHandle().notEqual((ComparableWord)Support.callStaticObjectMethodLL((JNIEnvironment)jni, (JNIObjectHandle)bp.clazz, (JNIMethodId)bp.method, (JNIObjectHandle)classLoader, (JNIObjectHandle)ifaces));
        if (Support.clearException((JNIEnvironment)jni)) {
            result = false;
        }
        BreakpointInterceptor.traceReflectBreakpoint(jni, (JNIObjectHandle)JNIObjectHandles.nullHandle(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, result, state.getFullStackTraceOrNull(), Tracer.UNKNOWN_VALUE, ifaceNames);
        return true;
    }

    private static Object getClassArrayNames(JNIEnvironment jni, JNIObjectHandle classArray) {
        String[] classNames = Tracer.EXPLICIT_NULL;
        if (classArray.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
            classNames = Tracer.UNKNOWN_VALUE;
            int length = Support.jniFunctions().getGetArrayLength().invoke(jni, classArray);
            if (!Support.clearException((JNIEnvironment)jni) && length >= 0) {
                ArrayList<String> list = new ArrayList<String>();
                for (int i = 0; i < length; ++i) {
                    JNIObjectHandle clazz = Support.jniFunctions().getGetObjectArrayElement().invoke(jni, classArray, i);
                    if (!Support.clearException((JNIEnvironment)jni)) {
                        list.add(Support.getClassNameOr((JNIEnvironment)jni, (JNIObjectHandle)clazz, (String)Tracer.EXPLICIT_NULL, (String)Tracer.UNKNOWN_VALUE));
                        continue;
                    }
                    list.add(Tracer.UNKNOWN_VALUE);
                }
                classNames = list.toArray(new String[0]);
            }
        }
        return classNames;
    }

    private static boolean getBundleImpl(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        JNIMethodId intermediateMethod = state.getCallerMethod(2);
        JNIMethodId callerMethod = intermediateMethod.equal((ComparableWord)((NativeImageAgentJNIHandleSet)agent.handles()).tryGetJavaUtilResourceBundleGetBundleImplSLCC(jni)) ? state.getCallerMethod(4) : state.getCallerMethod(3);
        JNIObjectHandle callerClass = Support.getMethodDeclaringClass((JNIMethodId)callerMethod);
        JNIObjectHandle baseName = Support.getObjectArgument((JNIObjectHandle)thread, (int)2);
        JNIObjectHandle locale = Support.getObjectArgument((JNIObjectHandle)thread, (int)3);
        BreakpointInterceptor.traceReflectBreakpoint(jni, (JNIObjectHandle)JNIObjectHandles.nullHandle(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, true, state.getFullStackTraceOrNull(), Tracer.UNKNOWN_VALUE, Tracer.UNKNOWN_VALUE, Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)baseName), BreakpointInterceptor.readLocaleTag(jni, locale), Tracer.UNKNOWN_VALUE);
        return true;
    }

    private static String readLocaleTag(JNIEnvironment jni, JNIObjectHandle locale) {
        JNIObjectHandle languageTag = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)locale, (JNIMethodId)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaUtilLocaleToLanguageTag);
        if (Support.clearException((JNIEnvironment)jni)) {
            return "";
        }
        JNIObjectHandle reconstructedLocale = Support.callStaticObjectMethodL((JNIEnvironment)jni, (JNIObjectHandle)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaUtilLocale, (JNIMethodId)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaUtilLocaleForLanguageTag, (JNIObjectHandle)languageTag);
        if (Support.clearException((JNIEnvironment)jni)) {
            reconstructedLocale = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        if (Support.callBooleanMethodL((JNIEnvironment)jni, (JNIObjectHandle)locale, (JNIMethodId)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaUtilLocaleEquals, (JNIObjectHandle)reconstructedLocale)) {
            return Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)languageTag);
        }
        String language = BreakpointInterceptor.getElementString(jni, locale, ((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaUtilLocaleGetLanguage);
        String country = BreakpointInterceptor.getElementString(jni, locale, ((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaUtilLocaleGetCountry);
        String variant = BreakpointInterceptor.getElementString(jni, locale, ((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaUtilLocaleGetVariant);
        return String.join((CharSequence)"-", language, country, variant);
    }

    private static String getElementString(JNIEnvironment jni, JNIObjectHandle object, JNIMethodId getter) {
        JNIObjectHandle valueHandle = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)object, (JNIMethodId)getter);
        if (Support.clearException((JNIEnvironment)jni)) {
            valueHandle = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        return valueHandle.notEqual((ComparableWord)JNIObjectHandles.nullHandle()) ? Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)valueHandle) : "";
    }

    private static boolean loadClass(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        assert (experimentalClassLoaderSupport);
        JNIObjectHandle callerClass = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        JvmtiFrameInfo frameInfo = (JvmtiFrameInfo)StackValue.get(JvmtiFrameInfo.class);
        CIntPointer frameCountPtr = (CIntPointer)StackValue.get(CIntPointer.class);
        if (Support.jvmtiFunctions().GetStackTrace().invoke(Support.jvmtiEnv(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), 1, 1, (WordPointer)frameInfo, frameCountPtr) == JvmtiError.JVMTI_ERROR_NONE && frameCountPtr.read() == 1) {
            callerClass = Support.getMethodDeclaringClass((JNIMethodId)frameInfo.getMethod());
            if (callerClass.notEqual((ComparableWord)JNIObjectHandles.nullHandle()) && Support.jniFunctions().getIsAssignableFrom().invoke(jni, callerClass, ((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangClassLoader)) {
                return true;
            }
            MethodLocation location = new MethodLocation(frameInfo.getMethod(), NumUtil.safeToInt((long)frameInfo.getLocation()));
            if (!observedExplicitLoadClassCallSites.containsKey(location)) {
                if (!BreakpointInterceptor.isLoadClassInvocation(callerClass, location.method, location.bci, ((BreakpointSpecification)bp.specification).methodName, ((BreakpointSpecification)bp.specification).signature)) {
                    return true;
                }
                observedExplicitLoadClassCallSites.put(location, Boolean.TRUE);
            }
        }
        JNIObjectHandle name = Support.getObjectArgument((JNIObjectHandle)thread, (int)1);
        String className = Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)name);
        BreakpointInterceptor.traceReflectBreakpoint(jni, bp.clazz, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, className != null, state.getFullStackTraceOrNull(), className);
        return true;
    }

    private static boolean findSystemClass(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        JNIObjectHandle callerClass = state.getDirectCallerClass();
        JNIObjectHandle className = Support.getObjectArgument((JNIObjectHandle)thread, (int)1);
        BreakpointInterceptor.traceReflectBreakpoint(jni, bp.clazz, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, true, state.getFullStackTraceOrNull(), Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)className));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isLoadClassInvocation(JNIObjectHandle clazz, JNIMethodId method, int bci, String methodName, String signature) {
        int cpi;
        CIntPointer lengthPtr = (CIntPointer)StackValue.get(CIntPointer.class);
        CCharPointerPointer bytecodesPtr = (CCharPointerPointer)StackValue.get(CCharPointerPointer.class);
        if (Support.jvmtiFunctions().GetBytecodes().invoke(Support.jvmtiEnv(), method, lengthPtr, bytecodesPtr) != JvmtiError.JVMTI_ERROR_NONE) {
            return false;
        }
        CCharPointer bytecodes = bytecodesPtr.read();
        try {
            if (bci + 2 >= lengthPtr.read()) {
                boolean bl = false;
                return bl;
            }
            int instruction = Byte.toUnsignedInt(bytecodes.read(bci));
            if (instruction != 182) {
                boolean bl = false;
                return bl;
            }
            int indexbyte1 = Byte.toUnsignedInt(bytecodes.read(bci + 1));
            int indexbyte2 = Byte.toUnsignedInt(bytecodes.read(bci + 2));
            cpi = indexbyte1 << 8 | indexbyte2;
        }
        finally {
            Support.jvmtiFunctions().Deallocate().invoke(Support.jvmtiEnv(), (PointerBase)bytecodes);
        }
        CIntPointer constantPoolCountPtr = (CIntPointer)StackValue.get(CIntPointer.class);
        CIntPointer constantPoolByteCountPtr = (CIntPointer)StackValue.get(CIntPointer.class);
        CCharPointerPointer constantPoolBytesPtr = (CCharPointerPointer)StackValue.get(CCharPointerPointer.class);
        if (Support.jvmtiFunctions().GetConstantPool().invoke(Support.jvmtiEnv(), clazz, constantPoolCountPtr, constantPoolByteCountPtr, constantPoolBytesPtr) != JvmtiError.JVMTI_ERROR_NONE) {
            return false;
        }
        CCharPointer constantPool = constantPoolBytesPtr.read();
        try {
            ByteBuffer buffer = CTypeConversion.asByteBuffer((PointerBase)constantPool, (int)constantPoolByteCountPtr.read());
            buffer.order(ByteOrder.BIG_ENDIAN);
            try {
                ConstantPoolTool.MethodReference ref = new ConstantPoolTool(buffer).readMethodReference(cpi);
                boolean bl = methodName.contentEquals(ref.name) && signature.contentEquals(ref.descriptor);
                return bl;
            }
            catch (ConstantPoolTool.ConstantPoolException e) {
                boolean bl = false;
                Support.jvmtiFunctions().Deallocate().invoke(Support.jvmtiEnv(), (PointerBase)constantPool);
                return bl;
            }
        }
        finally {
            Support.jvmtiFunctions().Deallocate().invoke(Support.jvmtiEnv(), (PointerBase)constantPool);
        }
    }

    private static boolean findMethodHandle(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        JNIObjectHandle callerClass = state.getDirectCallerClass();
        JNIObjectHandle declaringClass = Support.getObjectArgument((JNIObjectHandle)thread, (int)1);
        JNIObjectHandle methodName = Support.getObjectArgument((JNIObjectHandle)thread, (int)2);
        JNIObjectHandle methodType = Support.getObjectArgument((JNIObjectHandle)thread, (int)3);
        return BreakpointInterceptor.methodMethodHandle(jni, declaringClass, callerClass, methodName, BreakpointInterceptor.getParamTypes(jni, methodType), state.getFullStackTraceOrNull());
    }

    private static boolean findSpecialHandle(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        JNIObjectHandle callerClass = state.getDirectCallerClass();
        JNIObjectHandle declaringClass = Support.getObjectArgument((JNIObjectHandle)thread, (int)1);
        JNIObjectHandle methodName = Support.getObjectArgument((JNIObjectHandle)thread, (int)2);
        JNIObjectHandle methodType = Support.getObjectArgument((JNIObjectHandle)thread, (int)3);
        return BreakpointInterceptor.methodMethodHandle(jni, declaringClass, callerClass, methodName, BreakpointInterceptor.getParamTypes(jni, methodType), state.getFullStackTraceOrNull());
    }

    private static boolean bindHandle(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        JNIObjectHandle callerClass = state.getDirectCallerClass();
        JNIObjectHandle receiver = Support.getObjectArgument((JNIObjectHandle)thread, (int)1);
        JNIObjectHandle methodName = Support.getObjectArgument((JNIObjectHandle)thread, (int)2);
        JNIObjectHandle methodType = Support.getObjectArgument((JNIObjectHandle)thread, (int)3);
        JNIObjectHandle declaringClass = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)receiver, (JNIMethodId)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangObjectGetClass);
        if (Support.clearException((JNIEnvironment)jni)) {
            declaringClass = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        return BreakpointInterceptor.methodMethodHandle(jni, declaringClass, callerClass, methodName, BreakpointInterceptor.getParamTypes(jni, methodType), state.getFullStackTraceOrNull());
    }

    private static boolean methodMethodHandle(JNIEnvironment jni, JNIObjectHandle declaringClass, JNIObjectHandle callerClass, JNIObjectHandle nameHandle, JNIObjectHandle paramTypesHandle, JNIMethodId[] stackTrace) {
        String name = Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)nameHandle);
        Object paramTypes = BreakpointInterceptor.getClassArrayNames(jni, paramTypesHandle);
        BreakpointInterceptor.traceReflectBreakpoint(jni, declaringClass, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, "findMethodHandle", declaringClass.notEqual((ComparableWord)JNIObjectHandles.nullHandle()) && name != null, stackTrace, name, paramTypes);
        return true;
    }

    private static boolean findConstructorHandle(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        JNIObjectHandle callerClass = state.getDirectCallerClass();
        JNIObjectHandle declaringClass = Support.getObjectArgument((JNIObjectHandle)thread, (int)1);
        JNIObjectHandle methodType = Support.getObjectArgument((JNIObjectHandle)thread, (int)2);
        Object paramTypes = BreakpointInterceptor.getClassArrayNames(jni, BreakpointInterceptor.getParamTypes(jni, methodType));
        BreakpointInterceptor.traceReflectBreakpoint(jni, declaringClass, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, "findConstructorHandle", declaringClass.notEqual((ComparableWord)JNIObjectHandles.nullHandle()), state.getFullStackTraceOrNull(), paramTypes);
        return true;
    }

    private static JNIObjectHandle getParamTypes(JNIEnvironment jni, JNIObjectHandle methodType) {
        JNIObjectHandle paramTypesHandle = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)methodType, (JNIMethodId)((NativeImageAgentJNIHandleSet)agent.handles()).getJavaLangInvokeMethodTypeParameterArray(jni));
        if (Support.clearException((JNIEnvironment)jni)) {
            paramTypesHandle = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        return paramTypesHandle;
    }

    private static boolean findFieldHandle(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        JNIObjectHandle callerClass = state.getDirectCallerClass();
        JNIObjectHandle declaringClass = Support.getObjectArgument((JNIObjectHandle)thread, (int)1);
        JNIObjectHandle fieldName = Support.getObjectArgument((JNIObjectHandle)thread, (int)2);
        String name = Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)fieldName);
        BreakpointInterceptor.traceReflectBreakpoint(jni, declaringClass, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, "findFieldHandle", declaringClass.notEqual((ComparableWord)JNIObjectHandles.nullHandle()) && name != null, state.getFullStackTraceOrNull(), name);
        return true;
    }

    private static boolean findClass(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        JNIObjectHandle callerClass = state.getDirectCallerClass();
        JNIObjectHandle className = Support.getObjectArgument((JNIObjectHandle)thread, (int)1);
        String name = Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)className);
        BreakpointInterceptor.traceReflectBreakpoint(jni, bp.clazz, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, "findClass", name != null, state.getFullStackTraceOrNull(), name);
        return true;
    }

    private static boolean unreflectField(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        JNIObjectHandle callerClass = state.getDirectCallerClass();
        JNIObjectHandle field = Support.getObjectArgument((JNIObjectHandle)thread, (int)1);
        JNIObjectHandle declaringClass = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)field, (JNIMethodId)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangReflectMemberGetDeclaringClass);
        if (Support.clearException((JNIEnvironment)jni)) {
            declaringClass = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        JNIObjectHandle fieldNameHandle = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)field, (JNIMethodId)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangReflectMemberGetName);
        if (Support.clearException((JNIEnvironment)jni)) {
            fieldNameHandle = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        String fieldName = Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)fieldNameHandle);
        BreakpointInterceptor.traceReflectBreakpoint(jni, declaringClass, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, "unreflectField", declaringClass.notEqual((ComparableWord)JNIObjectHandles.nullHandle()) && fieldName != null, state.getFullStackTraceOrNull(), fieldName);
        return true;
    }

    private static boolean asInterfaceInstance(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        JNIObjectHandle callerClass = state.getDirectCallerClass();
        JNIObjectHandle intfc = Support.getObjectArgument((JNIObjectHandle)thread, (int)0);
        JNIObjectHandle intfcNameHandle = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)intfc, (JNIMethodId)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangClassGetName);
        if (Support.clearException((JNIEnvironment)jni)) {
            intfcNameHandle = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        String intfcName = Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)intfcNameHandle);
        BreakpointInterceptor.traceReflectBreakpoint(jni, intfc, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, "asInterfaceInstance", intfcName != null, state.getFullStackTraceOrNull(), new Object[0]);
        String[] intfcNames = new String[]{intfcName};
        BreakpointInterceptor.traceReflectBreakpoint(jni, (JNIObjectHandle)JNIObjectHandles.nullHandle(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, "newMethodHandleProxyInstance", intfcName != null, state.getFullStackTraceOrNull(), new Object[]{intfcNames});
        return true;
    }

    private static boolean constantBootstrapGetStaticFinal(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state, boolean hasDeclaringClass) {
        JNIObjectHandle callerClass = state.getDirectCallerClass();
        JNIObjectHandle fieldName = Support.getObjectArgument((JNIObjectHandle)thread, (int)1);
        JNIObjectHandle type = Support.getObjectArgument((JNIObjectHandle)thread, (int)2);
        JNIObjectHandle declaringClass = hasDeclaringClass ? Support.getObjectArgument((JNIObjectHandle)thread, (int)3) : type;
        String name = Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)fieldName);
        BreakpointInterceptor.traceReflectBreakpoint(jni, declaringClass, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, "findFieldHandle", declaringClass.notEqual((ComparableWord)JNIObjectHandles.nullHandle()) && name != null, state.getFullStackTraceOrNull(), name);
        return true;
    }

    private static boolean methodTypeFromDescriptor(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        JNIObjectHandle callerClass = state.getDirectCallerClass();
        JNIObjectHandle descriptor = Support.getObjectArgument((JNIObjectHandle)thread, (int)0);
        JNIObjectHandle classLoader = Support.getObjectArgument((JNIObjectHandle)thread, (int)1);
        JNIObjectHandle result = Support.callStaticObjectMethodLL((JNIEnvironment)jni, (JNIObjectHandle)bp.clazz, (JNIMethodId)bp.method, (JNIObjectHandle)descriptor, (JNIObjectHandle)classLoader);
        if (Support.clearException((JNIEnvironment)jni)) {
            result = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        ArrayList<String> types = new ArrayList<String>();
        if (result.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
            Object ptypeNames;
            String rtypeName;
            JNIObjectHandle rtype = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)result, (JNIMethodId)((NativeImageAgentJNIHandleSet)agent.handles()).getJavaLangInvokeMethodTypeReturnType(jni));
            if (Support.clearException((JNIEnvironment)jni)) {
                rtype = (JNIObjectHandle)JNIObjectHandles.nullHandle();
            }
            if ((rtypeName = Support.getClassNameOrNull((JNIEnvironment)jni, (JNIObjectHandle)rtype)) != null) {
                types.add(rtypeName);
            }
            JNIObjectHandle ptypes = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)result, (JNIMethodId)((NativeImageAgentJNIHandleSet)agent.handles()).getJavaLangInvokeMethodTypeParameterArray(jni));
            if (Support.clearException((JNIEnvironment)jni)) {
                ptypes = (JNIObjectHandle)JNIObjectHandles.nullHandle();
            }
            if ((ptypeNames = BreakpointInterceptor.getClassArrayNames(jni, ptypes)) instanceof String[]) {
                types.addAll(Arrays.asList((String[])ptypeNames));
            }
        }
        BreakpointInterceptor.traceReflectBreakpoint(jni, (JNIObjectHandle)JNIObjectHandles.nullHandle(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, "methodTypeDescriptor", result.notEqual((ComparableWord)JNIObjectHandles.nullHandle()), state.getFullStackTraceOrNull(), types);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean onMethodHandleClassFileInit(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        Object className = Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)Support.getObjectArgument((JNIObjectHandle)thread, (int)1));
        if (LambdaUtils.isLambdaClassName((String)className)) {
            if (BreakpointInterceptor.shouldIgnoreLambdaClassForPredefinition(jni)) {
                return true;
            }
            JNIObjectHandle bytesArray = Support.getObjectArgument((JNIObjectHandle)thread, (int)3);
            int length = Support.jniFunctions().getGetArrayLength().invoke(jni, bytesArray);
            byte[] data = new byte[length];
            CCharPointer bytesArrayCharPointer = jni.getFunctions().getGetByteArrayElements().invoke(jni, bytesArray, (CCharPointer)WordFactory.nullPointer());
            if (bytesArrayCharPointer.isNonNull()) {
                try {
                    CTypeConversion.asByteBuffer((PointerBase)bytesArrayCharPointer, (int)length).get(data);
                }
                finally {
                    jni.getFunctions().getReleaseByteArrayElements().invoke(jni, bytesArray, bytesArrayCharPointer, JNIMode.JNI_ABORT());
                }
                className = (String)className + Digest.digest((byte[])data);
                tracer.traceCall("classloading", "onMethodHandleClassFileInit", null, null, null, null, state.getFullStackTraceOrNull(), className, data);
            }
        }
        return true;
    }

    private static boolean shouldIgnoreLambdaClassForPredefinition(JNIEnvironment env) {
        JNIMethodId[] stackTraceMethodIds = EagerlyLoadedJavaStackAccess.stackAccessSupplier().get().getFullStackTraceOrNull();
        JNIMethodId javaLangInvokeCallSiteMakeSite = ((NativeImageAgentJNIHandleSet)agent.handles()).getJavaLangInvokeCallSiteMakeSite(env);
        JNIMethodId javaLangInvokeMethodHandleNativesLinkCallSiteImpl = ((NativeImageAgentJNIHandleSet)agent.handles()).getJavaLangInvokeMethodHandleNativesLinkCallSiteImpl(env);
        JNIMethodId javaLangInvokeMethodHandleNativesLinkCallSite = ((NativeImageAgentJNIHandleSet)agent.handles()).getJavaLangInvokeMethodHandleNativesLinkCallSite(env);
        for (int i = 0; i < stackTraceMethodIds.length - 2; ++i) {
            if (stackTraceMethodIds[i] != javaLangInvokeCallSiteMakeSite || stackTraceMethodIds[i + 1] != javaLangInvokeMethodHandleNativesLinkCallSiteImpl || stackTraceMethodIds[i + 2] != javaLangInvokeMethodHandleNativesLinkCallSite) continue;
            return true;
        }
        return false;
    }

    private static boolean serializedLambdaReadResolve(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        JNIObjectHandle serializedLambdaInstance = Support.getReceiver((JNIObjectHandle)thread);
        JNIObjectHandle capturingClass = Support.jniFunctions().getGetObjectField().invoke(jni, serializedLambdaInstance, ((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangInvokeSerializedLambdaCapturingClass);
        String capturingClassName = Support.getClassNameOrNull((JNIEnvironment)jni, (JNIObjectHandle)capturingClass);
        boolean validCapturingClass = JNIObjectHandles.nullHandle().notEqual((ComparableWord)capturingClass);
        BreakpointInterceptor.traceSerializeBreakpoint(jni, "SerializedLambda.readResolve", validCapturingClass, state.getFullStackTraceOrNull(), capturingClassName);
        return true;
    }

    private static boolean readClassDescriptor(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        JNIObjectHandle desc = Support.getObjectArgument((JNIObjectHandle)thread, (int)1);
        JNIMethodId descriptor = ((NativeImageAgentJNIHandleSet)agent.handles()).getJavaIoObjectStreamClassGetName(jni);
        JNIObjectHandle name = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)desc, (JNIMethodId)descriptor);
        if (Support.clearException((JNIEnvironment)jni)) {
            name = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        String className = Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)name);
        BreakpointInterceptor.traceSerializeBreakpoint(jni, "ObjectInputStream.readClassDescriptor", true, state.getFullStackTraceOrNull(), className, null);
        return true;
    }

    private static boolean objectStreamClassConstructor(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        JNIObjectHandle serializeTargetClass = Support.getObjectArgument((JNIObjectHandle)thread, (int)1);
        if (Support.isSerializable((JNIEnvironment)jni, (JNIObjectHandle)serializeTargetClass)) {
            String serializeTargetClassName = Support.getClassNameOrNull((JNIEnvironment)jni, (JNIObjectHandle)serializeTargetClass);
            JNIObjectHandle objectStreamClassInstance = Support.newObjectL((JNIEnvironment)jni, (JNIObjectHandle)bp.clazz, (JNIMethodId)bp.method, (JNIObjectHandle)serializeTargetClass);
            boolean validObjectStreamClassInstance = JNIObjectHandles.nullHandle().notEqual((ComparableWord)objectStreamClassInstance);
            if (Support.clearException((JNIEnvironment)jni)) {
                validObjectStreamClassInstance = false;
            }
            ArrayList<String> transitiveSerializeTargets = new ArrayList<String>();
            transitiveSerializeTargets.add(serializeTargetClassName);
            JNIMethodId getClassDataLayout0MId = ((NativeImageAgentJNIHandleSet)agent.handles()).getJavaIoObjectStreamClassGetClassDataLayout0(jni, bp.clazz);
            JNIObjectHandle dataLayoutArray = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)objectStreamClassInstance, (JNIMethodId)getClassDataLayout0MId);
            if (!Support.clearException((JNIEnvironment)jni) && JNIObjectHandles.nullHandle().notEqual((ComparableWord)dataLayoutArray)) {
                int length = Support.jniFunctions().getGetArrayLength().invoke(jni, dataLayoutArray);
                if (!Support.clearException((JNIEnvironment)jni) && length > 1) {
                    JNIFieldId hasDataFId = ((NativeImageAgentJNIHandleSet)agent.handles()).getJavaIOObjectStreamClassClassDataSlotHasData(jni);
                    JNIFieldId descFId = ((NativeImageAgentJNIHandleSet)agent.handles()).getJavaIOObjectStreamClassClassDataSlotDesc(jni);
                    JNIMethodId javaIoObjectStreamClassForClassMId = ((NativeImageAgentJNIHandleSet)agent.handles()).getJavaIoObjectStreamClassForClass(jni, bp.clazz);
                    for (int i = 0; i < length; ++i) {
                        JNIObjectHandle oscClazz;
                        JNIObjectHandle classDataSlot = Support.jniFunctions().getGetObjectArrayElement().invoke(jni, dataLayoutArray, i);
                        boolean hasData = Support.jniFunctions().getGetBooleanField().invoke(jni, classDataSlot, hasDataFId);
                        if (!hasData) continue;
                        JNIObjectHandle oscInstanceInSlot = Support.jniFunctions().getGetObjectField().invoke(jni, classDataSlot, descFId);
                        if (Support.jniFunctions().getIsSameObject().invoke(jni, oscInstanceInSlot, objectStreamClassInstance) || !Support.isSerializable((JNIEnvironment)jni, (JNIObjectHandle)(oscClazz = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)oscInstanceInSlot, (JNIMethodId)javaIoObjectStreamClassForClassMId)))) continue;
                        String oscClassName = Support.getClassNameOrNull((JNIEnvironment)jni, (JNIObjectHandle)oscClazz);
                        transitiveSerializeTargets.add(oscClassName);
                    }
                }
            }
            for (String className : transitiveSerializeTargets) {
                if (DynamicProxySupport.PROXY_CLASS_NAME_PATTERN.matcher(className).matches()) {
                    JNIObjectHandle interfaces = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)serializeTargetClass, (JNIMethodId)((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangClassGetInterfaces);
                    Object interfaceNames = BreakpointInterceptor.getClassArrayNames(jni, interfaces);
                    BreakpointInterceptor.traceSerializeBreakpoint(jni, "ProxyClassSerialization", validObjectStreamClassInstance, state.getFullStackTraceOrNull(), interfaceNames);
                    continue;
                }
                BreakpointInterceptor.traceSerializeBreakpoint(jni, "ObjectStreamClass.<init>", validObjectStreamClassInstance, state.getFullStackTraceOrNull(), className, null);
            }
        }
        return true;
    }

    private static boolean customTargetConstructorSerialization(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        JNIObjectHandle serializeTargetClass = Support.getObjectArgument((JNIObjectHandle)thread, (int)1);
        if (Support.isSerializable((JNIEnvironment)jni, (JNIObjectHandle)serializeTargetClass)) {
            String serializeTargetClassName = Support.getClassNameOrNull((JNIEnvironment)jni, (JNIObjectHandle)serializeTargetClass);
            JNIObjectHandle customConstructorObj = Support.getObjectArgument((JNIObjectHandle)thread, (int)2);
            JNIObjectHandle customConstructorClass = Support.jniFunctions().getGetObjectClass().invoke(jni, customConstructorObj);
            JNIMethodId getDeclaringClassNameMethodID = ((NativeImageAgentJNIHandleSet)agent.handles()).getJavaLangReflectConstructorDeclaringClassName(jni, customConstructorClass);
            JNIObjectHandle declaredClassNameObj = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)customConstructorObj, (JNIMethodId)getDeclaringClassNameMethodID);
            String customConstructorClassName = Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)declaredClassNameObj);
            BreakpointInterceptor.traceSerializeBreakpoint(jni, "ObjectStreamClass.<init>", true, state.getFullStackTraceOrNull(), serializeTargetClassName, customConstructorClassName);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CEntryPoint
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class)
    private static void onBreakpoint(JvmtiEnv jvmti, JNIEnvironment jni, JNIObjectHandle thread, JNIMethodId method, long location) {
        if (recursive.get().booleanValue()) {
            return;
        }
        recursive.set(true);
        try {
            InterceptedState state;
            JNIObjectHandle rectifiedThread = BreakpointInterceptor.rectifyCurrentThread(thread);
            if (rectifiedThread.equal((ComparableWord)JNIObjectHandles.nullHandle())) {
                return;
            }
            Breakpoint bp = installedBreakpoints.get(method.rawValue());
            if (((BreakpointSpecification)bp.specification).handler.dispatch(jni, rectifiedThread, bp, state = interceptedStateSupplier.get())) {
                VMError.guarantee((!Support.testException((JNIEnvironment)jni) ? 1 : 0) != 0);
            }
        }
        catch (Throwable t) {
            VMError.shouldNotReachHere((Throwable)t);
        }
        finally {
            recursive.set(false);
        }
    }

    private static JNIObjectHandle rectifyCurrentThread(JNIObjectHandle thread) {
        if (Support.jvmtiVersion() != 0x30130000) {
            return thread;
        }
        WordPointer threadPtr = (WordPointer)StackValue.get(WordPointer.class);
        JvmtiError error = Support.jvmtiFunctions().GetCurrentThread().invoke(Support.jvmtiEnv(), (PointerBase)threadPtr);
        if (error == JvmtiError.JVMTI_ERROR_WRONG_PHASE) {
            return (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        Support.check((JvmtiError)error);
        return (JNIObjectHandle)threadPtr.read();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CEntryPoint
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class)
    private static void onNativeMethodBind(JvmtiEnv jvmti, JNIEnvironment jni, JNIObjectHandle thread, JNIMethodId method, CodePointer address, WordPointer newAddressPtr) {
        if (recursive.get().booleanValue()) {
            return;
        }
        nativeBreakpointsInitLock.lock();
        try {
            if (nativeBreakpoints != null) {
                NativeBreakpoint bp = nativeBreakpoints.get(method.rawValue());
                if (bp != null) {
                    BreakpointInterceptor.bindNativeBreakpoint(jni, bp, address, newAddressPtr);
                }
            } else {
                boundNativeMethods.put(method.rawValue(), address.rawValue());
            }
        }
        finally {
            nativeBreakpointsInitLock.unlock();
        }
    }

    @CEntryPoint
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class)
    private static void onClassPrepare(JvmtiEnv jvmti, JNIEnvironment jni, JNIObjectHandle thread, JNIObjectHandle clazz) {
        assert (experimentalClassLoaderSupport);
        BreakpointInterceptor.installBreakpointIfClassLoader(jni, clazz, installedBreakpoints);
    }

    private static void installBreakpointIfClassLoader(JNIEnvironment jni, JNIObjectHandle clazz, Map<Long, Breakpoint> breakpoints) {
        String className;
        if (Support.jniFunctions().getIsAssignableFrom().invoke(jni, clazz, ((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangClassLoader) && (className = Support.getClassNameOrNull((JNIEnvironment)jni, (JNIObjectHandle)clazz)) != null) {
            BreakpointSpecification proto = CLASSLOADER_LOAD_CLASS_BREAKPOINT_SPECIFICATION;
            JNIMethodId method = BreakpointInterceptor.resolveBreakpointMethod(jni, clazz, proto.methodName, proto.signature, true);
            if (method.isNonNull() && Support.jvmtiFunctions().SetBreakpoint().invoke(Support.jvmtiEnv(), method, 0L) == JvmtiError.JVMTI_ERROR_NONE) {
                BreakpointSpecification spec = new BreakpointSpecification(className, proto.methodName, proto.signature, proto.handler, proto.optional);
                JNIObjectHandle gclazz = ((NativeImageAgentJNIHandleSet)agent.handles()).newTrackedGlobalRef(jni, clazz);
                breakpoints.put(method.rawValue(), new Breakpoint(spec, gclazz, method));
            }
        }
    }

    @CEntryPoint
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class)
    private static void onClassFileLoadHook(JvmtiEnv jvmti, JNIEnvironment jni, JNIObjectHandle classBeingRedefined, JNIObjectHandle loader, CCharPointer name, JNIObjectHandle protectionDomain, int classDataLen, CCharPointer classData, CIntPointer newClassDataLen, CCharPointerPointer newClassData) {
        InterceptedState state = interceptedStateSupplier.get();
        if (loader.equal((ComparableWord)JNIObjectHandles.nullHandle())) {
            return;
        }
        String className = Support.fromCString((CCharPointer)name);
        if (className != null && AccessAdvisor.PROXY_CLASS_NAME_PATTERN.matcher(className).matches()) {
            return;
        }
        for (JNIObjectHandle builtinLoader : builtinClassLoaders) {
            if (!Support.jniFunctions().getIsSameObject().invoke(jni, loader, builtinLoader)) continue;
            return;
        }
        JNIObjectHandle jdkInternalReflectDelegatingClassLoader = ((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).jdkInternalReflectDelegatingClassLoader;
        if (!jdkInternalReflectDelegatingClassLoader.equal((ComparableWord)JNIObjectHandles.nullHandle()) && Support.jniFunctions().getIsInstanceOf().invoke(jni, loader, jdkInternalReflectDelegatingClassLoader)) {
            return;
        }
        byte[] data = new byte[classDataLen];
        CTypeConversion.asByteBuffer((PointerBase)classData, (int)classDataLen).get(data);
        tracer.traceCall("classloading", "onClassFileLoadHook", null, null, null, null, state.getFullStackTraceOrNull(), className, data);
    }

    public static void onLoad(JvmtiEnv jvmti, JvmtiEventCallbacks callbacks, Tracer writer, NativeImageAgent nativeImageTracingAgent, Supplier<InterceptedState> currentThreadJavaStackAccessSupplier, boolean exptlClassLoaderSupport, boolean exptlClassDefineSupport, boolean exptlUnsafeAllocationSupport, boolean trackReflectionData) {
        tracer = writer;
        agent = nativeImageTracingAgent;
        interceptedStateSupplier = currentThreadJavaStackAccessSupplier;
        experimentalClassLoaderSupport = exptlClassLoaderSupport;
        experimentalClassDefineSupport = exptlClassDefineSupport;
        experimentalUnsafeAllocationSupport = exptlUnsafeAllocationSupport;
        trackReflectionMetadata = trackReflectionData;
        JvmtiCapabilities capabilities = (JvmtiCapabilities)UnmanagedMemory.calloc((int)SizeOf.get(JvmtiCapabilities.class));
        Support.check((JvmtiError)jvmti.getFunctions().GetCapabilities().invoke(jvmti, capabilities));
        capabilities.setCanGenerateBreakpointEvents(1);
        capabilities.setCanAccessLocalVariables(1);
        if (exptlUnsafeAllocationSupport) {
            capabilities.setCanGenerateNativeMethodBindEvents(1);
            callbacks.setNativeMethodBind(onNativeMethodBindLiteral.getFunctionPointer());
            boundNativeMethods = new HashMap<Long, Long>();
        }
        if (exptlClassLoaderSupport) {
            capabilities.setCanGetBytecodes(1);
            capabilities.setCanGetConstantPool(1);
            CIntPointer formatPtr = (CIntPointer)StackValue.get(CIntPointer.class);
            VMError.guarantee((jvmti.getFunctions().GetJLocationFormat().invoke(jvmti, formatPtr) == JvmtiError.JVMTI_ERROR_NONE && formatPtr.read() == JvmtiLocationFormat.JVMTI_JLOCATION_JVMBCI.getCValue() ? 1 : 0) != 0, (String)"Expecting BCI locations");
        }
        Support.check((JvmtiError)jvmti.getFunctions().AddCapabilities().invoke(jvmti, capabilities));
        UnmanagedMemory.free((PointerBase)capabilities);
        callbacks.setBreakpoint(onBreakpointLiteral.getFunctionPointer());
        if (exptlClassDefineSupport) {
            callbacks.setClassFileLoadHook(onClassFileLoadHookLiteral.getFunctionPointer());
        }
        if (exptlClassLoaderSupport) {
            callbacks.setClassPrepare(onClassPrepareLiteral.getFunctionPointer());
        }
        if (exptlUnsafeAllocationSupport) {
            Support.check((JvmtiError)jvmti.getFunctions().SetEventNotificationMode().invoke(jvmti, JvmtiEventMode.JVMTI_ENABLE, JvmtiEvent.JVMTI_EVENT_NATIVE_METHOD_BIND, (JNIObjectHandle)JNIObjectHandles.nullHandle()));
        }
    }

    public static void onVMInit(JvmtiEnv jvmti, JNIEnvironment jni) {
        ConcurrentHashMap<Long, Breakpoint> breakpoints;
        if (experimentalClassLoaderSupport) {
            breakpoints = new ConcurrentHashMap(BREAKPOINT_SPECIFICATIONS.length);
            observedExplicitLoadClassCallSites = new ConcurrentHashMap<MethodLocation, Boolean>();
            CIntPointer classCountPtr = (CIntPointer)StackValue.get(CIntPointer.class);
            WordPointer classesPtr = (WordPointer)StackValue.get(WordPointer.class);
            Support.check((JvmtiError)Support.jvmtiFunctions().GetLoadedClasses().invoke(jvmti, classCountPtr, classesPtr));
            WordPointer classesArray = (WordPointer)classesPtr.read();
            for (int i = 0; i < classCountPtr.read(); ++i) {
                JNIObjectHandle clazz = (JNIObjectHandle)classesArray.read(i);
                BreakpointInterceptor.installBreakpointIfClassLoader(jni, clazz, breakpoints);
            }
            Support.check((JvmtiError)Support.jvmtiFunctions().Deallocate().invoke(jvmti, (PointerBase)classesArray));
        } else {
            breakpoints = new HashMap(BREAKPOINT_SPECIFICATIONS.length);
        }
        JNIObjectHandle lastClass = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        String lastClassName = null;
        BreakpointSpecification[] breakpointSpecifications = BREAKPOINT_SPECIFICATIONS;
        if (trackReflectionMetadata) {
            breakpointSpecifications = new BreakpointSpecification[BREAKPOINT_SPECIFICATIONS.length + REFLECTION_ACCESS_BREAKPOINT_SPECIFICATIONS.length];
            System.arraycopy(BREAKPOINT_SPECIFICATIONS, 0, breakpointSpecifications, 0, BREAKPOINT_SPECIFICATIONS.length);
            System.arraycopy(REFLECTION_ACCESS_BREAKPOINT_SPECIFICATIONS, 0, breakpointSpecifications, BREAKPOINT_SPECIFICATIONS.length, REFLECTION_ACCESS_BREAKPOINT_SPECIFICATIONS.length);
        }
        if (experimentalClassDefineSupport) {
            BreakpointSpecification[] existingBreakpointSpecifications = breakpointSpecifications;
            breakpointSpecifications = Arrays.copyOf(existingBreakpointSpecifications, existingBreakpointSpecifications.length + CLASS_PREDEFINITION_BREAKPOINT_SPECIFICATIONS.length);
            System.arraycopy(CLASS_PREDEFINITION_BREAKPOINT_SPECIFICATIONS, 0, breakpointSpecifications, existingBreakpointSpecifications.length, CLASS_PREDEFINITION_BREAKPOINT_SPECIFICATIONS.length);
        }
        for (BreakpointSpecification br : breakpointSpecifications) {
            Breakpoint bp;
            JNIObjectHandle clazz = (JNIObjectHandle)JNIObjectHandles.nullHandle();
            if (lastClassName != null && lastClassName.equals(br.className)) {
                clazz = lastClass;
            }
            if ((bp = BreakpointInterceptor.installBreakpoint(jni, br, breakpoints, clazz)) == null) continue;
            lastClass = bp.clazz;
            lastClassName = br.className;
        }
        installedBreakpoints = breakpoints;
        if (experimentalUnsafeAllocationSupport) {
            BreakpointInterceptor.setupNativeBreakpoints(jni, lastClass, lastClassName);
        }
        if (experimentalClassDefineSupport) {
            BreakpointInterceptor.setupClassLoadEvent(jvmti, jni);
        }
        Support.check((JvmtiError)jvmti.getFunctions().SetEventNotificationMode().invoke(jvmti, JvmtiEventMode.JVMTI_ENABLE, JvmtiEvent.JVMTI_EVENT_BREAKPOINT, (JNIObjectHandle)JNIObjectHandles.nullHandle()));
        if (experimentalClassLoaderSupport) {
            Support.check((JvmtiError)jvmti.getFunctions().SetEventNotificationMode().invoke(jvmti, JvmtiEventMode.JVMTI_ENABLE, JvmtiEvent.JVMTI_EVENT_CLASS_PREPARE, (JNIObjectHandle)JNIObjectHandles.nullHandle()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setupNativeBreakpoints(JNIEnvironment jni, JNIObjectHandle previousClass, String previousClassName) {
        JNIObjectHandle lastClass = previousClass;
        String lastClassName = previousClassName;
        nativeBreakpointsInitLock.lock();
        try {
            nativeBreakpoints = new HashMap<Long, NativeBreakpoint>(NATIVE_BREAKPOINT_SPECIFICATIONS.length);
            for (NativeBreakpointSpecification br : NATIVE_BREAKPOINT_SPECIFICATIONS) {
                JNIObjectHandle clazz;
                if (lastClassName != null && lastClassName.equals(br.className)) {
                    clazz = lastClass;
                } else {
                    lastClass = clazz = BreakpointInterceptor.resolveBreakpointClass(jni, br.className, br.optional);
                    lastClassName = br.className;
                }
                JNIMethodId method = BreakpointInterceptor.resolveBreakpointMethod(jni, clazz, br.methodName, br.signature, br.optional);
                if (!method.isNonNull()) continue;
                NativeBreakpoint bp = new NativeBreakpoint(br, clazz, method);
                nativeBreakpoints.put(method.rawValue(), bp);
                Long original = boundNativeMethods.get(method.rawValue());
                if (original == null) continue;
                BreakpointInterceptor.bindNativeBreakpoint(jni, bp, (CodePointer)WordFactory.pointer((long)original), (WordPointer)WordFactory.nullPointer());
            }
            boundNativeMethods = null;
        }
        finally {
            nativeBreakpointsInitLock.unlock();
        }
    }

    private static void setupClassLoadEvent(JvmtiEnv jvmti, JNIEnvironment jni) {
        JNIObjectHandle classLoader = ((NativeImageAgentJNIHandleSet)BreakpointInterceptor.agent.handles()).javaLangClassLoader;
        JNIMethodId getSystemClassLoader = ((NativeImageAgentJNIHandleSet)agent.handles()).getMethodId(jni, classLoader, "getSystemClassLoader", "()Ljava/lang/ClassLoader;", true);
        JNIObjectHandle systemLoader = Support.callStaticObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)classLoader, (JNIMethodId)getSystemClassLoader);
        Support.checkNoException((JNIEnvironment)jni);
        VMError.guarantee((boolean)systemLoader.notEqual((ComparableWord)JNIObjectHandles.nullHandle()));
        JNIMethodId getPlatformLoader = ((NativeImageAgentJNIHandleSet)agent.handles()).getMethodIdOptional(jni, classLoader, "getPlatformClassLoader", "()Ljava/lang/ClassLoader;", true);
        JNIMethodId getAppLoader = ((NativeImageAgentJNIHandleSet)agent.handles()).getMethodIdOptional(jni, classLoader, "getBuiltinAppClassLoader", "()Ljava/lang/ClassLoader;", true);
        if (getPlatformLoader.isNonNull() && getAppLoader.isNonNull()) {
            JNIObjectHandle platformLoader = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)classLoader, (JNIMethodId)getPlatformLoader);
            Support.checkNoException((JNIEnvironment)jni);
            JNIObjectHandle appLoader = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)classLoader, (JNIMethodId)getAppLoader);
            Support.checkNoException((JNIEnvironment)jni);
            VMError.guarantee((platformLoader.notEqual((ComparableWord)JNIObjectHandles.nullHandle()) && appLoader.notEqual((ComparableWord)JNIObjectHandles.nullHandle()) ? 1 : 0) != 0);
            if (!Support.jniFunctions().getIsSameObject().invoke(jni, systemLoader, appLoader)) {
                builtinClassLoaders = new JNIObjectHandle[3];
                BreakpointInterceptor.builtinClassLoaders[2] = ((NativeImageAgentJNIHandleSet)agent.handles()).newTrackedGlobalRef(jni, appLoader);
            } else {
                builtinClassLoaders = new JNIObjectHandle[2];
            }
            BreakpointInterceptor.builtinClassLoaders[1] = ((NativeImageAgentJNIHandleSet)agent.handles()).newTrackedGlobalRef(jni, platformLoader);
        } else {
            VMError.guarantee((getPlatformLoader.isNull() && getAppLoader.isNull() ? 1 : 0) != 0);
            builtinClassLoaders = new JNIObjectHandle[1];
        }
        BreakpointInterceptor.builtinClassLoaders[0] = ((NativeImageAgentJNIHandleSet)agent.handles()).newTrackedGlobalRef(jni, systemLoader);
        Support.check((JvmtiError)jvmti.getFunctions().SetEventNotificationMode().invoke(jvmti, JvmtiEventMode.JVMTI_ENABLE, JvmtiEvent.JVMTI_EVENT_CLASS_FILE_LOAD_HOOK, (JNIObjectHandle)JNIObjectHandles.nullHandle()));
    }

    private static Breakpoint installBreakpoint(JNIEnvironment jni, BreakpointSpecification br, Map<Long, Breakpoint> map, JNIObjectHandle knownClass) {
        JNIObjectHandle clazz = knownClass;
        if (clazz.equal((ComparableWord)JNIObjectHandles.nullHandle()) && (clazz = BreakpointInterceptor.resolveBreakpointClass(jni, br.className, br.optional)).equal((ComparableWord)JNIObjectHandles.nullHandle())) {
            VMError.guarantee((boolean)br.optional);
            return null;
        }
        JNIMethodId method = BreakpointInterceptor.resolveBreakpointMethod(jni, clazz, br.methodName, br.signature, br.optional);
        JvmtiError result = Support.jvmtiFunctions().SetBreakpoint().invoke(Support.jvmtiEnv(), method, 0L);
        if (result != JvmtiError.JVMTI_ERROR_NONE) {
            VMError.guarantee((boolean)br.optional, (String)"Setting breakpoint failed");
            return null;
        }
        Breakpoint bp = new Breakpoint(br, clazz, method);
        if (map.put(method.rawValue(), bp) != null) {
            throw VMError.shouldNotReachHere((String)("Duplicate breakpoint: " + String.valueOf(bp)));
        }
        return bp;
    }

    private static JNIObjectHandle resolveBreakpointClass(JNIEnvironment jni, String className, boolean optional) {
        JNIObjectHandle clazz;
        try (CTypeConversion.CCharPointerHolder cname = Support.toCString((String)className);){
            clazz = Support.jniFunctions().getFindClass().invoke(jni, cname.get());
            if (optional && (Support.clearException((JNIEnvironment)jni) || clazz.equal((ComparableWord)JNIObjectHandles.nullHandle()))) {
                JNIObjectHandle jNIObjectHandle = (JNIObjectHandle)JNIObjectHandles.nullHandle();
                return jNIObjectHandle;
            }
            Support.checkNoException((JNIEnvironment)jni);
        }
        clazz = ((NativeImageAgentJNIHandleSet)agent.handles()).newTrackedGlobalRef(jni, clazz);
        Support.checkNoException((JNIEnvironment)jni);
        return clazz;
    }

    private static JNIMethodId resolveBreakpointMethod(JNIEnvironment jni, JNIObjectHandle clazz, String methodName, String signature, boolean optional) {
        JNIMethodId method;
        VMError.guarantee((boolean)clazz.notEqual((ComparableWord)JNIObjectHandles.nullHandle()));
        try (CTypeConversion.CCharPointerHolder cname = Support.toCString((String)methodName);
             CTypeConversion.CCharPointerHolder csignature = Support.toCString((String)signature);){
            method = Support.jniFunctions().getGetMethodID().invoke(jni, clazz, cname.get(), csignature.get());
            if (method.isNull()) {
                Support.clearException((JNIEnvironment)jni);
                method = Support.jniFunctions().getGetStaticMethodID().invoke(jni, clazz, cname.get(), csignature.get());
            }
        }
        if (optional && (Support.clearException((JNIEnvironment)jni) || method.isNull())) {
            return (JNIMethodId)WordFactory.nullPointer();
        }
        VMError.guarantee((!Support.testException((JNIEnvironment)jni) && method.isNonNull() ? 1 : 0) != 0);
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void bindNativeBreakpoint(JNIEnvironment jni, NativeBreakpoint bp, CodePointer originalAddress, WordPointer newAddressPtr) {
        assert (!recursive.get().booleanValue());
        bp.replacedFunction = originalAddress;
        CFunctionPointer breakpointMethod = ((NativeBreakpointSpecification)bp.specification).handlerLiteral.getFunctionPointer();
        if (newAddressPtr.isNonNull()) {
            newAddressPtr.write((WordBase)breakpointMethod);
        } else {
            recursive.set(true);
            try (CTypeConversion.CCharPointerHolder cname = Support.toCString((String)((NativeBreakpointSpecification)bp.specification).methodName);
                 CTypeConversion.CCharPointerHolder csignature = Support.toCString((String)((NativeBreakpointSpecification)bp.specification).signature);){
                JNINativeMethod nativeMethod = (JNINativeMethod)StackValue.get(JNINativeMethod.class);
                nativeMethod.setName(cname.get());
                nativeMethod.setSignature(csignature.get());
                nativeMethod.setFnPtr(breakpointMethod);
                Support.checkJni((int)jni.getFunctions().getRegisterNatives().invoke(jni, bp.clazz, nativeMethod, 1));
            }
            finally {
                recursive.set(false);
            }
        }
    }

    public static void onUnload() {
        builtinClassLoaders = null;
        installedBreakpoints = null;
        nativeBreakpoints = null;
        observedExplicitLoadClassCallSites = null;
        tracer = null;
    }

    private static boolean allocateInstance(JNIEnvironment jni, JNIObjectHandle thread, Breakpoint bp, InterceptedState state) {
        JNIObjectHandle callerClass = state.getDirectCallerClass();
        JNIObjectHandle clazz = Support.getObjectArgument((JNIObjectHandle)thread, (int)1);
        BreakpointInterceptor.traceAllocateInstance(jni, clazz, !Support.clearException((JNIEnvironment)jni), state, callerClass);
        return true;
    }

    private static BreakpointSpecification brk(String className, String methodName, String signature, BreakpointHandler handler) {
        return new BreakpointSpecification(className, methodName, signature, handler, false);
    }

    private static BreakpointSpecification optionalBrk(String className, String methodName, String signature, BreakpointHandler handler) {
        return new BreakpointSpecification(className, methodName, signature, handler, true);
    }

    private BreakpointInterceptor() {
    }

    static {
        experimentalClassLoaderSupport = false;
        experimentalClassDefineSupport = false;
        experimentalUnsafeAllocationSupport = false;
        trackReflectionMetadata = false;
        nativeBreakpointsInitLock = new ReentrantLock();
        recursive = ThreadLocal.withInitial(() -> Boolean.FALSE);
        nativeAllocateInstance = CEntryPointLiteral.create(BreakpointInterceptor.class, (String)"nativeAllocateInstance", (Class[])new Class[]{JNIEnvironment.class, JNIObjectHandle.class, JNIObjectHandle.class});
        NATIVE_ALLOCATE_INSTANCE_BREAKPOINT_SPEC = new NativeBreakpointSpecification("jdk/internal/misc/Unsafe", "allocateInstance", "(Ljava/lang/Class;)Ljava/lang/Object;", nativeAllocateInstance);
        onBreakpointLiteral = CEntryPointLiteral.create(BreakpointInterceptor.class, (String)"onBreakpoint", (Class[])new Class[]{JvmtiEnv.class, JNIEnvironment.class, JNIObjectHandle.class, JNIMethodId.class, Long.TYPE});
        onNativeMethodBindLiteral = CEntryPointLiteral.create(BreakpointInterceptor.class, (String)"onNativeMethodBind", (Class[])new Class[]{JvmtiEnv.class, JNIEnvironment.class, JNIObjectHandle.class, JNIMethodId.class, CodePointer.class, WordPointer.class});
        onClassPrepareLiteral = CEntryPointLiteral.create(BreakpointInterceptor.class, (String)"onClassPrepare", (Class[])new Class[]{JvmtiEnv.class, JNIEnvironment.class, JNIObjectHandle.class, JNIObjectHandle.class});
        onClassFileLoadHookLiteral = CEntryPointLiteral.create(BreakpointInterceptor.class, (String)"onClassFileLoadHook", (Class[])new Class[]{JvmtiEnv.class, JNIEnvironment.class, JNIObjectHandle.class, JNIObjectHandle.class, CCharPointer.class, JNIObjectHandle.class, Integer.TYPE, CCharPointer.class, CIntPointer.class, CCharPointerPointer.class});
        BREAKPOINT_SPECIFICATIONS = new BreakpointSpecification[]{BreakpointInterceptor.brk("java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;", BreakpointInterceptor::forName), BreakpointInterceptor.brk("java/lang/Class", "forName", "(Ljava/lang/String;ZLjava/lang/ClassLoader;)Ljava/lang/Class;", BreakpointInterceptor::forName), BreakpointInterceptor.brk("java/lang/Class", "getFields", "()[Ljava/lang/reflect/Field;", BreakpointInterceptor::getFields), BreakpointInterceptor.brk("java/lang/Class", "getClasses", "()[Ljava/lang/Class;", BreakpointInterceptor::getClasses), BreakpointInterceptor.brk("java/lang/Class", "getDeclaredFields", "()[Ljava/lang/reflect/Field;", BreakpointInterceptor::getDeclaredFields), BreakpointInterceptor.brk("java/lang/Class", "getDeclaredClasses", "()[Ljava/lang/Class;", BreakpointInterceptor::getDeclaredClasses), BreakpointInterceptor.brk("java/lang/Class", "getField", "(Ljava/lang/String;)Ljava/lang/reflect/Field;", BreakpointInterceptor::getField), BreakpointInterceptor.brk("java/lang/Class", "getDeclaredField", "(Ljava/lang/String;)Ljava/lang/reflect/Field;", BreakpointInterceptor::getDeclaredField), BreakpointInterceptor.brk("java/lang/Class", "getEnclosingMethod", "()Ljava/lang/reflect/Method;", BreakpointInterceptor::getEnclosingMethod), BreakpointInterceptor.brk("java/lang/Class", "getEnclosingConstructor", "()Ljava/lang/reflect/Constructor;", BreakpointInterceptor::getEnclosingMethod), BreakpointInterceptor.brk("java/lang/Class", "getMethods", "()[Ljava/lang/reflect/Method;", BreakpointInterceptor::getMethods), BreakpointInterceptor.brk("java/lang/Class", "getConstructors", "()[Ljava/lang/reflect/Constructor;", BreakpointInterceptor::getConstructors), BreakpointInterceptor.brk("java/lang/Class", "getDeclaredMethods", "()[Ljava/lang/reflect/Method;", BreakpointInterceptor::getDeclaredMethods), BreakpointInterceptor.brk("java/lang/Class", "getDeclaredConstructors", "()[Ljava/lang/reflect/Constructor;", BreakpointInterceptor::getDeclaredConstructors), BreakpointInterceptor.brk("java/lang/Class", "getMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", BreakpointInterceptor::getMethod), BreakpointInterceptor.brk("java/lang/Class", "getConstructor", "([Ljava/lang/Class;)Ljava/lang/reflect/Constructor;", BreakpointInterceptor::getConstructor), BreakpointInterceptor.brk("java/lang/Class", "getDeclaredMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", BreakpointInterceptor::getDeclaredMethod), BreakpointInterceptor.brk("java/lang/Class", "getDeclaredConstructor", "([Ljava/lang/Class;)Ljava/lang/reflect/Constructor;", BreakpointInterceptor::getConstructor), BreakpointInterceptor.brk("java/lang/Class", "newInstance", "()Ljava/lang/Object;", BreakpointInterceptor::newInstance), BreakpointInterceptor.brk("java/lang/reflect/Array", "newInstance", "(Ljava/lang/Class;I)Ljava/lang/Object;", BreakpointInterceptor::newArrayInstance), BreakpointInterceptor.brk("java/lang/reflect/Array", "newInstance", "(Ljava/lang/Class;[I)Ljava/lang/Object;", BreakpointInterceptor::newArrayInstanceMulti), BreakpointInterceptor.brk("java/lang/ClassLoader", "findSystemClass", "(Ljava/lang/String;)Ljava/lang/Class;", BreakpointInterceptor::findSystemClass), BreakpointInterceptor.brk("jdk/internal/loader/BuiltinClassLoader", "findResource", "(Ljava/lang/String;Ljava/lang/String;)Ljava/net/URL;", BreakpointInterceptor::findResource), BreakpointInterceptor.brk("jdk/internal/loader/BuiltinClassLoader", "findResourceAsStream", "(Ljava/lang/String;Ljava/lang/String;)Ljava/io/InputStream;", BreakpointInterceptor::findResource), BreakpointInterceptor.brk("jdk/internal/loader/Loader", "findResource", "(Ljava/lang/String;Ljava/lang/String;)Ljava/net/URL;", BreakpointInterceptor::findResource), BreakpointInterceptor.brk("java/lang/ClassLoader", "getResource", "(Ljava/lang/String;)Ljava/net/URL;", BreakpointInterceptor::getResource), BreakpointInterceptor.brk("java/lang/ClassLoader", "getResources", "(Ljava/lang/String;)Ljava/util/Enumeration;", BreakpointInterceptor::getResources), BreakpointInterceptor.brk("java/lang/ClassLoader", "getSystemResource", "(Ljava/lang/String;)Ljava/net/URL;", BreakpointInterceptor::getSystemResource), BreakpointInterceptor.brk("java/lang/ClassLoader", "getSystemResources", "(Ljava/lang/String;)Ljava/util/Enumeration;", BreakpointInterceptor::getSystemResources), BreakpointInterceptor.brk("java/lang/reflect/Proxy", "getProxyClass", "(Ljava/lang/ClassLoader;[Ljava/lang/Class;)Ljava/lang/Class;", BreakpointInterceptor::getProxyClass), BreakpointInterceptor.brk("java/lang/reflect/Proxy", "newProxyInstance", "(Ljava/lang/ClassLoader;[Ljava/lang/Class;Ljava/lang/reflect/InvocationHandler;)Ljava/lang/Object;", BreakpointInterceptor::newProxyInstance), BreakpointInterceptor.brk("java/lang/invoke/SerializedLambda", "readResolve", "()Ljava/lang/Object;", BreakpointInterceptor::serializedLambdaReadResolve), BreakpointInterceptor.brk("java/io/ObjectInputStream", "resolveClass", "(Ljava/io/ObjectStreamClass;)Ljava/lang/Class;", BreakpointInterceptor::readClassDescriptor), BreakpointInterceptor.brk("java/io/ObjectStreamClass", "<init>", "(Ljava/lang/Class;)V", BreakpointInterceptor::objectStreamClassConstructor), BreakpointInterceptor.brk("jdk/internal/reflect/ReflectionFactory", "newConstructorForSerialization", "(Ljava/lang/Class;Ljava/lang/reflect/Constructor;)Ljava/lang/reflect/Constructor;", BreakpointInterceptor::customTargetConstructorSerialization), BreakpointInterceptor.optionalBrk("java/util/ResourceBundle", "getBundleImpl", "(Ljava/lang/Module;Ljava/lang/Module;Ljava/lang/String;Ljava/util/Locale;Ljava/util/ResourceBundle$Control;)Ljava/util/ResourceBundle;", BreakpointInterceptor::getBundleImpl), BreakpointInterceptor.optionalBrk("jdk/internal/misc/Unsafe", "objectFieldOffset", "(Ljava/lang/Class;Ljava/lang/String;)J", BreakpointInterceptor::objectFieldOffsetByName), BreakpointInterceptor.brk("sun/misc/Unsafe", "allocateInstance", "(Ljava/lang/Class;)Ljava/lang/Object;", BreakpointInterceptor::allocateInstance), BreakpointInterceptor.optionalBrk("java/lang/invoke/MethodHandles$Lookup", "findStatic", "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/MethodHandle;", BreakpointInterceptor::findMethodHandle), BreakpointInterceptor.optionalBrk("java/lang/invoke/MethodHandles$Lookup", "findVirtual", "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/MethodHandle;", BreakpointInterceptor::findMethodHandle), BreakpointInterceptor.optionalBrk("java/lang/invoke/MethodHandles$Lookup", "findConstructor", "(Ljava/lang/Class;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/MethodHandle;", BreakpointInterceptor::findConstructorHandle), BreakpointInterceptor.optionalBrk("java/lang/invoke/MethodHandles$Lookup", "findSpecial", "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/Class;)Ljava/lang/invoke/MethodHandle;", BreakpointInterceptor::findSpecialHandle), BreakpointInterceptor.optionalBrk("java/lang/invoke/MethodHandles$Lookup", "bind", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/MethodHandle;", BreakpointInterceptor::bindHandle), BreakpointInterceptor.optionalBrk("java/lang/invoke/MethodHandles$Lookup", "findGetter", "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/invoke/MethodHandle;", BreakpointInterceptor::findFieldHandle), BreakpointInterceptor.optionalBrk("java/lang/invoke/MethodHandles$Lookup", "findSetter", "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/invoke/MethodHandle;", BreakpointInterceptor::findFieldHandle), BreakpointInterceptor.optionalBrk("java/lang/invoke/MethodHandles$Lookup", "findStaticGetter", "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/invoke/MethodHandle;", BreakpointInterceptor::findFieldHandle), BreakpointInterceptor.optionalBrk("java/lang/invoke/MethodHandles$Lookup", "findStaticSetter", "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/invoke/MethodHandle;", BreakpointInterceptor::findFieldHandle), BreakpointInterceptor.optionalBrk("java/lang/invoke/MethodHandles$Lookup", "findVarHandle", "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/invoke/VarHandle;", BreakpointInterceptor::findFieldHandle), BreakpointInterceptor.optionalBrk("java/lang/invoke/MethodHandles$Lookup", "findStaticVarHandle", "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/invoke/VarHandle;", BreakpointInterceptor::findFieldHandle), BreakpointInterceptor.optionalBrk("java/lang/invoke/MethodHandles$Lookup", "findClass", "(Ljava/lang/String;)Ljava/lang/Class;", BreakpointInterceptor::findClass), BreakpointInterceptor.optionalBrk("java/lang/invoke/MethodHandles$Lookup", "unreflect", "(Ljava/lang/reflect/Method;)Ljava/lang/invoke/MethodHandle;", BreakpointInterceptor::unreflectMethod), BreakpointInterceptor.optionalBrk("java/lang/invoke/MethodHandles$Lookup", "unreflectConstructor", "(Ljava/lang/reflect/Constructor;)Ljava/lang/invoke/MethodHandle;", BreakpointInterceptor::unreflectConstructor), BreakpointInterceptor.optionalBrk("java/lang/invoke/MethodHandles$Lookup", "unreflectGetter", "(Ljava/lang/reflect/Field;)Ljava/lang/invoke/MethodHandle;", BreakpointInterceptor::unreflectField), BreakpointInterceptor.optionalBrk("java/lang/invoke/MethodHandles$Lookup", "unreflectSetter", "(Ljava/lang/reflect/Field;)Ljava/lang/invoke/MethodHandle;", BreakpointInterceptor::unreflectField), BreakpointInterceptor.optionalBrk("java/lang/invoke/MethodHandleProxies", "asInterfaceInstance", "(Ljava/lang/Class;Ljava/lang/invoke/MethodHandle;)Ljava/lang/Object;", BreakpointInterceptor::asInterfaceInstance), BreakpointInterceptor.optionalBrk("java/lang/invoke/ConstantBootstraps", "getStaticFinal", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/Class;Ljava/lang/Class;)Ljava/lang/Object;", (jni, thread, bp, state) -> BreakpointInterceptor.constantBootstrapGetStaticFinal(jni, thread, bp, state, true)), BreakpointInterceptor.optionalBrk("java/lang/invoke/ConstantBootstraps", "getStaticFinal", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", (jni, thread, bp, state) -> BreakpointInterceptor.constantBootstrapGetStaticFinal(jni, thread, bp, state, false)), BreakpointInterceptor.optionalBrk("java/lang/invoke/MethodType", "fromMethodDescriptorString", "(Ljava/lang/String;Ljava/lang/ClassLoader;)Ljava/lang/invoke/MethodType;", BreakpointInterceptor::methodTypeFromDescriptor), BreakpointInterceptor.optionalBrk("java/lang/Class", "getRecordComponents", "()[Ljava/lang/reflect/RecordComponent;", BreakpointInterceptor::getRecordComponents), BreakpointInterceptor.optionalBrk("java/lang/Class", "getPermittedSubclasses", "()[Ljava/lang/Class;", BreakpointInterceptor::getPermittedSubclasses), BreakpointInterceptor.optionalBrk("java/lang/Class", "getNestMembers", "()[Ljava/lang/Class;", BreakpointInterceptor::getNestMembers), BreakpointInterceptor.optionalBrk("java/lang/Class", "getSigners", "()[Ljava/lang/Object;", BreakpointInterceptor::getSigners)};
        CLASSLOADER_LOAD_CLASS_BREAKPOINT_SPECIFICATION = BreakpointInterceptor.optionalBrk("java/lang/ClassLoader", "loadClass", "(Ljava/lang/String;)Ljava/lang/Class;", BreakpointInterceptor::loadClass);
        NATIVE_BREAKPOINT_SPECIFICATIONS = new NativeBreakpointSpecification[]{NATIVE_ALLOCATE_INSTANCE_BREAKPOINT_SPEC};
        REFLECTION_ACCESS_BREAKPOINT_SPECIFICATIONS = new BreakpointSpecification[]{BreakpointInterceptor.brk("java/lang/reflect/Method", "invoke", "(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;", BreakpointInterceptor::invokeMethod), BreakpointInterceptor.brk("sun/reflect/misc/MethodUtil", "invoke", "(Ljava/lang/reflect/Method;Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;", BreakpointInterceptor::invokeMethod), BreakpointInterceptor.brk("java/lang/reflect/Constructor", "newInstance", "([Ljava/lang/Object;)Ljava/lang/Object;", BreakpointInterceptor::invokeConstructor)};
        CLASS_PREDEFINITION_BREAKPOINT_SPECIFICATIONS = new BreakpointSpecification[]{BreakpointInterceptor.optionalBrk("java/lang/invoke/MethodHandles$Lookup$ClassFile", "<init>", "(Ljava/lang/String;I[B)V", BreakpointInterceptor::onMethodHandleClassFileInit)};
    }

    private static class Breakpoint
    extends AbstractBreakpoint<BreakpointSpecification> {
        Breakpoint(BreakpointSpecification specification, JNIObjectHandle clazz, JNIMethodId method) {
            super(specification, clazz, method);
        }
    }

    private static abstract class AbstractBreakpointSpecification {
        final String className;
        final String methodName;
        final String signature;
        final boolean optional;

        AbstractBreakpointSpecification(String className, String methodName, String signature, boolean optional) {
            this.className = className;
            this.methodName = methodName;
            this.signature = signature;
            this.optional = optional;
        }

        public String toString() {
            return this.className + ":" + this.methodName + this.signature + (this.optional ? " (optional)" : "");
        }
    }

    private static class BreakpointSpecification
    extends AbstractBreakpointSpecification {
        final BreakpointHandler handler;

        BreakpointSpecification(String className, String methodName, String signature, BreakpointHandler handler, boolean optional) {
            super(className, methodName, signature, optional);
            this.handler = handler;
        }
    }

    private static class NativeBreakpointSpecification
    extends AbstractBreakpointSpecification {
        final CEntryPointLiteral<?> handlerLiteral;
        NativeBreakpoint installed;

        NativeBreakpointSpecification(String className, String methodName, String signature, CEntryPointLiteral<?> handlerLiteral) {
            super(className, methodName, signature, true);
            this.handlerLiteral = handlerLiteral;
        }
    }

    private static final class NativeBreakpoint
    extends AbstractBreakpoint<NativeBreakpointSpecification> {
        CodePointer replacedFunction;

        NativeBreakpoint(NativeBreakpointSpecification specification, JNIObjectHandle clazz, JNIMethodId method) {
            super(specification, clazz, method);
            assert (specification.installed == null) : "must be installed exactly once";
            specification.installed = this;
        }
    }

    private static interface AllocateInstanceFunctionPointer
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public long invoke(JNIEnvironment var1, JNIObjectHandle var2, JNIObjectHandle var3);
    }

    private static final class MethodLocation {
        final JNIMethodId method;
        final int bci;

        MethodLocation(JNIMethodId method, int bci) {
            this.method = method;
            this.bci = bci;
        }

        public boolean equals(Object obj) {
            if (obj != this && obj instanceof MethodLocation) {
                MethodLocation other = (MethodLocation)obj;
                return this.method.equal((ComparableWord)other.method) && this.bci == other.bci;
            }
            return obj == this;
        }

        public int hashCode() {
            return 31 * Long.hashCode(this.method.rawValue()) + this.bci;
        }
    }

    private static interface BreakpointHandler {
        public boolean dispatch(JNIEnvironment var1, JNIObjectHandle var2, Breakpoint var3, InterceptedState var4);
    }

    private static abstract class AbstractBreakpoint<T extends AbstractBreakpointSpecification> {
        final T specification;
        final JNIObjectHandle clazz;
        final JNIMethodId method;

        AbstractBreakpoint(T specification, JNIObjectHandle clazz, JNIMethodId method) {
            this.specification = specification;
            this.clazz = clazz;
            this.method = method;
        }

        public String toString() {
            return ((AbstractBreakpointSpecification)this.specification).toString();
        }
    }
}

