/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.results;

import com.oracle.svm.util.ImageBuildStatistics;
import java.util.concurrent.atomic.AtomicLong;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.calc.ConditionalNode;
import jdk.graal.compiler.nodes.calc.IntegerEqualsNode;
import jdk.graal.compiler.nodes.calc.IntegerLowerThanNode;
import jdk.graal.compiler.nodes.calc.IsNullNode;
import jdk.graal.compiler.nodes.java.InstanceOfNode;
import jdk.graal.compiler.nodes.java.LoadFieldNode;
import jdk.graal.compiler.nodes.java.MethodCallTargetNode;

final class StrengthenGraphsCounters {
    private final AtomicLong[] values = new AtomicLong[Counter.values().length];

    StrengthenGraphsCounters(ImageBuildStatistics.CheckCountLocation location) {
        ImageBuildStatistics imageBuildStats = ImageBuildStatistics.counters();
        for (Counter counter : Counter.values()) {
            this.values[counter.ordinal()] = imageBuildStats.insert(String.valueOf(location) + "_" + counter.name());
        }
    }

    void collect(StructuredGraph graph) {
        int[] localValues = new int[Counter.values().length];
        StrengthenGraphsCounters.inc(localValues, Counter.METHOD);
        for (Node n : graph.getNodes()) {
            if (n instanceof AbstractBeginNode) {
                StrengthenGraphsCounters.inc(localValues, Counter.BLOCK);
                continue;
            }
            if (n instanceof ConstantNode) {
                StrengthenGraphsCounters.inc(localValues, Counter.CONSTANT);
                continue;
            }
            if (n instanceof LoadFieldNode) {
                StrengthenGraphsCounters.inc(localValues, Counter.LOAD_FIELD);
                continue;
            }
            if (n instanceof IfNode) {
                IfNode node = (IfNode)n;
                StrengthenGraphsCounters.collect(localValues, node.condition());
                continue;
            }
            if (n instanceof ConditionalNode) {
                ConditionalNode node = (ConditionalNode)n;
                StrengthenGraphsCounters.collect(localValues, node.condition());
                continue;
            }
            if (!(n instanceof MethodCallTargetNode)) continue;
            MethodCallTargetNode node = (MethodCallTargetNode)n;
            StrengthenGraphsCounters.collect(localValues, node.invokeKind());
        }
        for (int i = 0; i < localValues.length; ++i) {
            this.values[i].addAndGet(localValues[i]);
        }
    }

    private static void collect(int[] localValues, LogicNode condition) {
        if (condition instanceof IsNullNode) {
            StrengthenGraphsCounters.inc(localValues, Counter.IS_NULL);
        } else if (condition instanceof InstanceOfNode) {
            StrengthenGraphsCounters.inc(localValues, Counter.INSTANCE_OF);
        } else if (condition instanceof IntegerEqualsNode || condition instanceof IntegerLowerThanNode) {
            StrengthenGraphsCounters.inc(localValues, Counter.PRIM_CMP);
        }
    }

    private static void collect(int[] localValues, CallTargetNode.InvokeKind invokeKind) {
        switch (invokeKind) {
            case Static: {
                StrengthenGraphsCounters.inc(localValues, Counter.INVOKE_STATIC);
                break;
            }
            case Virtual: 
            case Interface: {
                StrengthenGraphsCounters.inc(localValues, Counter.INVOKE_INDIRECT);
                break;
            }
            case Special: {
                StrengthenGraphsCounters.inc(localValues, Counter.INVOKE_DIRECT);
                break;
            }
            default: {
                throw GraalError.shouldNotReachHereUnexpectedValue((Object)invokeKind);
            }
        }
    }

    private static void inc(int[] localValues, Counter counter) {
        int n = counter.ordinal();
        localValues[n] = localValues[n] + 1;
    }

    static enum Counter {
        METHOD,
        BLOCK,
        IS_NULL,
        INSTANCE_OF,
        PRIM_CMP,
        INVOKE_STATIC,
        INVOKE_DIRECT,
        INVOKE_INDIRECT,
        LOAD_FIELD,
        CONSTANT;

    }
}

