/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.infrastructure;

import com.oracle.graal.pointsto.constraints.UnresolvedElementException;
import com.oracle.graal.pointsto.infrastructure.ConstantPoolPatch;
import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.infrastructure.OriginalMethodProvider;
import com.oracle.graal.pointsto.infrastructure.ResolvedSignature;
import com.oracle.graal.pointsto.infrastructure.Universe;
import com.oracle.graal.pointsto.util.GraalAccess;
import java.util.List;
import java.util.stream.Collectors;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.debug.GraalError;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public class WrappedConstantPool
implements ConstantPool,
ConstantPoolPatch {
    protected final Universe universe;
    protected final ConstantPool wrapped;
    private final ResolvedJavaType defaultAccessingClass;

    public WrappedConstantPool(Universe universe, ConstantPool wrapped, ResolvedJavaType defaultAccessingClass) {
        this.universe = universe;
        this.wrapped = wrapped;
        this.defaultAccessingClass = defaultAccessingClass;
    }

    public int length() {
        return this.wrapped.length();
    }

    private JavaConstant lookupConstant(JavaConstant constant) {
        return this.universe.lookup(this.extractResolvedType(constant));
    }

    public JavaConstant extractResolvedType(JavaConstant constant) {
        SnippetReflectionProvider snippetReflection;
        Object object;
        if (constant != null && constant.getJavaKind().isObject() && !constant.isNull() && (object = (snippetReflection = GraalAccess.getOriginalSnippetReflection()).asObject(Object.class, constant)) instanceof ResolvedJavaType) {
            ResolvedJavaType resolvedJavaType = (ResolvedJavaType)object;
            return snippetReflection.forObject(OriginalClassProvider.getJavaClass((JavaType)resolvedJavaType));
        }
        return constant;
    }

    public void loadReferencedType(int cpi, int opcode, boolean initialize) {
        GraalError.guarantee((!initialize ? 1 : 0) != 0, (String)"Must not initialize classes");
        try {
            this.wrapped.loadReferencedType(cpi, opcode, initialize);
        }
        catch (Throwable ex) {
            Throwable cause = ex;
            if (cause instanceof BootstrapMethodError && cause.getCause() != null) {
                cause = cause.getCause();
            } else if (cause instanceof ExceptionInInitializerError && cause.getCause() != null) {
                cause = cause.getCause();
            }
            throw new UnresolvedElementException("Error loading a referenced type: " + cause.toString(), cause);
        }
    }

    public void loadReferencedType(int cpi, int opcode) {
        this.loadReferencedType(cpi, opcode, false);
    }

    public JavaField lookupField(int cpi, ResolvedJavaMethod method, int opcode) {
        return this.universe.lookupAllowUnresolved(this.wrapped.lookupField(cpi, OriginalMethodProvider.getOriginalMethod(method), opcode));
    }

    public JavaMethod lookupMethod(int cpi, int opcode) {
        return this.universe.lookupAllowUnresolved(this.wrapped.lookupMethod(cpi, opcode));
    }

    @Override
    public JavaMethod lookupMethod(int cpi, int opcode, ResolvedJavaMethod caller) {
        try {
            return this.universe.lookupAllowUnresolved(this.wrapped.lookupMethod(cpi, opcode, OriginalMethodProvider.getOriginalMethod(caller)));
        }
        catch (Throwable ex) {
            Throwable cause = ex;
            if (ex instanceof ExceptionInInitializerError && ex.getCause() != null) {
                cause = ex.getCause();
            }
            throw new UnresolvedElementException("Error loading a referenced type: " + cause.toString(), cause);
        }
    }

    public JavaType lookupType(int cpi, int opcode) {
        return this.universe.lookupAllowUnresolved(this.wrapped.lookupType(cpi, opcode));
    }

    public ResolvedSignature<?> lookupSignature(int cpi) {
        return this.universe.lookup(this.wrapped.lookupSignature(cpi), this.defaultAccessingClass);
    }

    public JavaConstant lookupAppendix(int cpi, int opcode) {
        return this.lookupConstant(this.wrapped.lookupAppendix(cpi, opcode));
    }

    public String lookupUtf8(int cpi) {
        return this.wrapped.lookupUtf8(cpi);
    }

    public Object lookupConstant(int cpi) {
        return this.lookupConstant(cpi, true);
    }

    @Override
    public Object lookupConstant(int cpi, boolean resolve) {
        Object con = this.wrapped.lookupConstant(cpi, resolve);
        if (con instanceof JavaType) {
            if (con instanceof ResolvedJavaType) {
                return this.universe.lookup((JavaType)((ResolvedJavaType)con));
            }
            return con;
        }
        if (con instanceof JavaConstant) {
            return this.lookupConstant((JavaConstant)con);
        }
        if (con == null && !resolve) {
            return null;
        }
        throw JVMCIError.unimplemented();
    }

    public JavaType lookupReferencedType(int index, int opcode) {
        return this.universe.lookupAllowUnresolved(this.wrapped.lookupReferencedType(index, opcode));
    }

    public ConstantPool.BootstrapMethodInvocation lookupBootstrapMethodInvocation(int cpi, int opcode) {
        ConstantPool.BootstrapMethodInvocation bootstrapMethodInvocation = this.wrapped.lookupBootstrapMethodInvocation(cpi, opcode);
        if (bootstrapMethodInvocation != null) {
            return new WrappedBootstrapMethodInvocation(bootstrapMethodInvocation);
        }
        return null;
    }

    public class WrappedBootstrapMethodInvocation
    implements ConstantPool.BootstrapMethodInvocation {
        private final ConstantPool.BootstrapMethodInvocation wrapped;

        public WrappedBootstrapMethodInvocation(ConstantPool.BootstrapMethodInvocation wrapped) {
            this.wrapped = wrapped;
        }

        public ResolvedJavaMethod getMethod() {
            return WrappedConstantPool.this.universe.lookup((JavaMethod)this.wrapped.getMethod());
        }

        public boolean isInvokeDynamic() {
            return this.wrapped.isInvokeDynamic();
        }

        public String getName() {
            return this.wrapped.getName();
        }

        public JavaConstant getType() {
            return WrappedConstantPool.this.lookupConstant(this.wrapped.getType());
        }

        public List<JavaConstant> getStaticArguments() {
            return this.wrapped.getStaticArguments().stream().map(WrappedConstantPool.this::lookupConstant).collect(Collectors.toList());
        }
    }
}

