/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow.builder;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.AlwaysEnabledPredicateFlow;
import com.oracle.graal.pointsto.flow.PredicateMergeFlow;
import com.oracle.graal.pointsto.flow.PrimitiveFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.typestate.PointsToStats;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import jdk.graal.compiler.phases.common.LazyValue;

public final class TypeFlowBuilder<T extends TypeFlow<?>> {
    private final Object source;
    private final Class<T> flowClass;
    private final LazyValue<T> lazyTypeFlowCreator;
    private final Set<TypeFlowBuilder<?>> useDependencies;
    private final Set<TypeFlowBuilder<?>> observerDependencies;
    private boolean buildingAnActualParameter;
    private boolean isMaterialized;
    private final Object predicate;

    public static <U extends TypeFlow<?>> TypeFlowBuilder<U> create(PointsToAnalysis bb, PointsToAnalysisMethod method, Object predicate, Object source, Class<U> clazz, Supplier<U> supplier) {
        TypeFlowBuilder<U> builder = new TypeFlowBuilder<U>(source, predicate, clazz, new LazyValue(supplier));
        assert (TypeFlowBuilder.checkForPrimitiveFlows(bb, clazz)) : "Primitive flow encountered without -H:+TrackPrimitiveValues: " + String.valueOf(clazz) + " in method " + method.getQualifiedName();
        assert (TypeFlowBuilder.checkPredicate(bb, clazz, predicate)) : "Null or invalid predicate " + String.valueOf(predicate) + "  encountered with -H:+UsePredicates: " + String.valueOf(clazz) + " in method " + method.getQualifiedName();
        PointsToStats.registerTypeFlowBuilder(bb, builder);
        return builder;
    }

    private static <U extends TypeFlow<?>> boolean checkForPrimitiveFlows(PointsToAnalysis bb, Class<U> clazz) {
        return bb.trackPrimitiveValues() || !PrimitiveFlow.class.isAssignableFrom(clazz);
    }

    private static boolean checkPredicate(PointsToAnalysis bb, Class<?> clazz, Object predicate) {
        if (!bb.usePredicates()) {
            assert (predicate == null) : "Predicates are disabled: " + String.valueOf(predicate);
            return true;
        }
        if (clazz == AlwaysEnabledPredicateFlow.class) {
            return predicate == null;
        }
        if (clazz == PredicateMergeFlow.class) {
            return predicate instanceof List;
        }
        return predicate instanceof TypeFlowBuilder;
    }

    private TypeFlowBuilder(Object source, Object predicate, Class<T> flowClass, LazyValue<T> creator) {
        this.flowClass = flowClass;
        this.source = source;
        this.lazyTypeFlowCreator = creator;
        this.useDependencies = new HashSet();
        this.observerDependencies = new HashSet();
        this.buildingAnActualParameter = false;
        this.isMaterialized = false;
        this.predicate = predicate;
    }

    public void markAsBuildingAnActualParameter() {
        this.buildingAnActualParameter = true;
    }

    public boolean isBuildingAnActualParameter() {
        return this.buildingAnActualParameter;
    }

    public boolean isMaterialized() {
        return this.isMaterialized;
    }

    public Class<T> getFlowClass() {
        return this.flowClass;
    }

    public Object getSource() {
        return this.source;
    }

    public void addUseDependency(TypeFlowBuilder<?> dependency) {
        this.useDependencies.add(dependency);
    }

    Collection<TypeFlowBuilder<?>> getUseDependencies() {
        return this.useDependencies;
    }

    public void addObserverDependency(TypeFlowBuilder<?> dependency) {
        this.observerDependencies.add(dependency);
    }

    Collection<TypeFlowBuilder<?>> getObserverDependencies() {
        return this.observerDependencies;
    }

    public Object getPredicate() {
        return this.predicate;
    }

    public T get() {
        TypeFlow value = (TypeFlow)this.lazyTypeFlowCreator.get();
        this.isMaterialized = true;
        return (T)value;
    }
}

