// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: GraalOptions.java
package jdk.graal.compiler.core.common;

import java.util.*;
import jdk.graal.compiler.options.*;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionStability;

public class GraalOptions_OptionDescriptors implements OptionDescriptors {
    @Override
    public OptionDescriptor get(String value) {
        switch (value) {
        // CheckStyle: stop line length check
        case "AlwaysInlineVTableStubs": {
            return OptionDescriptor.create(
                /*name*/ "AlwaysInlineVTableStubs",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "AlwaysInlineVTableStubs",
                /*option*/ GraalOptions.AlwaysInlineVTableStubs,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ArrayRegionEqualsConstantLimit": {
            return OptionDescriptor.create(
                /*name*/ "ArrayRegionEqualsConstantLimit",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "Evaluates array region equality checks at compile time if the receiver is a constant and the length of the array is less than this value.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "ArrayRegionEqualsConstantLimit",
                /*option*/ GraalOptions.ArrayRegionEqualsConstantLimit,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "AssemblyGCBarriers": {
            return OptionDescriptor.create(
                /*name*/ "AssemblyGCBarriers",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Use generated assembly for GC barriers if supported by the platform",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "AssemblyGCBarriers",
                /*option*/ GraalOptions.AssemblyGCBarriers,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "AssemblyGCBarriersSlowPathOnly": {
            return OptionDescriptor.create(
                /*name*/ "AssemblyGCBarriersSlowPathOnly",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Force use of slow path for assembly GC barriers. Intended for debugging only.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "AssemblyGCBarriersSlowPathOnly",
                /*option*/ GraalOptions.AssemblyGCBarriersSlowPathOnly,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ConditionalElimination": {
            return OptionDescriptor.create(
                /*name*/ "ConditionalElimination",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Eliminates redundant conditional expressions and statements where possible. This can improve performance because fewer logic instructions have to be executed.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "ConditionalElimination",
                /*option*/ GraalOptions.ConditionalElimination,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ConditionalEliminationMaxIterations": {
            return OptionDescriptor.create(
                /*name*/ "ConditionalEliminationMaxIterations",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "ConditionalEliminationMaxIterations",
                /*option*/ GraalOptions.ConditionalEliminationMaxIterations,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DeoptALot": {
            return OptionDescriptor.create(
                /*name*/ "DeoptALot",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "DeoptALot",
                /*option*/ GraalOptions.DeoptALot,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DeoptsToDisableOptimisticOptimization": {
            return OptionDescriptor.create(
                /*name*/ "DeoptsToDisableOptimisticOptimization",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "Specifies the number of deoptimizations allowed per compilation unit until optimistic optimizations are disabled.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "DeoptsToDisableOptimisticOptimization",
                /*option*/ GraalOptions.DeoptsToDisableOptimisticOptimization,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "EagerSnippets": {
            return OptionDescriptor.create(
                /*name*/ "EagerSnippets",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Eagerly construct extra snippet info.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "EagerSnippets",
                /*option*/ GraalOptions.EagerSnippets,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "EarlyGVN": {
            return OptionDescriptor.create(
                /*name*/ "EarlyGVN",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Performs early global value numbering on statements and expressions directly after parsing. This can clean up the intermediate representation and simplify later optimizations. ",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "EarlyGVN",
                /*option*/ GraalOptions.EarlyGVN,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "EarlyLICM": {
            return OptionDescriptor.create(
                /*name*/ "EarlyLICM",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Performs early loop-invariant code motion.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "EarlyLICM",
                /*option*/ GraalOptions.EarlyLICM,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "EmitStringSubstitutions": {
            return OptionDescriptor.create(
                /*name*/ "EmitStringSubstitutions",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Emits substitutions for String methods. This can improve performance because the compiler can use optimized intrinsics for certain string operations.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "EmitStringSubstitutions",
                /*option*/ GraalOptions.EmitStringSubstitutions,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "EscapeAnalysisIterations": {
            return OptionDescriptor.create(
                /*name*/ "EscapeAnalysisIterations",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "EscapeAnalysisIterations",
                /*option*/ GraalOptions.EscapeAnalysisIterations,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "EscapeAnalysisLoopCutoff": {
            return OptionDescriptor.create(
                /*name*/ "EscapeAnalysisLoopCutoff",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "EscapeAnalysisLoopCutoff",
                /*option*/ GraalOptions.EscapeAnalysisLoopCutoff,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "EscapeAnalyzeOnly": {
            return OptionDescriptor.create(
                /*name*/ "EscapeAnalyzeOnly",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "EscapeAnalyzeOnly",
                /*option*/ GraalOptions.EscapeAnalyzeOnly,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "FloatingDivNodes": {
            return OptionDescriptor.create(
                /*name*/ "FloatingDivNodes",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Try to float non-constant division operations to expose global value numbering of divisions.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "FloatingDivNodes",
                /*option*/ GraalOptions.FloatingDivNodes,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "FullUnroll": {
            return OptionDescriptor.create(
                /*name*/ "FullUnroll",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Performs loop unrolling optimization. ",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "FullUnroll",
                /*option*/ GraalOptions.FullUnroll,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "GCDebugStartCycle": {
            return OptionDescriptor.create(
                /*name*/ "GCDebugStartCycle",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Start tracing compiled GC barriers after N garbage collections (disabled if N <= 0).",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "GCDebugStartCycle",
                /*option*/ GraalOptions.GCDebugStartCycle,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "GenLoopSafepoints": {
            return OptionDescriptor.create(
                /*name*/ "GenLoopSafepoints",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "GenLoopSafepoints",
                /*option*/ GraalOptions.GenLoopSafepoints,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "GuardPriorities": {
            return OptionDescriptor.create(
                /*name*/ "GuardPriorities",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "GuardPriorities",
                /*option*/ GraalOptions.GuardPriorities,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "HotSpotPrintInlining": {
            return OptionDescriptor.create(
                /*name*/ "HotSpotPrintInlining",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print inlining optimizations",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "HotSpotPrintInlining",
                /*option*/ GraalOptions.HotSpotPrintInlining,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InlineEverything": {
            return OptionDescriptor.create(
                /*name*/ "InlineEverything",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "InlineEverything",
                /*option*/ GraalOptions.InlineEverything,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InlineGraalStubs": {
            return OptionDescriptor.create(
                /*name*/ "InlineGraalStubs",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Embeds all the emitted code for Graal-generated stubs.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "InlineGraalStubs",
                /*option*/ GraalOptions.InlineGraalStubs,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InlineMegamorphicCalls": {
            return OptionDescriptor.create(
                /*name*/ "InlineMegamorphicCalls",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Inline calls with megamorphic type profile (i.e., not all types could be recorded).",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "InlineMegamorphicCalls",
                /*option*/ GraalOptions.InlineMegamorphicCalls,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InlineMonomorphicCalls": {
            return OptionDescriptor.create(
                /*name*/ "InlineMonomorphicCalls",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Inline calls with monomorphic type profile.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "InlineMonomorphicCalls",
                /*option*/ GraalOptions.InlineMonomorphicCalls,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InlinePolymorphicCalls": {
            return OptionDescriptor.create(
                /*name*/ "InlinePolymorphicCalls",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Inline calls with polymorphic type profile.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "InlinePolymorphicCalls",
                /*option*/ GraalOptions.InlinePolymorphicCalls,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InlineVTableStubs": {
            return OptionDescriptor.create(
                /*name*/ "InlineVTableStubs",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Inlines the vtable stub for method dispatch during inlining.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "InlineVTableStubs",
                /*option*/ GraalOptions.InlineVTableStubs,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "Intrinsify": {
            return OptionDescriptor.create(
                /*name*/ "Intrinsify",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Uses compiler intrinsifications.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "Intrinsify",
                /*option*/ GraalOptions.Intrinsify,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "IsolatedLoopHeaderAlignment": {
            return OptionDescriptor.create(
                /*name*/ "IsolatedLoopHeaderAlignment",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Alignment in bytes for loop header blocks that have no fall through paths.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "IsolatedLoopHeaderAlignment",
                /*option*/ GraalOptions.IsolatedLoopHeaderAlignment,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "LimitInlinedInvokes": {
            return OptionDescriptor.create(
                /*name*/ "LimitInlinedInvokes",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Double.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "LimitInlinedInvokes",
                /*option*/ GraalOptions.LimitInlinedInvokes,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "LoopHeaderAlignment": {
            return OptionDescriptor.create(
                /*name*/ "LoopHeaderAlignment",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "Specifies the alignment in bytes for loop header blocks.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "LoopHeaderAlignment",
                /*option*/ GraalOptions.LoopHeaderAlignment,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "LoopMaxUnswitch": {
            return OptionDescriptor.create(
                /*name*/ "LoopMaxUnswitch",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "LoopMaxUnswitch",
                /*option*/ GraalOptions.LoopMaxUnswitch,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "LoopPeeling": {
            return OptionDescriptor.create(
                /*name*/ "LoopPeeling",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Performs loop peeling optimization.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "LoopPeeling",
                /*option*/ GraalOptions.LoopPeeling,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "LoopPredication": {
            return OptionDescriptor.create(
                /*name*/ "LoopPredication",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Hoists array bounds checks out of simple loops. This is ignored if SpeculativeGuardMovement is enabled.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "LoopPredication",
                /*option*/ GraalOptions.LoopPredication,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "LoopPredicationMainPath": {
            return OptionDescriptor.create(
                /*name*/ "LoopPredicationMainPath",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Restricts LoopPredication to only focus on array bounds checks that dominate the back edge of a loop.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "LoopPredicationMainPath",
                /*option*/ GraalOptions.LoopPredicationMainPath,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "LoopUnswitch": {
            return OptionDescriptor.create(
                /*name*/ "LoopUnswitch",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Performs loop unswitching optimization.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "LoopUnswitch",
                /*option*/ GraalOptions.LoopUnswitch,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MatchExpressions": {
            return OptionDescriptor.create(
                /*name*/ "MatchExpressions",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Allow backend to match complex expressions.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "MatchExpressions",
                /*option*/ GraalOptions.MatchExpressions,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaximumDesiredSize": {
            return OptionDescriptor.create(
                /*name*/ "MaximumDesiredSize",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Maximum desired size of the compiler graph in nodes.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "MaximumDesiredSize",
                /*option*/ GraalOptions.MaximumDesiredSize,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaximumEscapeAnalysisArrayLength": {
            return OptionDescriptor.create(
                /*name*/ "MaximumEscapeAnalysisArrayLength",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "Specifies the maximum length of an array that will be escape analyzed.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "MaximumEscapeAnalysisArrayLength",
                /*option*/ GraalOptions.MaximumEscapeAnalysisArrayLength,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaximumInliningSize": {
            return OptionDescriptor.create(
                /*name*/ "MaximumInliningSize",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "Specifies the maximum graph size (measured in nodes) for which inlining is explored for each call site.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "MaximumInliningSize",
                /*option*/ GraalOptions.MaximumInliningSize,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaximumRecursiveInlining": {
            return OptionDescriptor.create(
                /*name*/ "MaximumRecursiveInlining",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "Specifies the maximum level of recursive inlining.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "MaximumRecursiveInlining",
                /*option*/ GraalOptions.MaximumRecursiveInlining,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MegamorphicInliningMinMethodProbability": {
            return OptionDescriptor.create(
                /*name*/ "MegamorphicInliningMinMethodProbability",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Double.class,
                /*help*/ "Minimum probability for methods to be inlined for megamorphic type profiles.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "MegamorphicInliningMinMethodProbability",
                /*option*/ GraalOptions.MegamorphicInliningMinMethodProbability,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MinimalBulkZeroingSize": {
            return OptionDescriptor.create(
                /*name*/ "MinimalBulkZeroingSize",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "If applicable, uses bulk zeroing instructions when the zeroing size in bytes exceeds this threshold.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "MinimalBulkZeroingSize",
                /*option*/ GraalOptions.MinimalBulkZeroingSize,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MinimumPeelFrequency": {
            return OptionDescriptor.create(
                /*name*/ "MinimumPeelFrequency",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Float.class,
                /*help*/ "Minimum frequency a loop must have to be considered for loop peeling.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "MinimumPeelFrequency",
                /*option*/ GraalOptions.MinimumPeelFrequency,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "OmitHotExceptionStacktrace": {
            return OptionDescriptor.create(
                /*name*/ "OmitHotExceptionStacktrace",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "OmitHotExceptionStacktrace",
                /*option*/ GraalOptions.OmitHotExceptionStacktrace,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "OptAssumptions": {
            return OptionDescriptor.create(
                /*name*/ "OptAssumptions",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Uses assumptions during compilation that may later be invalidated and cause code to be deoptimized.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "OptAssumptions",
                /*option*/ GraalOptions.OptAssumptions,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "OptConvertDeoptsToGuards": {
            return OptionDescriptor.create(
                /*name*/ "OptConvertDeoptsToGuards",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Replaces deoptimization points with movable guards where possible. This can help the optimizer to apply better code movement optimizations.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "OptConvertDeoptsToGuards",
                /*option*/ GraalOptions.OptConvertDeoptsToGuards,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "OptDeoptimizationGrouping": {
            return OptionDescriptor.create(
                /*name*/ "OptDeoptimizationGrouping",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "OptDeoptimizationGrouping",
                /*option*/ GraalOptions.OptDeoptimizationGrouping,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "OptDevirtualizeInvokesOptimistically": {
            return OptionDescriptor.create(
                /*name*/ "OptDevirtualizeInvokesOptimistically",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "OptDevirtualizeInvokesOptimistically",
                /*option*/ GraalOptions.OptDevirtualizeInvokesOptimistically,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "OptEliminateGuards": {
            return OptionDescriptor.create(
                /*name*/ "OptEliminateGuards",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "OptEliminateGuards",
                /*option*/ GraalOptions.OptEliminateGuards,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "OptFloatingReads": {
            return OptionDescriptor.create(
                /*name*/ "OptFloatingReads",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Performs floating-read optimization. This enables memory read operations to freely move in control-flow while respecting memory (anti)-dependencies. This helps to reduce memory accesses and can improve performance. ",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "OptFloatingReads",
                /*option*/ GraalOptions.OptFloatingReads,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "OptImplicitNullChecks": {
            return OptionDescriptor.create(
                /*name*/ "OptImplicitNullChecks",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Uses trapping null checks where possible to reduce explicit control flow for null checks. This can improve performance because explicit null checks do not have to be performed.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "OptImplicitNullChecks",
                /*option*/ GraalOptions.OptImplicitNullChecks,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "OptReadElimination": {
            return OptionDescriptor.create(
                /*name*/ "OptReadElimination",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Tries to remove redundant memory accesses (for example, successive reads of a non-volatile Java field).",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "OptReadElimination",
                /*option*/ GraalOptions.OptReadElimination,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "OptScheduleOutOfLoops": {
            return OptionDescriptor.create(
                /*name*/ "OptScheduleOutOfLoops",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "OptScheduleOutOfLoops",
                /*option*/ GraalOptions.OptScheduleOutOfLoops,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "OptimizeDiv": {
            return OptionDescriptor.create(
                /*name*/ "OptimizeDiv",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Optimize integer division operation by using various mathematical foundations to  express it in faster, equivalent, arithmetic.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "OptimizeDiv",
                /*option*/ GraalOptions.OptimizeDiv,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "OptimizeLongJumps": {
            return OptionDescriptor.create(
                /*name*/ "OptimizeLongJumps",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "AMD64 only: Replace forward jumps (jmp, jcc) with equivalent but smaller instructions if the actual jump displacement fits in one byte.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "OptimizeLongJumps",
                /*option*/ GraalOptions.OptimizeLongJumps,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PartialEscapeAnalysis": {
            return OptionDescriptor.create(
                /*name*/ "PartialEscapeAnalysis",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Performs partial escape analysis and scalar replacement optimization.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "PartialEscapeAnalysis",
                /*option*/ GraalOptions.PartialEscapeAnalysis,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PartialUnroll": {
            return OptionDescriptor.create(
                /*name*/ "PartialUnroll",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Performs partial loop unrolling optimizations. This is a special form of loop unrolling that splits a loop into a main and a post loop. The main loop can then be unrolled by a fixed amount of iterations. The post-loop performs any necessary fixup iterations. This can improve performance because the loop control overhead is reduced in the unrolled version.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "PartialUnroll",
                /*option*/ GraalOptions.PartialUnroll,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PreferUnsignedComparison": {
            return OptionDescriptor.create(
                /*name*/ "PreferUnsignedComparison",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Rewrite signed comparisons to unsigned ones if the result is equal.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "PreferUnsignedComparison",
                /*option*/ GraalOptions.PreferUnsignedComparison,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintProfilingInformation": {
            return OptionDescriptor.create(
                /*name*/ "PrintProfilingInformation",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print profiling information when parsing a method's bytecode",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "PrintProfilingInformation",
                /*option*/ GraalOptions.PrintProfilingInformation,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "RawConditionalElimination": {
            return OptionDescriptor.create(
                /*name*/ "RawConditionalElimination",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "RawConditionalElimination",
                /*option*/ GraalOptions.RawConditionalElimination,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ReadEliminationMaxLoopVisits": {
            return OptionDescriptor.create(
                /*name*/ "ReadEliminationMaxLoopVisits",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "ReadEliminationMaxLoopVisits",
                /*option*/ GraalOptions.ReadEliminationMaxLoopVisits,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ReassociateExpressions": {
            return OptionDescriptor.create(
                /*name*/ "ReassociateExpressions",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Reassociates loop invariants and constants.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "ReassociateExpressions",
                /*option*/ GraalOptions.ReassociateExpressions,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ReduceCodeSize": {
            return OptionDescriptor.create(
                /*name*/ "ReduceCodeSize",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "ReduceCodeSize",
                /*option*/ GraalOptions.ReduceCodeSize,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "RegisterPressure": {
            return OptionDescriptor.create(
                /*name*/ "RegisterPressure",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Comma separated list of registers that register allocation is limited to.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "RegisterPressure",
                /*option*/ GraalOptions.RegisterPressure,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "RemoveNeverExecutedCode": {
            return OptionDescriptor.create(
                /*name*/ "RemoveNeverExecutedCode",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Uses deoptimization to prune branches of code in the generated code that have never been executed by the interpreter.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "RemoveNeverExecutedCode",
                /*option*/ GraalOptions.RemoveNeverExecutedCode,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ReplaceInputsWithConstantsBasedOnStamps": {
            return OptionDescriptor.create(
                /*name*/ "ReplaceInputsWithConstantsBasedOnStamps",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "ReplaceInputsWithConstantsBasedOnStamps",
                /*option*/ GraalOptions.ReplaceInputsWithConstantsBasedOnStamps,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SmallCompiledLowLevelGraphSize": {
            return OptionDescriptor.create(
                /*name*/ "SmallCompiledLowLevelGraphSize",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "If the previous low-level graph size of the method exceeds the threshold, it is not inlined.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "SmallCompiledLowLevelGraphSize",
                /*option*/ GraalOptions.SmallCompiledLowLevelGraphSize,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SnippetCounters": {
            return OptionDescriptor.create(
                /*name*/ "SnippetCounters",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable counters for various paths in snippets.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "SnippetCounters",
                /*option*/ GraalOptions.SnippetCounters,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SpeculativeGuardMovement": {
            return OptionDescriptor.create(
                /*name*/ "SpeculativeGuardMovement",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Moves loop invariant guards (for example, array bounds checks) out of loops.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "SpeculativeGuardMovement",
                /*option*/ GraalOptions.SpeculativeGuardMovement,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "StressExplicitExceptionCode": {
            return OptionDescriptor.create(
                /*name*/ "StressExplicitExceptionCode",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Stress the code emitting explicit exception throwing code.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "StressExplicitExceptionCode",
                /*option*/ GraalOptions.StressExplicitExceptionCode,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "StressInvokeWithExceptionNode": {
            return OptionDescriptor.create(
                /*name*/ "StressInvokeWithExceptionNode",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Stress the code emitting invokes with explicit exception edges.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "StressInvokeWithExceptionNode",
                /*option*/ GraalOptions.StressInvokeWithExceptionNode,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "StressTestEarlyReads": {
            return OptionDescriptor.create(
                /*name*/ "StressTestEarlyReads",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Stress the code by emitting reads at earliest instead of latest point.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "StressTestEarlyReads",
                /*option*/ GraalOptions.StressTestEarlyReads,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "StrictDeoptInsertionChecks": {
            return OptionDescriptor.create(
                /*name*/ "StrictDeoptInsertionChecks",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Perform checks that guards and deopts aren't introduced in graphs that should handle exceptions explicitly",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "StrictDeoptInsertionChecks",
                /*option*/ GraalOptions.StrictDeoptInsertionChecks,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "StringIndexOfConstantLimit": {
            return OptionDescriptor.create(
                /*name*/ "StringIndexOfConstantLimit",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "Invocations of String.indexOf are evaluated at compile time if the receiver is a constant and its length is less than this value.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "StringIndexOfConstantLimit",
                /*option*/ GraalOptions.StringIndexOfConstantLimit,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SupportJsrBytecodes": {
            return OptionDescriptor.create(
                /*name*/ "SupportJsrBytecodes",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "SupportJsrBytecodes",
                /*option*/ GraalOptions.SupportJsrBytecodes,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TraceEscapeAnalysis": {
            return OptionDescriptor.create(
                /*name*/ "TraceEscapeAnalysis",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "TraceEscapeAnalysis",
                /*option*/ GraalOptions.TraceEscapeAnalysis,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TraceInlining": {
            return OptionDescriptor.create(
                /*name*/ "TraceInlining",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable tracing of inlining decisions.",
                /*extraHelp*/ new String[] {
                         "Output format:",
                         "  compilation of 'Signature of the compilation root method':",
                         "    at 'Signature of the root method' ['Bytecode index']: <'Phase'> 'Child method signature': 'Decision made about this callsite'",
                         "      at 'Signature of the child method' ['Bytecode index']: ",
                         "         |--<'Phase 1'> 'Grandchild method signature': 'First decision made about this callsite'",
                         "         \\--<'Phase 2'> 'Grandchild method signature': 'Second decision made about this callsite'",
                         "      at 'Signature of the child method' ['Bytecode index']: <'Phase'> 'Another grandchild method signature': 'The only decision made about this callsite.'",
                              },
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "TraceInlining",
                /*option*/ GraalOptions.TraceInlining,
                /*stability*/ OptionStability.STABLE,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TraceInliningForStubsAndSnippets": {
            return OptionDescriptor.create(
                /*name*/ "TraceInliningForStubsAndSnippets",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable inlining decision tracing in stubs and snippets.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "TraceInliningForStubsAndSnippets",
                /*option*/ GraalOptions.TraceInliningForStubsAndSnippets,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TrackNodeInsertion": {
            return OptionDescriptor.create(
                /*name*/ "TrackNodeInsertion",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Track source stack trace where a node was inserted into the graph.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "TrackNodeInsertion",
                /*option*/ GraalOptions.TrackNodeInsertion,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TrackNodeSourcePosition": {
            return OptionDescriptor.create(
                /*name*/ "TrackNodeSourcePosition",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Track the NodeSourcePosition.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "TrackNodeSourcePosition",
                /*option*/ GraalOptions.TrackNodeSourcePosition,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TrivialInliningSize": {
            return OptionDescriptor.create(
                /*name*/ "TrivialInliningSize",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "Specifies the size of a graph (counted in nodes) that is considered trivial. Graphs with fewer than this number of nodes are therefore always inlined.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "TrivialInliningSize",
                /*option*/ GraalOptions.TrivialInliningSize,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UseExceptionProbability": {
            return OptionDescriptor.create(
                /*name*/ "UseExceptionProbability",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "UseExceptionProbability",
                /*option*/ GraalOptions.UseExceptionProbability,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UseLoopLimitChecks": {
            return OptionDescriptor.create(
                /*name*/ "UseLoopLimitChecks",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "UseLoopLimitChecks",
                /*option*/ GraalOptions.UseLoopLimitChecks,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UseSnippetGraphCache": {
            return OptionDescriptor.create(
                /*name*/ "UseSnippetGraphCache",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Use a cache for snippet graphs.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "UseSnippetGraphCache",
                /*option*/ GraalOptions.UseSnippetGraphCache,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UseTypeCheckHints": {
            return OptionDescriptor.create(
                /*name*/ "UseTypeCheckHints",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "UseTypeCheckHints",
                /*option*/ GraalOptions.UseTypeCheckHints,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "VerifyAssemblyGCBarriers": {
            return OptionDescriptor.create(
                /*name*/ "VerifyAssemblyGCBarriers",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Verify oops processed by GC barriers",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "VerifyAssemblyGCBarriers",
                /*option*/ GraalOptions.VerifyAssemblyGCBarriers,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "VerifyHeapAtReturn": {
            return OptionDescriptor.create(
                /*name*/ "VerifyHeapAtReturn",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Perform platform dependent validation of the Java heap at returns",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "VerifyHeapAtReturn",
                /*option*/ GraalOptions.VerifyHeapAtReturn,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "VerifyPhases": {
            return OptionDescriptor.create(
                /*name*/ "VerifyPhases",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "VerifyPhases",
                /*option*/ GraalOptions.VerifyPhases,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ZapStackOnMethodEntry": {
            return OptionDescriptor.create(
                /*name*/ "ZapStackOnMethodEntry",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "ZapStackOnMethodEntry",
                /*option*/ GraalOptions.ZapStackOnMethodEntry,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 90;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("AlwaysInlineVTableStubs");
                    case 1: return get("ArrayRegionEqualsConstantLimit");
                    case 2: return get("AssemblyGCBarriers");
                    case 3: return get("AssemblyGCBarriersSlowPathOnly");
                    case 4: return get("ConditionalElimination");
                    case 5: return get("ConditionalEliminationMaxIterations");
                    case 6: return get("DeoptALot");
                    case 7: return get("DeoptsToDisableOptimisticOptimization");
                    case 8: return get("EagerSnippets");
                    case 9: return get("EarlyGVN");
                    case 10: return get("EarlyLICM");
                    case 11: return get("EmitStringSubstitutions");
                    case 12: return get("EscapeAnalysisIterations");
                    case 13: return get("EscapeAnalysisLoopCutoff");
                    case 14: return get("EscapeAnalyzeOnly");
                    case 15: return get("FloatingDivNodes");
                    case 16: return get("FullUnroll");
                    case 17: return get("GCDebugStartCycle");
                    case 18: return get("GenLoopSafepoints");
                    case 19: return get("GuardPriorities");
                    case 20: return get("HotSpotPrintInlining");
                    case 21: return get("InlineEverything");
                    case 22: return get("InlineGraalStubs");
                    case 23: return get("InlineMegamorphicCalls");
                    case 24: return get("InlineMonomorphicCalls");
                    case 25: return get("InlinePolymorphicCalls");
                    case 26: return get("InlineVTableStubs");
                    case 27: return get("Intrinsify");
                    case 28: return get("IsolatedLoopHeaderAlignment");
                    case 29: return get("LimitInlinedInvokes");
                    case 30: return get("LoopHeaderAlignment");
                    case 31: return get("LoopMaxUnswitch");
                    case 32: return get("LoopPeeling");
                    case 33: return get("LoopPredication");
                    case 34: return get("LoopPredicationMainPath");
                    case 35: return get("LoopUnswitch");
                    case 36: return get("MatchExpressions");
                    case 37: return get("MaximumDesiredSize");
                    case 38: return get("MaximumEscapeAnalysisArrayLength");
                    case 39: return get("MaximumInliningSize");
                    case 40: return get("MaximumRecursiveInlining");
                    case 41: return get("MegamorphicInliningMinMethodProbability");
                    case 42: return get("MinimalBulkZeroingSize");
                    case 43: return get("MinimumPeelFrequency");
                    case 44: return get("OmitHotExceptionStacktrace");
                    case 45: return get("OptAssumptions");
                    case 46: return get("OptConvertDeoptsToGuards");
                    case 47: return get("OptDeoptimizationGrouping");
                    case 48: return get("OptDevirtualizeInvokesOptimistically");
                    case 49: return get("OptEliminateGuards");
                    case 50: return get("OptFloatingReads");
                    case 51: return get("OptImplicitNullChecks");
                    case 52: return get("OptReadElimination");
                    case 53: return get("OptScheduleOutOfLoops");
                    case 54: return get("OptimizeDiv");
                    case 55: return get("OptimizeLongJumps");
                    case 56: return get("PartialEscapeAnalysis");
                    case 57: return get("PartialUnroll");
                    case 58: return get("PreferUnsignedComparison");
                    case 59: return get("PrintProfilingInformation");
                    case 60: return get("RawConditionalElimination");
                    case 61: return get("ReadEliminationMaxLoopVisits");
                    case 62: return get("ReassociateExpressions");
                    case 63: return get("ReduceCodeSize");
                    case 64: return get("RegisterPressure");
                    case 65: return get("RemoveNeverExecutedCode");
                    case 66: return get("ReplaceInputsWithConstantsBasedOnStamps");
                    case 67: return get("SmallCompiledLowLevelGraphSize");
                    case 68: return get("SnippetCounters");
                    case 69: return get("SpeculativeGuardMovement");
                    case 70: return get("StressExplicitExceptionCode");
                    case 71: return get("StressInvokeWithExceptionNode");
                    case 72: return get("StressTestEarlyReads");
                    case 73: return get("StrictDeoptInsertionChecks");
                    case 74: return get("StringIndexOfConstantLimit");
                    case 75: return get("SupportJsrBytecodes");
                    case 76: return get("TraceEscapeAnalysis");
                    case 77: return get("TraceInlining");
                    case 78: return get("TraceInliningForStubsAndSnippets");
                    case 79: return get("TrackNodeInsertion");
                    case 80: return get("TrackNodeSourcePosition");
                    case 81: return get("TrivialInliningSize");
                    case 82: return get("UseExceptionProbability");
                    case 83: return get("UseLoopLimitChecks");
                    case 84: return get("UseSnippetGraphCache");
                    case 85: return get("UseTypeCheckHints");
                    case 86: return get("VerifyAssemblyGCBarriers");
                    case 87: return get("VerifyHeapAtReturn");
                    case 88: return get("VerifyPhases");
                    case 89: return get("ZapStackOnMethodEntry");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
