/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.agent.tracing;

import com.oracle.svm.agent.tracing.core.Tracer;
import com.oracle.svm.agent.tracing.core.TracingResultWriter;
import com.oracle.svm.configure.config.ConfigurationSet;
import com.oracle.svm.configure.trace.TraceProcessor;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;

public class ConfigurationResultWriter
extends Tracer
implements TracingResultWriter {
    private final TraceProcessor processor;
    private final ConfigurationSet configuration;
    private final ConfigurationSet omittedConfiguration;

    public ConfigurationResultWriter(TraceProcessor processor, ConfigurationSet configuration, ConfigurationSet omittedConfiguration) {
        this.processor = processor;
        this.configuration = configuration;
        this.omittedConfiguration = omittedConfiguration;
    }

    @Override
    protected void traceEntry(EconomicMap<String, Object> entry) {
        this.processor.processEntry(ConfigurationResultWriter.arraysToLists(entry), this.configuration);
    }

    public static EconomicMap<String, Object> arraysToLists(EconomicMap<String, Object> map) {
        MapCursor cursor = map.getEntries();
        while (cursor.advance()) {
            if (!(cursor.getValue() instanceof Object[])) continue;
            cursor.setValue(ConfigurationResultWriter.arraysToLists((Object[])cursor.getValue()));
        }
        return map;
    }

    private static List<?> arraysToLists(Object[] array) {
        Object[] newArray = Arrays.copyOf(array, array.length);
        for (int i = 0; i < newArray.length; ++i) {
            if (!(newArray[i] instanceof Object[])) continue;
            newArray[i] = ConfigurationResultWriter.arraysToLists((Object[])newArray[i]);
        }
        return Arrays.asList(newArray);
    }

    @Override
    public boolean supportsPeriodicTraceWriting() {
        return true;
    }

    @Override
    public boolean supportsOnUnloadTraceWriting() {
        return true;
    }

    @Override
    public List<Path> writeToDirectory(Path directoryPath) throws IOException {
        ConfigurationSet finalConfiguration = this.configuration.copyAndSubtract(this.omittedConfiguration);
        return finalConfiguration.writeConfiguration(configFile -> directoryPath.resolve(configFile.getFileName()));
    }
}

