/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.typestore;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.ArrayElementsTypeFlow;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.typestore.ArrayElementsTypeStore;

public class SplitArrayElementsTypeStore
extends ArrayElementsTypeStore {
    private final ArrayElementsTypeFlow writeFlow;
    private final ArrayElementsTypeFlow readFlow;

    public SplitArrayElementsTypeStore(AnalysisObject object) {
        super(object);
        this.writeFlow = new ArrayElementsTypeFlow(object);
        this.readFlow = new ArrayElementsTypeFlow(object);
    }

    @Override
    public ArrayElementsTypeFlow writeFlow() {
        return this.writeFlow;
    }

    @Override
    public ArrayElementsTypeFlow readFlow() {
        return this.readFlow;
    }

    @Override
    public void init(PointsToAnalysis bb) {
        this.writeFlow.addUse(bb, this.readFlow);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("SplitArrayElementsStore<").append(this.object).append(">");
        return str.toString();
    }
}

