/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.typestate;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.PointsToStats;
import com.oracle.graal.pointsto.typestate.TypeState;
import java.util.Collections;
import java.util.Iterator;

public class SingleTypeState
extends TypeState {
    protected final AnalysisType type;
    protected final boolean canBeNull;
    protected boolean merged;

    public SingleTypeState(PointsToAnalysis bb, boolean canBeNull, AnalysisType type) {
        this.type = type;
        this.canBeNull = canBeNull;
        this.merged = false;
        PointsToStats.registerTypeState(bb, this);
    }

    protected SingleTypeState(PointsToAnalysis bb, boolean canBeNull, SingleTypeState other) {
        this.type = other.type;
        this.canBeNull = canBeNull;
        this.merged = other.merged;
        PointsToStats.registerTypeState(bb, this);
    }

    @Override
    public final int typesCount() {
        return 1;
    }

    @Override
    public int objectsCount() {
        return 1;
    }

    @Override
    public final boolean canBeNull() {
        return this.canBeNull;
    }

    @Override
    public final AnalysisType exactType() {
        return this.type;
    }

    @Override
    public final boolean containsType(AnalysisType exactType) {
        return this.type.equals(exactType);
    }

    @Override
    protected final Iterator<AnalysisType> typesIterator(BigBang bb) {
        return SingleTypeState.singletonIterator(this.type);
    }

    @Override
    public Iterator<AnalysisObject> objectsIterator(BigBang bb) {
        return SingleTypeState.singletonIterator(this.type.getContextInsensitiveAnalysisObject());
    }

    @Override
    protected Iterator<AnalysisObject> objectsIterator(AnalysisType t) {
        return this.type.equals(t) ? SingleTypeState.singletonIterator(this.type.getContextInsensitiveAnalysisObject()) : Collections.emptyIterator();
    }

    protected static <T> Iterator<T> singletonIterator(final T object) {
        return new Iterator<T>(){
            boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public T next() {
                this.hasNext = false;
                return object;
            }
        };
    }

    @Override
    public TypeState forCanBeNull(PointsToAnalysis bb, boolean stateCanBeNull) {
        if (stateCanBeNull == this.canBeNull()) {
            return this;
        }
        return new SingleTypeState(bb, stateCanBeNull, this);
    }

    @Override
    public void noteMerge(PointsToAnalysis bb) {
        assert (bb.analysisPolicy().isMergingEnabled()) : "policy mismatch";
        if (!this.merged) {
            this.type.getContextInsensitiveAnalysisObject().noteMerge(bb);
            this.merged = true;
        }
    }

    @Override
    public boolean isMerged() {
        return this.merged;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + this.type.hashCode();
        result = 31 * result + (this.canBeNull ? 1 : 0);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleTypeState that = (SingleTypeState)o;
        return this.canBeNull == that.canBeNull && this.exactType().equals(that.exactType());
    }

    public String toString() {
        return "SingleType<" + this.type.getName() + ", " + (this.canBeNull ? "null," : "") + ">";
    }
}

