/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.heap;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.flow.AnalysisParsedGraph;
import com.oracle.graal.pointsto.heap.ImageHeap;
import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.heap.ImageHeapInstance;
import com.oracle.graal.pointsto.heap.ImageHeapObjectArray;
import com.oracle.graal.pointsto.heap.ImageHeapPrimitiveArray;
import com.oracle.graal.pointsto.heap.ImageHeapRelocatableConstant;
import com.oracle.graal.pointsto.heap.ImageLayerSnapshotUtil;
import com.oracle.graal.pointsto.heap.ImageLayerWriterHelper;
import com.oracle.graal.pointsto.infrastructure.OriginalFieldProvider;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.AnalysisFuture;
import com.oracle.svm.util.FileDumpingUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.runtime.SwitchBootstraps;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.IntStream;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.nodes.EncodedGraph;
import jdk.graal.compiler.nodes.spi.IdentityHashCodeProvider;
import jdk.graal.compiler.util.ObjectCopier;
import jdk.graal.compiler.util.json.JsonWriter;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MethodHandleAccessProvider;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.AnnotationAccess;

public class ImageLayerWriter {
    protected ImageLayerSnapshotUtil imageLayerSnapshotUtil;
    private ImageLayerWriterHelper imageLayerWriterHelper;
    private ImageHeap imageHeap;
    protected AnalysisUniverse aUniverse;
    private IdentityHashMap<String, String> internedStringsIdentityMap;
    protected final EconomicMap<String, Object> jsonMap;
    protected final List<Integer> constantsToRelink;
    private final Set<Integer> persistedTypeIds;
    private final Set<Integer> persistedMethodIds;
    protected final Map<String, EconomicMap<String, Object>> typesMap;
    protected final Map<String, EconomicMap<String, Object>> methodsMap;
    protected final Map<String, Map<String, Object>> fieldsMap;
    private final Map<String, EconomicMap<String, Object>> constantsMap;
    private FileInfo fileInfo;
    private GraphsOutput graphsOutput;
    private final boolean useSharedLayerGraphs;
    private final boolean useSharedLayerStrengthenedGraphs;
    protected final Set<AnalysisFuture<Void>> elementsToPersist = ConcurrentHashMap.newKeySet();

    public ImageLayerWriter() {
        this(true);
    }

    public ImageLayerWriter(boolean useSharedLayerGraphs) {
        this.useSharedLayerGraphs = useSharedLayerGraphs;
        this.useSharedLayerStrengthenedGraphs = false;
        this.jsonMap = EconomicMap.create();
        this.constantsToRelink = new ArrayList<Integer>();
        this.persistedTypeIds = ConcurrentHashMap.newKeySet();
        this.persistedMethodIds = ConcurrentHashMap.newKeySet();
        this.typesMap = new ConcurrentHashMap<String, EconomicMap<String, Object>>();
        this.methodsMap = new ConcurrentHashMap<String, EconomicMap<String, Object>>();
        this.fieldsMap = new ConcurrentHashMap<String, Map<String, Object>>();
        this.constantsMap = new ConcurrentHashMap<String, EconomicMap<String, Object>>();
    }

    public void setImageLayerSnapshotUtil(ImageLayerSnapshotUtil imageLayerSnapshotUtil) {
        this.imageLayerSnapshotUtil = imageLayerSnapshotUtil;
    }

    public void setInternedStringsIdentityMap(IdentityHashMap<String, String> map) {
        this.internedStringsIdentityMap = map;
    }

    public void setImageHeap(ImageHeap heap) {
        this.imageHeap = heap;
    }

    public void setImageLayerWriterHelper(ImageLayerWriterHelper imageLayerWriterHelper) {
        this.imageLayerWriterHelper = imageLayerWriterHelper;
    }

    public void setSnapshotFileInfo(Path layerSnapshotPath, String fileName, String suffix) {
        this.fileInfo = new FileInfo(layerSnapshotPath, fileName, suffix);
    }

    public void openGraphsOutput(Path layerGraphsPath, String fileName, String suffix) {
        AnalysisError.guarantee(this.graphsOutput == null, "Graphs file has already been opened", new Object[0]);
        this.graphsOutput = new GraphsOutput(layerGraphsPath, fileName, suffix);
    }

    public void setAnalysisUniverse(AnalysisUniverse aUniverse) {
        this.aUniverse = aUniverse;
    }

    public void dumpFiles() {
        this.graphsOutput.finish();
        FileDumpingUtil.dumpFile((Path)this.fileInfo.layerFilePath, (String)this.fileInfo.fileName, (String)this.fileInfo.suffix, outputStream -> {
            try (JsonWriter jw = new JsonWriter((Writer)new PrintWriter((OutputStream)outputStream));){
                jw.print(this.jsonMap);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void initializeExternalValues() {
        this.imageLayerSnapshotUtil.initializeExternalValues();
    }

    public void persistImageHeapSize(long imageHeapSize) {
        this.jsonMap.put((Object)"image heap size", (Object)String.valueOf(imageHeapSize));
    }

    public void persistAnalysisInfo() {
        this.persistHook();
        this.jsonMap.put((Object)"next type id", (Object)this.aUniverse.getNextTypeId());
        this.jsonMap.put((Object)"next method id", (Object)this.aUniverse.getNextMethodId());
        this.jsonMap.put((Object)"next field id", (Object)this.aUniverse.getNextFieldId());
        this.jsonMap.put((Object)"next constant id", (Object)ImageHeapConstant.getCurrentId());
        for (AnalysisType analysisType : this.aUniverse.getTypes().stream().filter(AnalysisType::isTrackedAcrossLayers).toList()) {
            this.checkTypeStability(analysisType);
            this.persistType(analysisType);
        }
        this.jsonMap.put((Object)"types", this.typesMap);
        for (AnalysisMethod analysisMethod : this.aUniverse.getMethods().stream().filter(AnalysisMethod::isTrackedAcrossLayers).toList()) {
            this.persistMethod(analysisMethod);
        }
        this.jsonMap.put((Object)"methods", this.methodsMap);
        for (AnalysisField analysisField : this.aUniverse.getFields().stream().filter(AnalysisField::isTrackedAcrossLayers).toList()) {
            this.persistField(analysisField);
        }
        this.jsonMap.put((Object)"fields", this.fieldsMap);
        for (Map.Entry entry : this.imageHeap.getReachableObjects().entrySet()) {
            for (ImageHeapConstant imageHeapConstant : (Set)entry.getValue()) {
                this.persistConstant(-1, -1, imageHeapConstant);
            }
        }
        for (AnalysisFuture analysisFuture : this.elementsToPersist) {
            analysisFuture.ensureDone();
        }
        this.jsonMap.put((Object)"constants", this.constantsMap);
        this.jsonMap.put((Object)"constants to relink", this.constantsToRelink);
    }

    private void persistAnnotations(AnnotatedElement annotatedElement, EconomicMap<String, Object> typeMap) {
        Class[] annotationTypes = AnnotationAccess.getAnnotationTypes((AnnotatedElement)annotatedElement);
        this.persistAnnotations(annotatedElement, typeMap, annotationTypes);
    }

    protected void persistAnnotations(AnnotatedElement annotatedElement, EconomicMap<String, Object> typeMap, Class<? extends Annotation>[] annotationTypes) {
        typeMap.put((Object)"annotations", Arrays.stream(annotationTypes).map(Class::getName).toList());
    }

    protected void persistHook() {
    }

    public boolean isTypePersisted(AnalysisType type) {
        return this.persistedTypeIds.contains(type.getId());
    }

    protected void persistType(AnalysisType type) {
        if (!this.persistedTypeIds.add(type.getId())) {
            return;
        }
        String typeIdentifier = this.imageLayerSnapshotUtil.getTypeIdentifier(type);
        AnalysisType superclass = type.getSuperclass();
        if (superclass != null) {
            this.persistType(superclass);
        }
        for (AnalysisType interfaceType : type.getInterfaces()) {
            this.persistType(interfaceType);
        }
        EconomicMap typeMap = EconomicMap.create();
        this.persistType(type, (EconomicMap<String, Object>)typeMap);
        if (this.typesMap.containsKey(typeIdentifier)) {
            throw GraalError.shouldNotReachHere((String)("The type identifier should be unique, but " + typeIdentifier + " got added twice."));
        }
        this.typesMap.put(typeIdentifier, (EconomicMap<String, Object>)typeMap);
    }

    protected void persistType(AnalysisType type, EconomicMap<String, Object> typeMap) {
        typeMap.put((Object)"id", (Object)type.getId());
        ArrayList<Integer> fields = new ArrayList<Integer>();
        for (ResolvedJavaField field2 : type.getInstanceFields(true)) {
            fields.add(((AnalysisField)field2).getId());
        }
        typeMap.put((Object)"fields", fields);
        typeMap.put((Object)"class java name", (Object)type.toJavaName());
        typeMap.put((Object)"class name", (Object)type.getName());
        typeMap.put((Object)"modifiers", (Object)type.getModifiers());
        typeMap.put((Object)"is interface", (Object)type.isInterface());
        typeMap.put((Object)"is enum", (Object)type.isEnum());
        typeMap.put((Object)"is initialized", (Object)type.isInitialized());
        typeMap.put((Object)"is linked", (Object)type.isLinked());
        typeMap.put((Object)"source file name", (Object)type.getSourceFileName());
        try {
            AnalysisType enclosingType = type.getEnclosingType();
            if (enclosingType != null) {
                typeMap.put((Object)"enclosing type", (Object)enclosingType.getId());
            }
        }
        catch (AnalysisError.TypeNotFoundError typeNotFoundError) {
            // empty catch block
        }
        if (type.isArray()) {
            typeMap.put((Object)"component type", (Object)type.getComponentType().getId());
        }
        if (type.getSuperclass() != null) {
            typeMap.put((Object)"super class", (Object)type.getSuperclass().getId());
        }
        typeMap.put((Object)"interfaces", Arrays.stream(type.getInterfaces()).map(AnalysisType::getId).toList());
        typeMap.put((Object)"instance fields", Arrays.stream(type.getInstanceFields(false)).map(field -> ((AnalysisField)field).getId()).toList());
        typeMap.put((Object)"instance fields with super", Arrays.stream(type.getInstanceFields(true)).map(field -> ((AnalysisField)field).getId()).toList());
        this.persistAnnotations(type, typeMap);
        typeMap.put((Object)"is instantiated", (Object)type.isInstantiated());
        typeMap.put((Object)"is unsafe allocated", (Object)type.isUnsafeAllocated());
        typeMap.put((Object)"is reachable", (Object)type.isReachable());
        this.imageLayerWriterHelper.persistType(type, typeMap);
    }

    public void checkTypeStability(AnalysisType type) {
    }

    public void persistMethod(AnalysisMethod method) {
        if (!this.persistedMethodIds.add(method.getId())) {
            return;
        }
        EconomicMap<String, Object> methodMap = this.getMethodMap(method);
        this.persistMethod(method, methodMap);
    }

    protected void persistMethod(AnalysisMethod method, EconomicMap<String, Object> methodMap) {
        Executable executable = method.getJavaMethod();
        if (methodMap.containsKey((Object)"id")) {
            throw GraalError.shouldNotReachHere((String)("The method identifier should be unique, but " + this.imageLayerSnapshotUtil.getMethodIdentifier(method) + " got added twice."));
        }
        if (executable != null) {
            methodMap.put((Object)"arguments", Arrays.stream(executable.getParameterTypes()).map(Class::getName).toList());
            methodMap.put((Object)"class name", (Object)executable.getDeclaringClass().getName());
        }
        this.persistType((AnalysisType)method.getSignature().getReturnType());
        methodMap.put((Object)"tid", (Object)method.getDeclaringClass().getId());
        methodMap.put((Object)"argument ids", method.getSignature().toParameterList(null).stream().map(AnalysisType::getId).toList());
        methodMap.put((Object)"id", (Object)method.getId());
        methodMap.put((Object)"name", (Object)method.getName());
        methodMap.put((Object)"return type", (Object)((AnalysisType)method.getSignature().getReturnType()).getId());
        methodMap.put((Object)"is varArg", (Object)method.isVarArgs());
        methodMap.put((Object)"can be statically bound", (Object)method.canBeStaticallyBound());
        methodMap.put((Object)"modifiers", (Object)method.getModifiers());
        methodMap.put((Object)"is constructor", (Object)method.isConstructor());
        methodMap.put((Object)"is synthetic", (Object)method.isSynthetic());
        byte[] code = method.getCode();
        if (code != null) {
            methodMap.put((Object)"code", ImageLayerWriter.getString(JavaKind.Byte, method.getCode()));
        }
        methodMap.put((Object)"code size", (Object)method.getCodeSize());
        MethodHandleAccessProvider.IntrinsicMethod intrinsicMethod = this.aUniverse.getBigbang().getConstantReflectionProvider().getMethodHandleAccess().lookupMethodHandleIntrinsic((ResolvedJavaMethod)method);
        if (intrinsicMethod != null) {
            methodMap.put((Object)"method handle intrinsic", (Object)intrinsicMethod.name());
        }
        this.persistAnnotations(method, methodMap);
        methodMap.put((Object)"is virtual root method", (Object)method.isVirtualRootMethod());
        methodMap.put((Object)"is direct root method", (Object)method.isDirectRootMethod());
        methodMap.put((Object)"is invoked", (Object)method.isSimplyInvoked());
        methodMap.put((Object)"is implementation invoked", (Object)method.isSimplyImplementationInvoked());
        methodMap.put((Object)"is intrinsic method", (Object)method.isIntrinsicMethod());
        this.imageLayerWriterHelper.persistMethod(method, methodMap);
    }

    public boolean isMethodPersisted(AnalysisMethod method) {
        String name = this.imageLayerSnapshotUtil.getMethodIdentifier(method);
        return this.methodsMap.containsKey(name);
    }

    public void persistMethodGraphs() {
        for (AnalysisMethod method : this.aUniverse.getMethods()) {
            if (!method.isTrackedAcrossLayers()) continue;
            this.persistAnalysisParsedGraph(method);
        }
    }

    public void persistAnalysisParsedGraph(AnalysisMethod method) {
        EconomicMap<String, Object> methodMap = this.getMethodMap(method);
        Object analyzedGraph = method.getGraph();
        if (analyzedGraph instanceof AnalysisParsedGraph) {
            AnalysisParsedGraph analysisParsedGraph = (AnalysisParsedGraph)analyzedGraph;
            if (!methodMap.containsKey((Object)"intrinsic")) {
                if (!this.persistGraph(method, analysisParsedGraph.getEncodedGraph(), methodMap, "analysis parsed graph")) {
                    return;
                }
                methodMap.put((Object)"intrinsic", (Object)analysisParsedGraph.isIntrinsic());
            }
        }
    }

    public void persistMethodStrengthenedGraph(AnalysisMethod method) {
        if (!this.useSharedLayerStrengthenedGraphs) {
            return;
        }
        EconomicMap<String, Object> methodMap = this.getMethodMap(method);
        if (!methodMap.containsKey((Object)"strengthened graph")) {
            EncodedGraph analyzedGraph = method.getAnalyzedGraph();
            this.persistGraph(method, analyzedGraph, methodMap, "strengthened graph");
        }
    }

    private boolean persistGraph(AnalysisMethod method, EncodedGraph analyzedGraph, EconomicMap<String, Object> methodMap, String graphTag) {
        if (!this.useSharedLayerGraphs) {
            return false;
        }
        byte[] encodedGraph = ObjectCopier.encode((ObjectCopier.Encoder)this.imageLayerSnapshotUtil.getGraphEncoder(this), (Object)analyzedGraph);
        if (ImageLayerWriter.contains(encodedGraph, "$$Lambda".getBytes(StandardCharsets.UTF_8))) {
            throw AnalysisError.shouldNotReachHere("The graph for the method %s contains a reference to a lambda type, which cannot be decoded: %s".formatted(method, encodedGraph));
        }
        String location = this.graphsOutput.add(encodedGraph);
        methodMap.put((Object)graphTag, (Object)location);
        return true;
    }

    private static boolean contains(byte[] data, byte[] seq) {
        block0: for (int i = 0; i <= data.length - seq.length; ++i) {
            for (int j = 0; j < seq.length; ++j) {
                if (data[i + j] != seq[j]) continue block0;
            }
            return true;
        }
        return false;
    }

    private EconomicMap<String, Object> getMethodMap(AnalysisMethod method) {
        String name = this.imageLayerSnapshotUtil.getMethodIdentifier(method);
        EconomicMap methodMap = this.methodsMap.get(name);
        if (methodMap == null) {
            methodMap = EconomicMap.create();
            this.methodsMap.put(name, (EconomicMap<String, Object>)methodMap);
        }
        return methodMap;
    }

    protected void persistField(AnalysisField field) {
        EconomicMap fieldMap = EconomicMap.create();
        this.persistField(field, (EconomicMap<String, Object>)fieldMap);
        Field originalField = OriginalFieldProvider.getJavaField(field);
        if (originalField != null && !originalField.getDeclaringClass().equals(field.getDeclaringClass().getJavaClass())) {
            fieldMap.put((Object)"class name", (Object)originalField.getDeclaringClass().getName());
        }
        fieldMap.put((Object)"is static", (Object)field.isStatic());
        fieldMap.put((Object)"is internal", (Object)field.isInternal());
        fieldMap.put((Object)"is synthetic", (Object)field.isSynthetic());
        fieldMap.put((Object)"field type", (Object)field.getType().getId());
        fieldMap.put((Object)"modifiers", (Object)field.getModifiers());
        fieldMap.put((Object)"position", (Object)field.getPosition());
        this.persistAnnotations(field, (EconomicMap<String, Object>)fieldMap);
        String tid = String.valueOf(field.getDeclaringClass().getId());
        this.fieldsMap.computeIfAbsent(tid, key -> new ConcurrentHashMap()).put(field.getName(), fieldMap);
    }

    protected void persistField(AnalysisField field, EconomicMap<String, Object> fieldMap) {
        fieldMap.put((Object)"id", (Object)field.getId());
        fieldMap.put((Object)"accessed", (Object)(field.getAccessedReason() != null ? 1 : 0));
        fieldMap.put((Object)"read", (Object)(field.getReadReason() != null ? 1 : 0));
        fieldMap.put((Object)"written", (Object)(field.getWrittenReason() != null ? 1 : 0));
        fieldMap.put((Object)"folded", (Object)(field.getFoldedReason() != null ? 1 : 0));
    }

    protected void persistConstant(int parentId, int index, ImageHeapConstant imageHeapConstant) {
        if (!this.constantsMap.containsKey(Integer.toString(this.getConstantId(imageHeapConstant)))) {
            EconomicMap constantMap = EconomicMap.create();
            this.persistConstant(parentId, index, imageHeapConstant, (EconomicMap<String, Object>)constantMap);
        }
    }

    protected void persistConstant(int parentId, int index, ImageHeapConstant imageHeapConstant, EconomicMap<String, Object> constantMap) {
        int id = this.getConstantId(imageHeapConstant);
        this.constantsMap.put(Integer.toString(id), constantMap);
        constantMap.put((Object)"tid", (Object)imageHeapConstant.getType().getId());
        IdentityHashCodeProvider identityHashCodeProvider = (IdentityHashCodeProvider)this.aUniverse.getBigbang().getConstantReflectionProvider();
        int identityHashCode = identityHashCodeProvider.identityHashCode((JavaConstant)imageHeapConstant);
        constantMap.put((Object)"identityHashCode", (Object)identityHashCode);
        ImageHeapConstant imageHeapConstant2 = imageHeapConstant;
        Objects.requireNonNull(imageHeapConstant2);
        ImageHeapConstant imageHeapConstant3 = imageHeapConstant2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ImageHeapInstance.class, ImageHeapObjectArray.class, ImageHeapPrimitiveArray.class, ImageHeapRelocatableConstant.class}, (Object)imageHeapConstant3, n)) {
            case 0: {
                ImageHeapInstance imageHeapInstance = (ImageHeapInstance)imageHeapConstant3;
                Object[] fieldValues = imageHeapInstance.isReaderInstalled() ? imageHeapInstance.getFieldValues() : null;
                this.persistConstant(id, imageHeapConstant.getType(), constantMap, "instance", fieldValues);
                this.persistConstantRelinkingInfo(constantMap, imageHeapConstant, this.aUniverse.getBigbang());
                break;
            }
            case 1: {
                ImageHeapObjectArray imageHeapObjectArray = (ImageHeapObjectArray)imageHeapConstant3;
                this.persistConstant(id, imageHeapConstant.getType(), constantMap, "array", imageHeapObjectArray.getElementValues());
                break;
            }
            case 2: {
                ImageHeapPrimitiveArray imageHeapPrimitiveArray = (ImageHeapPrimitiveArray)imageHeapConstant3;
                constantMap.put((Object)"constant type", (Object)"primitive array");
                constantMap.put((Object)"data", ImageLayerWriter.getString(imageHeapPrimitiveArray.getType().getComponentType().getJavaKind(), imageHeapPrimitiveArray.getArray()));
                break;
            }
            case 3: {
                ImageHeapRelocatableConstant relocatableConstant = (ImageHeapRelocatableConstant)imageHeapConstant3;
                constantMap.put((Object)"constant type", (Object)"relocation constant");
                constantMap.put((Object)"data", (Object)relocatableConstant.getConstantData().key);
                break;
            }
            default: {
                throw AnalysisError.shouldNotReachHere("Unexpected constant type " + String.valueOf(imageHeapConstant));
            }
        }
        if (!this.constantsToRelink.contains(id) && parentId != -1) {
            constantMap.put((Object)"parent constant id", (Object)parentId);
            assert (index != -1) : "Tried to persist child constant %s from parent constant %d, but got index %d".formatted(imageHeapConstant, parentId, index);
            constantMap.put((Object)"parent constant index", (Object)index);
        }
    }

    protected int getConstantId(ImageHeapConstant imageHeapConstant) {
        return imageHeapConstant.constantData.id;
    }

    public void persistConstantRelinkingInfo(EconomicMap<String, Object> constantMap, ImageHeapConstant imageHeapConstant, BigBang bb) {
        Class<?> clazz = imageHeapConstant.getType().getJavaClass();
        JavaConstant hostedObject = imageHeapConstant.getHostedObject();
        boolean simulated = hostedObject == null;
        constantMap.put((Object)"simulated", (Object)simulated);
        if (!simulated) {
            this.persistConstantRelinkingInfo(constantMap, bb, clazz, hostedObject, imageHeapConstant.constantData.id);
        }
    }

    public void persistConstantRelinkingInfo(EconomicMap<String, Object> constantMap, BigBang bb, Class<?> clazz, JavaConstant hostedObject, int id) {
        if (clazz.equals(String.class)) {
            String value = (String)bb.getSnippetReflectionProvider().asObject(String.class, hostedObject);
            if (this.internedStringsIdentityMap.containsKey(value)) {
                constantMap.put((Object)"value", (Object)value);
                this.constantsToRelink.add(id);
            }
        } else if (Enum.class.isAssignableFrom(clazz)) {
            Enum value = (Enum)bb.getSnippetReflectionProvider().asObject(Enum.class, hostedObject);
            constantMap.put((Object)"enum class", (Object)value.getDeclaringClass().getName());
            constantMap.put((Object)"enum name", (Object)value.name());
            this.constantsToRelink.add(id);
        }
    }

    private static List<?> getString(JavaKind kind, Object arrayObject) {
        return switch (kind) {
            case JavaKind.Boolean -> IntStream.range(0, ((boolean[])arrayObject).length).mapToObj(idx -> ((boolean[])arrayObject)[idx]).toList();
            case JavaKind.Byte -> IntStream.range(0, ((byte[])arrayObject).length).mapToObj(idx -> ((byte[])arrayObject)[idx]).toList();
            case JavaKind.Short -> IntStream.range(0, ((short[])arrayObject).length).mapToObj(idx -> ((short[])arrayObject)[idx]).toList();
            case JavaKind.Char -> new String((char[])arrayObject).chars().boxed().toList();
            case JavaKind.Int -> Arrays.stream((int[])arrayObject).boxed().toList();
            case JavaKind.Long -> Arrays.stream((long[])arrayObject).mapToObj(String::valueOf).toList();
            case JavaKind.Float -> IntStream.range(0, ((float[])arrayObject).length).mapToObj(idx -> String.valueOf(((float[])arrayObject)[idx])).toList();
            case JavaKind.Double -> Arrays.stream((double[])arrayObject).mapToObj(String::valueOf).toList();
            default -> throw new IllegalArgumentException("Unsupported kind: " + String.valueOf(kind));
        };
    }

    protected void persistConstant(int id, AnalysisType type, EconomicMap<String, Object> constantMap, String constantType, Object[] values) {
        constantMap.put((Object)"constant type", (Object)constantType);
        if (values != null) {
            ArrayList<List<Object>> data = new ArrayList<List<Object>>();
            for (int i = 0; i < values.length; ++i) {
                Object object = values[i];
                if (this.delegateProcessing(data, object)) continue;
                if (object instanceof ImageHeapConstant) {
                    ImageHeapConstant imageHeapConstant = (ImageHeapConstant)object;
                    data.add(List.of("A", Integer.valueOf(this.getConstantId(imageHeapConstant))));
                    this.persistConstant(this.imageLayerSnapshotUtil.getRelinkedFields(type, this.aUniverse.getBigbang().getMetaAccess()).contains(i) ? id : -1, i, imageHeapConstant);
                    continue;
                }
                if (object == JavaConstant.NULL_POINTER) {
                    data.add(List.of("A", Integer.valueOf(-1)));
                    continue;
                }
                if (object instanceof PrimitiveConstant) {
                    PrimitiveConstant primitiveConstant = (PrimitiveConstant)object;
                    JavaKind kind = primitiveConstant.getJavaKind();
                    data.add(List.of(Character.valueOf(kind.getTypeChar()), ImageLayerWriter.getPrimitiveConstantValue(primitiveConstant, kind)));
                    continue;
                }
                AnalysisError.guarantee(object instanceof AnalysisFuture, "Unexpected constant %s", object);
                data.add(List.of("A", Integer.valueOf(-2)));
            }
            constantMap.put((Object)"data", data);
        }
    }

    private static Object getPrimitiveConstantValue(PrimitiveConstant primitiveConstant, JavaKind kind) {
        return switch (kind) {
            case JavaKind.Boolean, JavaKind.Byte, JavaKind.Short, JavaKind.Int, JavaKind.Double -> primitiveConstant.getRawValue();
            case JavaKind.Char, JavaKind.Long, JavaKind.Float -> String.valueOf(primitiveConstant.getRawValue());
            default -> throw new IllegalArgumentException("Unsupported kind: " + String.valueOf(kind));
        };
    }

    protected boolean delegateProcessing(List<List<Object>> data, Object constant) {
        return false;
    }

    private record FileInfo(Path layerFilePath, String fileName, String suffix) {
    }

    private static class GraphsOutput {
        private final Path path;
        private final Path tempPath;
        private final FileChannel tempChannel;
        private final AtomicLong currentOffset = new AtomicLong(0L);

        GraphsOutput(Path path, String fileName, String suffix) {
            this.path = path;
            this.tempPath = FileDumpingUtil.createTempFile((Path)path.getParent(), (String)fileName, (String)suffix);
            try {
                this.tempChannel = FileChannel.open(this.tempPath, EnumSet.of(StandardOpenOption.WRITE), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw GraalError.shouldNotReachHere((Throwable)e, (String)"Error opening temporary graphs file.");
            }
        }

        String add(byte[] encodedGraph) {
            long offset = this.currentOffset.getAndAdd(encodedGraph.length);
            try {
                this.tempChannel.write(ByteBuffer.wrap(encodedGraph), offset);
            }
            catch (Exception e) {
                throw GraalError.shouldNotReachHere((Throwable)e, (String)"Error during graphs file dumping.");
            }
            return "@" + offset + "[" + encodedGraph.length + "]";
        }

        void finish() {
            try {
                this.tempChannel.close();
                FileDumpingUtil.moveTryAtomically((Path)this.tempPath, (Path)this.path);
            }
            catch (Exception e) {
                throw GraalError.shouldNotReachHere((Throwable)e, (String)"Error during graphs file dumping.");
            }
        }
    }
}

