/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow.context.bytecode;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.AbstractStaticInvokeTypeFlow;
import com.oracle.graal.pointsto.flow.ActualReturnTypeFlow;
import com.oracle.graal.pointsto.flow.CallSiteSensitiveMethodTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodFlowsGraphClone;
import com.oracle.graal.pointsto.flow.MethodFlowsGraphInfo;
import com.oracle.graal.pointsto.flow.MethodTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.AnalysisContext;
import com.oracle.graal.pointsto.flow.context.bytecode.BytecodeAnalysisContext;
import com.oracle.graal.pointsto.flow.context.bytecode.BytecodeSensitiveAnalysisPolicy;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.util.LightImmutableCollection;
import com.oracle.svm.common.meta.MultiMethod;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.stream.Collectors;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.common.JVMCIError;

final class BytecodeSensitiveStaticInvokeTypeFlow
extends AbstractStaticInvokeTypeFlow {
    private volatile Object calleesFlows;
    private static final AtomicReferenceFieldUpdater<BytecodeSensitiveStaticInvokeTypeFlow, Object> CALLEES_FLOWS_ACCESSOR = AtomicReferenceFieldUpdater.newUpdater(BytecodeSensitiveStaticInvokeTypeFlow.class, Object.class, "calleesFlows");
    private AnalysisContext callerContext;

    BytecodeSensitiveStaticInvokeTypeFlow(BytecodePosition invokeLocation, AnalysisType receiverType, PointsToAnalysisMethod targetMethod, TypeFlow<?>[] actualParameters, ActualReturnTypeFlow actualReturn, MultiMethod.MultiMethodKey callerMultiMethodKey) {
        super(invokeLocation, receiverType, targetMethod, actualParameters, actualReturn, callerMultiMethodKey);
    }

    private BytecodeSensitiveStaticInvokeTypeFlow(PointsToAnalysis bb, MethodFlowsGraph methodFlows, BytecodeSensitiveStaticInvokeTypeFlow original) {
        super(bb, methodFlows, original);
        this.callerContext = ((MethodFlowsGraphClone)methodFlows).context();
    }

    @Override
    public TypeFlow<BytecodePosition> copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
        return new BytecodeSensitiveStaticInvokeTypeFlow(bb, methodFlows, this);
    }

    @Override
    public boolean needsInitialization() {
        return true;
    }

    @Override
    public void initFlow(PointsToAnalysis bb) {
        if (this.isClone() && this.isFlowEnabled()) {
            bb.postFlow(this);
        }
    }

    @Override
    public void update(PointsToAnalysis bb) {
        assert (this.isFlowEnabled()) : "The linking should only be triggered for enabled flows: " + String.valueOf(this);
        assert (this.isClone()) : "Only clones should be updated: " + String.valueOf(this);
        JVMCIError.guarantee((boolean)LightImmutableCollection.isEmpty(this, CALLEES_ACCESSOR), (String)"static invoke updated multiple times!", (Object[])new Object[0]);
        if (!this.targetMethod.getWrapped().getDeclaringClass().isLinked()) {
            return;
        }
        this.initializeCallees(bb);
        PointsToAnalysisMethod singleMethod = (PointsToAnalysisMethod)LightImmutableCollection.toSingleElement(this, CALLEES_ACCESSOR);
        if (singleMethod != null) {
            LightImmutableCollection.initializeNonEmpty(this, CALLEES_FLOWS_ACCESSOR, this.getCalleeFlow(bb, singleMethod));
        } else {
            Collection collection = LightImmutableCollection.toCollection(this, CALLEES_ACCESSOR);
            Set flows = collection.stream().map(callee -> this.getCalleeFlow(bb, (PointsToAnalysisMethod)callee)).collect(Collectors.toUnmodifiableSet());
            LightImmutableCollection.initializeNonEmpty(this, CALLEES_FLOWS_ACCESSOR, flows);
        }
    }

    private MethodFlowsGraph getCalleeFlow(PointsToAnalysis bb, PointsToAnalysisMethod callee) {
        MethodTypeFlow calleeTypeFlow = callee.getTypeFlow();
        BytecodeAnalysisContext calleeContext = BytecodeSensitiveAnalysisPolicy.contextPolicy(bb).staticCalleeContext(bb, (BytecodePosition)this.source, (BytecodeAnalysisContext)this.callerContext, calleeTypeFlow);
        MethodFlowsGraphInfo calleeFlows = ((CallSiteSensitiveMethodTypeFlow)calleeTypeFlow).addContext(bb, calleeContext, this);
        this.linkCallee(bb, true, calleeFlows);
        return (MethodFlowsGraph)calleeFlows;
    }

    @Override
    public Collection<MethodFlowsGraph> getAllNonStubCalleesFlows(PointsToAnalysis bb) {
        return LightImmutableCollection.toCollection(this, CALLEES_FLOWS_ACCESSOR);
    }
}

