/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config.conditional;

import com.oracle.svm.configure.config.ConfigurationPredefinedClass;
import com.oracle.svm.configure.config.ConfigurationType;
import com.oracle.svm.configure.config.PredefinedClassesConfiguration;
import com.oracle.svm.configure.config.ProxyConfiguration;
import com.oracle.svm.configure.config.ResourceConfiguration;
import com.oracle.svm.configure.config.SerializationConfiguration;
import com.oracle.svm.configure.config.SerializationConfigurationLambdaCapturingType;
import com.oracle.svm.configure.config.SerializationConfigurationType;
import com.oracle.svm.configure.config.TypeConfiguration;
import com.oracle.svm.configure.filters.ComplexFilter;
import com.oracle.svm.core.configure.ConditionalElement;
import com.oracle.svm.core.configure.ConfigurationTypeDescriptor;
import java.util.List;
import org.graalvm.nativeimage.impl.UnresolvedConfigurationCondition;

public class ConditionalConfigurationPredicate
implements TypeConfiguration.Predicate,
ProxyConfiguration.Predicate,
ResourceConfiguration.Predicate,
SerializationConfiguration.Predicate,
PredefinedClassesConfiguration.Predicate {
    private final ComplexFilter filter;

    public ConditionalConfigurationPredicate(ComplexFilter filter) {
        this.filter = filter;
    }

    @Override
    public boolean testIncludedType(ConditionalElement<ConfigurationTypeDescriptor> conditionalElement, ConfigurationType type) {
        return this.testTypeDescriptor(conditionalElement.condition(), type.getTypeDescriptor());
    }

    @Override
    public boolean testProxyInterfaceList(ConditionalElement<List<String>> conditionalElement) {
        return !this.filter.includes(conditionalElement.condition().getTypeName());
    }

    @Override
    public boolean testIncludedResource(ConditionalElement<String> condition) {
        return !this.filter.includes(condition.condition().getTypeName());
    }

    @Override
    public boolean testIncludedGlob(ConditionalElement<ResourceConfiguration.ResourceEntry> condition) {
        return !this.filter.includes(condition.condition().getTypeName());
    }

    @Override
    public boolean testIncludedBundle(ConditionalElement<String> condition, ResourceConfiguration.BundleConfiguration bundleConfiguration) {
        return !this.filter.includes(condition.condition().getTypeName());
    }

    @Override
    public boolean testSerializationType(SerializationConfigurationType type) {
        return !this.filter.includes(type.getCondition().getTypeName()) || !this.filter.includes(type.getQualifiedJavaName());
    }

    @Override
    public boolean testLambdaSerializationType(SerializationConfigurationLambdaCapturingType type) {
        return !this.filter.includes(type.getCondition().getTypeName()) || !this.filter.includes(type.getQualifiedJavaName());
    }

    @Override
    public boolean testPredefinedClass(ConfigurationPredefinedClass clazz) {
        return clazz.getNameInfo() != null && !this.filter.includes(clazz.getNameInfo());
    }

    private boolean testTypeDescriptor(UnresolvedConfigurationCondition condition, ConfigurationTypeDescriptor typeDescriptor) {
        if (!this.filter.includes(condition.getTypeName())) {
            return true;
        }
        for (String typeName : typeDescriptor.getAllQualifiedJavaNames()) {
            if (this.filter.includes(typeName)) continue;
            return true;
        }
        return false;
    }
}

