/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.foreign;

import com.oracle.svm.core.OS;
import com.oracle.svm.core.foreign.Util_java_lang_foreign_SymbolLookup;
import com.oracle.svm.core.jdk.NativeLibraries;
import com.oracle.svm.core.util.BasedOnJDKClass;
import java.lang.foreign.SymbolLookup;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import jdk.internal.foreign.SystemLookup;

@BasedOnJDKClass(value=SystemLookup.class)
public final class RuntimeSystemLookup {
    static final SymbolLookup INSTANCE = RuntimeSystemLookup.makeSystemLookup();

    public static SymbolLookup makeSystemLookup() {
        if (OS.WINDOWS.isCurrent()) {
            Path system32 = Path.of(System.getenv("SystemRoot"), "System32");
            Path ucrtbase = system32.resolve("ucrtbase.dll");
            Path msvcrt = system32.resolve("msvcrt.dll");
            boolean useUCRT = Files.exists(ucrtbase, new LinkOption[0]);
            Path stdLib = useUCRT ? ucrtbase : msvcrt;
            return Util_java_lang_foreign_SymbolLookup.libraryLookup(NativeLibraries::loadLibraryPlatformSpecific, List.of(stdLib));
        }
        return Util_java_lang_foreign_SymbolLookup.libraryLookup(NativeLibraries::loadLibraryPlatformSpecific, List.of("libc.so.6", "libm.so.6", "libdl.so.2"));
    }
}

