/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.util;

import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.util.CPUType;
import com.oracle.svm.util.LogUtils;
import com.oracle.svm.util.StringUtil;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public final class CPUTypeAMD64
extends Enum<CPUTypeAMD64>
implements CPUType {
    public static final /* enum */ CPUTypeAMD64 X86_64 = new CPUTypeAMD64("x86-64", AMD64.CPUFeature.CMOV, AMD64.CPUFeature.CX8, AMD64.CPUFeature.FXSR, AMD64.CPUFeature.MMX, AMD64.CPUFeature.SSE, AMD64.CPUFeature.SSE2);
    public static final /* enum */ CPUTypeAMD64 X86_64_V1 = new CPUTypeAMD64("x86-64-v1", X86_64, new AMD64.CPUFeature[0]);
    public static final /* enum */ CPUTypeAMD64 X86_64_V2 = new CPUTypeAMD64("x86-64-v2", X86_64_V1, AMD64.CPUFeature.POPCNT, AMD64.CPUFeature.SSE3, AMD64.CPUFeature.SSE4_1, AMD64.CPUFeature.SSE4_2, AMD64.CPUFeature.SSSE3);
    public static final /* enum */ CPUTypeAMD64 X86_64_V3 = new CPUTypeAMD64("x86-64-v3", X86_64_V2, AMD64.CPUFeature.AVX, AMD64.CPUFeature.AVX2, AMD64.CPUFeature.BMI1, AMD64.CPUFeature.BMI2, AMD64.CPUFeature.F16C, AMD64.CPUFeature.FMA, AMD64.CPUFeature.LZCNT);
    public static final /* enum */ CPUTypeAMD64 X86_64_V4 = new CPUTypeAMD64("x86-64-v4", X86_64_V3, AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512BW, AMD64.CPUFeature.AVX512CD, AMD64.CPUFeature.AVX512DQ, AMD64.CPUFeature.AVX512VL);
    public static final /* enum */ CPUTypeAMD64 HASWELL = new CPUTypeAMD64("haswell", X86_64, AMD64.CPUFeature.AES, AMD64.CPUFeature.SSE3, AMD64.CPUFeature.SSSE3, AMD64.CPUFeature.SSE4_1, AMD64.CPUFeature.SSE4_2, AMD64.CPUFeature.POPCNT, AMD64.CPUFeature.CLMUL, AMD64.CPUFeature.AVX, AMD64.CPUFeature.F16C, AMD64.CPUFeature.AVX2, AMD64.CPUFeature.BMI1, AMD64.CPUFeature.BMI2, AMD64.CPUFeature.LZCNT, AMD64.CPUFeature.FMA);
    public static final /* enum */ CPUTypeAMD64 SKYLAKE = new CPUTypeAMD64("skylake", HASWELL, AMD64.CPUFeature.ADX, AMD64.CPUFeature.AMD_3DNOW_PREFETCH, AMD64.CPUFeature.FLUSHOPT);
    public static final /* enum */ CPUTypeAMD64 SKYLAKE_AVX512 = new CPUTypeAMD64("skylake-avx512", SKYLAKE, AMD64.CPUFeature.PKU, AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512CD, AMD64.CPUFeature.AVX512VL, AMD64.CPUFeature.AVX512BW, AMD64.CPUFeature.AVX512DQ, AMD64.CPUFeature.CLWB);
    public static final /* enum */ CPUTypeAMD64 COMPATIBILITY = new CPUTypeAMD64("compatibility", X86_64, new AMD64.CPUFeature[0]);
    public static final /* enum */ CPUTypeAMD64 NATIVE = new CPUTypeAMD64("native", CPUTypeAMD64.getNativeOrEmpty());
    private final String name;
    private final CPUTypeAMD64 parent;
    private final EnumSet<AMD64.CPUFeature> specificFeatures;
    private static final /* synthetic */ CPUTypeAMD64[] $VALUES;

    public static CPUTypeAMD64[] values() {
        return (CPUTypeAMD64[])$VALUES.clone();
    }

    public static CPUTypeAMD64 valueOf(String name) {
        return Enum.valueOf(CPUTypeAMD64.class, name);
    }

    private static AMD64.CPUFeature[] getNativeOrEmpty() {
        AMD64.CPUFeature[] empty = new AMD64.CPUFeature[]{};
        Architecture architecture = GraalAccess.getOriginalTarget().arch;
        if (architecture instanceof AMD64) {
            AMD64 arch = (AMD64)architecture;
            return arch.getFeatures().toArray(empty);
        }
        return empty;
    }

    private CPUTypeAMD64(String cpuTypeName, AMD64.CPUFeature ... features) {
        this(cpuTypeName, (CPUTypeAMD64)null, features);
    }

    private CPUTypeAMD64(String cpuTypeName, CPUTypeAMD64 cpuTypeParent, AMD64.CPUFeature ... features) {
        this.name = cpuTypeName;
        this.parent = cpuTypeParent;
        EnumSet<AMD64.CPUFeature> enumSet = this.specificFeatures = features.length > 0 ? EnumSet.copyOf(List.of(features)) : EnumSet.noneOf(AMD64.CPUFeature.class);
        if (!$assertionsDisabled && this.parent != null) {
            if (!this.parent.getFeatures().stream().noneMatch(this.specificFeatures::contains)) {
                throw new AssertionError((Object)"duplicate features detected but not allowed");
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public CPUTypeAMD64 getParent() {
        return this.parent;
    }

    @Override
    public String getSpecificFeaturesString() {
        return this.specificFeatures.stream().map(Enum::name).collect(Collectors.joining(" + "));
    }

    public EnumSet<AMD64.CPUFeature> getFeatures() {
        if (this.parent == null) {
            return this.specificFeatures;
        }
        return EnumSet.copyOf(Stream.concat(this.parent.getFeatures().stream(), this.specificFeatures.stream()).toList());
    }

    public static String getDefaultName(boolean printFallbackWarning) {
        if (NATIVE.getFeatures().containsAll(X86_64_V3.getFeatures())) {
            return X86_64_V3.getName();
        }
        if (printFallbackWarning) {
            LogUtils.warning((String)"The host machine does not support all features of '%s'. Falling back to '%s' for best compatibility.", (Object[])new Object[]{X86_64_V3.getName(), SubstrateOptionsParser.commandArgument(NativeImageOptions.MicroArchitecture, COMPATIBILITY.getName())});
        }
        return COMPATIBILITY.getName();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static EnumSet<AMD64.CPUFeature> getSelectedFeatures() {
        String value = NativeImageOptions.MicroArchitecture.getValue();
        if (value == null) {
            value = CPUTypeAMD64.getDefaultName(true);
        }
        return CPUTypeAMD64.getCPUFeaturesForArch(value);
    }

    public static EnumSet<AMD64.CPUFeature> getCPUFeaturesForArch(String marchValue) {
        CPUTypeAMD64 value = CPUTypeAMD64.typeOf(marchValue);
        if (value == null) {
            throw UserError.abort("Unsupported architecture '%s'. Please adjust '%s'. On AMD64, only %s are available.", marchValue, SubstrateOptionsParser.commandArgument(NativeImageOptions.MicroArchitecture, marchValue), StringUtil.joinSingleQuoted(CPUType.toNames(CPUTypeAMD64.values())));
        }
        return value.getFeatures();
    }

    public static boolean nativeSupportsMoreFeaturesThanSelected() {
        EnumSet<AMD64.CPUFeature> selectedFeatures;
        EnumSet<AMD64.CPUFeature> nativeFeatures = NATIVE.getFeatures();
        return nativeFeatures.containsAll(selectedFeatures = CPUTypeAMD64.getSelectedFeatures()) && nativeFeatures.size() > selectedFeatures.size();
    }

    private static CPUTypeAMD64 typeOf(String marchValue) {
        for (CPUTypeAMD64 value : CPUTypeAMD64.values()) {
            if (!value.name.equals(marchValue)) continue;
            return value;
        }
        return null;
    }

    private static /* synthetic */ CPUTypeAMD64[] $values() {
        return new CPUTypeAMD64[]{X86_64, X86_64_V1, X86_64_V2, X86_64_V3, X86_64_V4, HASWELL, SKYLAKE, SKYLAKE_AVX512, COMPATIBILITY, NATIVE};
    }

    static {
        $VALUES = CPUTypeAMD64.$values();
    }
}

