/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.thread;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.fieldvaluetransformer.FieldValueTransformerWithAvailability;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.JavaThreadsFeature;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.util.ConcurrentIdentityHashMap;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.thread.HostedJavaThreadsMetadata;
import com.oracle.svm.hosted.thread.ReachableThreadGroup;
import com.oracle.svm.util.ClassUtil;
import com.oracle.svm.util.ReflectionUtil;
import java.util.Map;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.FieldValueTransformer;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;

@AutomaticallyRegisteredFeature
public class HostedJavaThreadsFeature
extends JavaThreadsFeature {
    final Map<Thread, Boolean> reachableThreads = new ConcurrentIdentityHashMap<Thread, Boolean>();
    final Map<ThreadGroup, ReachableThreadGroup> reachableThreadGroups = new ConcurrentIdentityHashMap<ThreadGroup, ReachableThreadGroup>();
    private boolean sealed;
    private static final String AUTONUMBER_PREFIX = "Thread-";

    public void duringSetup(Feature.DuringSetupAccess access) {
        access.registerObjectReplacer(this::collectReachableObjects);
        RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{"java.lang.ScopedValue"});
        RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{"java.lang.ScopedValue$Cache"});
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess a) {
        a.registerFieldValueTransformer(ReflectionUtil.lookupField(ThreadGroup.class, (String)"ngroups"), (FieldValueTransformer)new FieldValueTransformerWithAvailability(){

            @Override
            public boolean isAvailable() {
                return BuildPhaseProvider.isHostedUniverseBuilt();
            }

            public Object transform(Object receiver, Object originalValue) {
                ThreadGroup group = (ThreadGroup)receiver;
                return HostedJavaThreadsFeature.this.reachableThreadGroups.get((Object)group).ngroups;
            }
        });
        a.registerFieldValueTransformer(ReflectionUtil.lookupField(ThreadGroup.class, (String)"groups"), (FieldValueTransformer)new FieldValueTransformerWithAvailability(){

            @Override
            public boolean isAvailable() {
                return BuildPhaseProvider.isHostedUniverseBuilt();
            }

            public Object transform(Object receiver, Object originalValue) {
                ThreadGroup group = (ThreadGroup)receiver;
                return HostedJavaThreadsFeature.this.reachableThreadGroups.get((Object)group).groups;
            }
        });
    }

    private Object collectReachableObjects(Object original) {
        ThreadGroup group;
        if (original instanceof Thread) {
            Thread thread = (Thread)original;
            if (thread.getState() == Thread.State.NEW) {
                this.registerReachableObject(this.reachableThreads, thread, Boolean.TRUE);
            }
        } else if (original instanceof ThreadGroup && this.registerReachableObject(this.reachableThreadGroups, group = (ThreadGroup)original, new ReachableThreadGroup())) {
            ThreadGroup parent = group.getParent();
            if (parent != null) {
                this.collectReachableObjects(parent);
                this.reachableThreadGroups.get(parent).add(group);
            } else assert (group == PlatformThreads.singleton().systemGroup);
        }
        return original;
    }

    private <K, V> boolean registerReachableObject(Map<K, V> map, K object, V value) {
        boolean result;
        boolean bl = result = map.putIfAbsent(object, value) == null;
        if (this.sealed && result) {
            throw UserError.abort("%s is reachable in the image heap but was not seen during the points-to analysis: %s", ClassUtil.getUnqualifiedName(object.getClass()), object);
        }
        return result;
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess access) {
        FeatureImpl.DuringAnalysisAccessImpl config = (FeatureImpl.DuringAnalysisAccessImpl)access;
        for (ReachableThreadGroup threadGroup : this.reachableThreadGroups.values()) {
            config.rescanObject(threadGroup.groups);
        }
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess a) {
        this.sealed = true;
        long maxThreadId = HostedJavaThreadsMetadata.singleton().maxThreadId;
        int maxAutonumber = HostedJavaThreadsMetadata.singleton().maxAutonumber;
        for (Thread thread : this.reachableThreads.keySet()) {
            maxThreadId = Math.max(maxThreadId, HostedJavaThreadsFeature.threadId(thread));
            maxAutonumber = Math.max(maxAutonumber, HostedJavaThreadsFeature.autonumberOf(thread));
        }
        assert (maxThreadId >= 1L) : "main thread with id 1 must always be found";
        if (ImageLayerBuildingSupport.buildingSharedLayer()) {
            HostedJavaThreadsMetadata.singleton().maxThreadId = maxThreadId;
            HostedJavaThreadsMetadata.singleton().maxAutonumber = maxAutonumber;
        } else {
            JavaThreads.JavaThreadNumberSingleton.singleton().setThreadNumberInfo(maxThreadId, maxAutonumber);
        }
    }

    static int autonumberOf(Thread thread) {
        if (thread.getName().startsWith(AUTONUMBER_PREFIX)) {
            try {
                return Integer.parseInt(thread.getName().substring(AUTONUMBER_PREFIX.length()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }
}

