/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.substitute;

import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.InjectAccessors;
import com.oracle.svm.core.annotate.TargetClass;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;

public class SubstitutionReflectivityFilter {
    public static boolean shouldExclude(Class<?> classObj, AnalysisMetaAccess metaAccess, AnalysisUniverse universe) {
        if (!universe.hostVM().platformSupported(classObj)) {
            return true;
        }
        try {
            AnalysisType analysisClass = metaAccess.lookupJavaType(classObj);
            if (!universe.hostVM().platformSupported((AnnotatedElement)analysisClass)) {
                return true;
            }
            if (analysisClass.isAnnotationPresent(Delete.class)) {
                return true;
            }
        }
        catch (UnsupportedFeatureException ignored) {
            return true;
        }
        return false;
    }

    public static boolean shouldExclude(Executable method, AnalysisMetaAccess metaAccess, AnalysisUniverse universe) {
        if (SubstitutionReflectivityFilter.shouldExclude(method.getDeclaringClass(), metaAccess, universe)) {
            return true;
        }
        if (!universe.hostVM().platformSupported((AnnotatedElement)method)) {
            return true;
        }
        try {
            AnalysisMethod aMethod = metaAccess.lookupJavaMethod(method);
            if (!universe.hostVM().platformSupported((AnnotatedElement)aMethod)) {
                return true;
            }
            if (aMethod.isAnnotationPresent(Delete.class)) {
                return true;
            }
            if (aMethod.isSynthetic() && aMethod.getDeclaringClass().isAnnotationPresent(TargetClass.class)) {
                return true;
            }
        }
        catch (UnsupportedFeatureException ignored) {
            return true;
        }
        return false;
    }

    public static boolean shouldExclude(Field field, AnalysisMetaAccess metaAccess, AnalysisUniverse universe) {
        if (SubstitutionReflectivityFilter.shouldExclude(field.getDeclaringClass(), metaAccess, universe)) {
            return true;
        }
        if (!universe.hostVM().platformSupported((AnnotatedElement)field)) {
            return true;
        }
        try {
            AnalysisField aField = metaAccess.lookupJavaField(field);
            if (!universe.hostVM().platformSupported((AnnotatedElement)aField)) {
                return true;
            }
            if (aField.isAnnotationPresent(Delete.class) || aField.isAnnotationPresent(InjectAccessors.class)) {
                return true;
            }
        }
        catch (UnsupportedFeatureException ignored) {
            return true;
        }
        return false;
    }
}

