/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.pltgot;

import com.oracle.objectfile.SectionName;
import com.oracle.svm.core.pltgot.PLTGOTConfiguration;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.pltgot.CollectPLTGOTCallSitesResolutionSupport;
import com.oracle.svm.hosted.pltgot.GOTEntryAllocator;
import com.oracle.svm.hosted.pltgot.MethodAddressResolutionSupport;
import com.oracle.svm.hosted.pltgot.MethodAddressResolutionSupportFactory;
import com.oracle.svm.hosted.pltgot.PLTGOTOptions;
import com.oracle.svm.hosted.pltgot.PLTSectionSupport;
import com.oracle.svm.hosted.pltgot.PLTStubGenerator;
import java.lang.reflect.Method;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterConfig;
import org.graalvm.nativeimage.ImageSingletons;

public abstract class HostedPLTGOTConfiguration
extends PLTGOTConfiguration {
    public static final SectionName SVM_GOT_SECTION = new SectionName.ProgbitsSectionName("svm_got");
    protected MethodAddressResolutionSupport methodAddressResolutionSupport;
    private final GOTEntryAllocator gotEntryAllocator = new GOTEntryAllocator();
    private PLTSectionSupport pltSectionSupport = new PLTSectionSupport(this.getArchSpecificPLTStubGenerator());
    private HostedMetaAccess hostedMetaAccess;

    public static HostedPLTGOTConfiguration singleton() {
        return (HostedPLTGOTConfiguration)ImageSingletons.lookup(PLTGOTConfiguration.class);
    }

    public abstract Method getArchSpecificResolverAsMethod();

    public abstract Register getGOTPassingRegister(RegisterConfig var1);

    public abstract PLTStubGenerator getArchSpecificPLTStubGenerator();

    public void setHostedMetaAccess(HostedMetaAccess metaAccess) {
        assert (this.hostedMetaAccess == null) : "The field hostedMetaAccess can't be set twice.";
        this.hostedMetaAccess = metaAccess;
    }

    public void initializeMethodAddressResolutionSupport(MethodAddressResolutionSupportFactory methodAddressResolutionSupportFactory) {
        assert (this.methodAddressResolutionSupport == null) : "The field methodAddressResolutionSupport can't be initialized twice.";
        this.methodAddressResolutionSupport = methodAddressResolutionSupportFactory.create();
        if (PLTGOTOptions.PrintPLTGOTCallsInfo.getValue().booleanValue()) {
            this.methodAddressResolutionSupport = new CollectPLTGOTCallSitesResolutionSupport(this.methodAddressResolutionSupport);
        }
        this.methodAddressResolver = this.getMethodAddressResolutionSupport().createMethodAddressResolver();
    }

    public MethodAddressResolutionSupport getMethodAddressResolutionSupport() {
        assert (this.methodAddressResolutionSupport != null) : "Must call initializeMethodAddressResolutionSupport before calling getMethodAddressResolutionSupport";
        return this.methodAddressResolutionSupport;
    }

    public PLTSectionSupport getPLTSectionSupport() {
        return this.pltSectionSupport;
    }

    public void markResolverMethodPatch() {
        this.pltSectionSupport.markResolverMethodPatch(this.getArchSpecificResolverAsHostedMethod());
    }

    public HostedMethod getArchSpecificResolverAsHostedMethod() {
        assert (this.hostedMetaAccess != null) : "Must set hostedMetaAccess before calling getArchSpecificResolverAsHostedMethod";
        return this.hostedMetaAccess.lookupJavaMethod(this.getArchSpecificResolverAsMethod());
    }

    public GOTEntryAllocator getGOTEntryAllocator() {
        return this.gotEntryAllocator;
    }
}

