/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code.amd64;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.code.PatchConsumerFactory;
import com.oracle.svm.core.layeredimagesingleton.FeatureSingleton;
import com.oracle.svm.core.layeredimagesingleton.UnsavedSingleton;
import com.oracle.svm.hosted.code.HostedImageHeapConstantPatch;
import com.oracle.svm.hosted.code.amd64.AMD64HostedPatcher;
import java.util.function.Consumer;
import jdk.graal.compiler.asm.Assembler;
import jdk.graal.compiler.asm.amd64.AMD64BaseAssembler;
import jdk.graal.compiler.code.CompilationResult;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
@Platforms(value={Platform.AMD64.class})
class AMD64HostedPatcherFeature
implements InternalFeature,
FeatureSingleton,
UnsavedSingleton {
    AMD64HostedPatcherFeature() {
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(PatchConsumerFactory.HostedPatchConsumerFactory.class, (Object)new PatchConsumerFactory.HostedPatchConsumerFactory(this){

            @Override
            public Consumer<Assembler.CodeAnnotation> newConsumer(final CompilationResult compilationResult) {
                return new Consumer<Assembler.CodeAnnotation>(this){

                    @Override
                    public void accept(Assembler.CodeAnnotation annotation) {
                        if (annotation instanceof AMD64BaseAssembler.OperandDataAnnotation) {
                            compilationResult.addAnnotation((CompilationResult.CodeAnnotation)new AMD64HostedPatcher((AMD64BaseAssembler.OperandDataAnnotation)annotation));
                        } else if (annotation instanceof AMD64BaseAssembler.AddressDisplacementAnnotation) {
                            AMD64BaseAssembler.AddressDisplacementAnnotation dispAnnotation = (AMD64BaseAssembler.AddressDisplacementAnnotation)annotation;
                            compilationResult.addAnnotation((CompilationResult.CodeAnnotation)new HostedImageHeapConstantPatch(dispAnnotation.operandPosition, (JavaConstant)dispAnnotation.annotation));
                        }
                    }
                };
            }
        });
    }
}

