/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.ClassValueSupport;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public final class ClassValueFeature
implements InternalFeature {
    private static final Field IDENTITY = ReflectionUtil.lookupField(ClassValue.class, (String)"identity");
    private static final Field CLASS_VALUE_MAP = ReflectionUtil.lookupField(Class.class, (String)"classValueMap");

    public void duringSetup(Feature.DuringSetupAccess access) {
        Map<ClassValue<?>, Map<Class<?>, Object>> values = ClassValueSupport.getValues();
        ((FeatureImpl.DuringSetupAccessImpl)access).registerObjectReachableCallback(ClassValue.class, (a1, obj, reason) -> values.computeIfAbsent((ClassValue<?>)obj, k -> new ConcurrentHashMap()));
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess access) {
        Map<ClassValue<?>, Map<Class<?>, Object>> values = ClassValueSupport.getValues();
        FeatureImpl.DuringAnalysisAccessImpl impl = (FeatureImpl.DuringAnalysisAccessImpl)access;
        List types = impl.getUniverse().getTypes();
        HashSet mapsToRescan = new HashSet();
        try {
            for (AnalysisType t : types) {
                Class clazz;
                Map classValueMap;
                if (!t.isReachable() || (classValueMap = (Map)CLASS_VALUE_MAP.get(clazz = t.getJavaClass())) == null) continue;
                for (Map.Entry<ClassValue<?>, Map<Class<?>, Object>> svmClassValueEntry : values.entrySet()) {
                    ClassValue<?> classValue;
                    Object classValueMapKey;
                    Map<Class<?>, Object> svmClassValueMap = svmClassValueEntry.getValue();
                    if (svmClassValueMap.containsKey(clazz) || !classValueMap.containsKey(classValueMapKey = IDENTITY.get(classValue = svmClassValueEntry.getKey()))) continue;
                    Object value = classValue.get(clazz);
                    svmClassValueMap.put(clazz, value == null ? ClassValueSupport.NULL_MARKER : value);
                    if (value == null) continue;
                    mapsToRescan.add(svmClassValueMap);
                }
            }
        }
        catch (IllegalAccessException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
        int numTypes = impl.getUniverse().getTypes().size();
        mapsToRescan.forEach(impl::rescanObject);
        if (numTypes != impl.getUniverse().getTypes().size()) {
            access.requireAnalysisIteration();
        }
    }
}

